/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.VersionNumber;

public class PmdPlugin
extends AbstractCodeQualityPlugin<Pmd> {
    public static final String DEFAULT_PMD_VERSION = "6.21.0";
    private PmdExtension extension;

    @Override
    protected String getToolName() {
        return "PMD";
    }

    @Override
    protected Class<Pmd> getTaskType() {
        return Pmd.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = (PmdExtension)this.project.getExtensions().create("pmd", PmdExtension.class, new Object[]{this.project});
        this.extension.setToolVersion(DEFAULT_PMD_VERSION);
        this.extension.setRuleSets(new ArrayList<String>(Arrays.asList("category/java/errorprone.xml")));
        this.extension.setRuleSetFiles(this.project.getLayout().files(new Object[0]));
        PmdPlugin.conventionMappingOf(this.extension).map("targetJdk", () -> this.getDefaultTargetJdk(this.getJavaPluginConvention().getSourceCompatibility()));
        return this.extension;
    }

    public TargetJdk getDefaultTargetJdk(JavaVersion javaVersion) {
        try {
            return TargetJdk.toVersion(javaVersion.toString());
        }
        catch (IllegalArgumentException ignored) {
            return TargetJdk.VERSION_1_4;
        }
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(Pmd task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies(dependencies -> {
            VersionNumber version = VersionNumber.parse((String)this.extension.getToolVersion());
            String dependency = this.calculateDefaultDependencyNotation(version);
            dependencies.add((Object)this.project.getDependencies().create((Object)dependency));
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, Pmd task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("pmdClasspath", () -> configuration);
        taskMapping.map("ruleSets", () -> this.extension.getRuleSets());
        taskMapping.map("ruleSetConfig", () -> this.extension.getRuleSetConfig());
        taskMapping.map("ruleSetFiles", () -> this.extension.getRuleSetFiles());
        taskMapping.map("ignoreFailures", () -> this.extension.isIgnoreFailures());
        taskMapping.map("rulePriority", () -> this.extension.getRulePriority());
        taskMapping.map("consoleOutput", () -> this.extension.isConsoleOutput());
        taskMapping.map("targetJdk", () -> this.extension.getTargetJdk());
        task.getIncrementalAnalysis().convention(this.extension.getIncrementalAnalysis());
    }

    private void configureReportsConventionMapping(Pmd task, String baseName) {
        task.getReports().all(report -> {
            report.getRequired().convention((Object)true);
            report.getOutputLocation().convention(this.project.getLayout().getProjectDirectory().file(this.project.provider(() -> new File(this.extension.getReportsDir(), baseName + "." + report.getName()).getAbsolutePath())));
        });
    }

    private String calculateDefaultDependencyNotation(VersionNumber toolVersion) {
        if (toolVersion.compareTo(VersionNumber.version((int)5)) < 0) {
            return "pmd:pmd:" + this.extension.getToolVersion();
        }
        if (toolVersion.compareTo(VersionNumber.parse((String)"5.2.0")) < 0) {
            return "net.sourceforge.pmd:pmd:" + this.extension.getToolVersion();
        }
        return "net.sourceforge.pmd:pmd-java:" + this.extension.getToolVersion();
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, Pmd task) {
        task.setDescription("Run PMD analysis for " + sourceSet.getName() + " classes");
        task.setSource((FileTree)sourceSet.getAllJava());
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("classpath", () -> sourceSet.getOutput().plus(sourceSet.getCompileClasspath()));
    }
}

