/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class AbstractProperty<T, S extends ValueSupplier>
extends AbstractMinimalProvider<T>
implements PropertyInternal<T> {
    private static final FinalizedValue<Object> FINALIZED_VALUE = new FinalizedValue();
    private static final DisplayName DEFAULT_DISPLAY_NAME = Describables.of((Object)"this property");
    private static final DisplayName DEFAULT_VALIDATION_DISPLAY_NAME = Describables.of((Object)"a property");
    private Task producer;
    private DisplayName displayName;
    private FinalizationState<S> state;
    private S value;

    public AbstractProperty(PropertyHost host) {
        this.state = new NonFinalizedValue(host);
    }

    protected void init(S initialValue, S convention) {
        this.value = initialValue;
        this.state.setConvention(convention);
    }

    protected void init(S initialValue) {
        this.init(initialValue, initialValue);
    }

    @Override
    public boolean isPresent() {
        this.beforeRead();
        return this.getSupplier().isPresent();
    }

    @Override
    public void attachDisplayName(DisplayName displayName) {
        this.displayName = displayName;
    }

    @Override
    @Nullable
    protected DisplayName getDeclaredDisplayName() {
        return this.displayName;
    }

    @Override
    protected DisplayName getTypedDisplayName() {
        return DEFAULT_DISPLAY_NAME;
    }

    @Override
    protected DisplayName getDisplayName() {
        if (this.displayName == null) {
            return DEFAULT_DISPLAY_NAME;
        }
        return this.displayName;
    }

    protected DisplayName getValidationDisplayName() {
        if (this.displayName == null) {
            return DEFAULT_VALIDATION_DISPLAY_NAME;
        }
        return this.displayName;
    }

    @Override
    public void attachProducer(Task task) {
        if (this.producer != null && this.producer != task) {
            throw new IllegalStateException(String.format("%s already has a producer task associated with it.", this.getDisplayName().getCapitalizedDisplayName()));
        }
        this.producer = task;
    }

    protected S getSupplier() {
        return this.value;
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue() {
        this.beforeRead();
        return this.calculateOwnValue(this.value);
    }

    protected abstract ValueSupplier.Value<? extends T> calculateOwnValue(S var1);

    protected abstract String describeContents();

    @Override
    public final String toString() {
        if (this.displayName != null) {
            return this.displayName.toString();
        }
        return this.describeContents();
    }

    @Override
    public void visitProducerTasks(Action<? super Task> visitor) {
        if (this.producer != null) {
            visitor.execute((Object)this.producer);
        } else {
            this.getSupplier().visitProducerTasks(visitor);
        }
    }

    @Override
    public boolean isValueProducedByTask() {
        return this.getSupplier().isValueProducedByTask();
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        if (this.producer != null) {
            context.add(this.producer);
            return true;
        }
        return this.getSupplier().maybeVisitBuildDependencies(context);
    }

    public void finalizeValue() {
        if (this.state.isNotFinal()) {
            this.value = this.finalValue(this.value);
            this.state = this.state.finalState();
        }
    }

    public void disallowChanges() {
        this.state.disallowChanges();
    }

    public void finalizeValueOnRead() {
        this.state.finalizeOnNextGet();
    }

    @Override
    public void implicitFinalizeValue() {
        this.state.disallowChanges();
        this.state.finalizeOnNextGet();
    }

    public void disallowUnsafeRead() {
        this.state.disallowUnsafeRead();
    }

    protected abstract S finalValue(S var1);

    protected void setSupplier(S supplier) {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.explicitValue(supplier);
    }

    protected void setConvention(S convention) {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.applyConvention(this.value, convention);
    }

    protected void beforeRead() {
        this.state.beforeRead(this.getDisplayName());
        if (this.state.isFinalizeOnRead()) {
            this.value = this.finalValue(this.value);
            this.state = this.state.finalState();
        }
    }

    protected S getExplicitValue(S defaultValue) {
        return (S)((ValueSupplier)this.state.explicitValue(this.value, defaultValue));
    }

    protected void discardValue() {
        this.assertCanMutate();
        this.value = (ValueSupplier)this.state.implicitValue();
    }

    protected void assertCanMutate() {
        this.state.beforeMutate(this.getDisplayName());
    }

    private static class FinalizedValue<S>
    extends FinalizationState<S> {
        private FinalizedValue() {
        }

        @Override
        public boolean isNotFinal() {
            return false;
        }

        @Override
        public void disallowChanges() {
        }

        @Override
        public void finalizeOnNextGet() {
        }

        @Override
        public void disallowUnsafeRead() {
        }

        @Override
        public void beforeRead(DisplayName displayName) {
        }

        @Override
        public boolean isFinalizeOnRead() {
            return false;
        }

        @Override
        public void beforeMutate(DisplayName displayName) {
            throw new IllegalStateException(String.format("The value for %s is final and cannot be changed any further.", displayName.getDisplayName()));
        }

        @Override
        public S explicitValue(S value) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public S explicitValue(S value, S defaultValue) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public S applyConvention(S value, S convention) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public S implicitValue() {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public FinalizationState<S> finalState() {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        void setConvention(S convention) {
            throw new UnsupportedOperationException("Should not be called");
        }
    }

    private static class NonFinalizedValue<S>
    extends FinalizationState<S> {
        private final PropertyHost host;
        private boolean explicitValue;
        private boolean finalizeOnNextGet;
        private boolean disallowChanges;
        private boolean disallowUnsafeRead;
        private S convention;

        public NonFinalizedValue(PropertyHost host) {
            this.host = host;
        }

        @Override
        public boolean isNotFinal() {
            return true;
        }

        @Override
        public FinalizationState<S> finalState() {
            return (FinalizationState)Cast.uncheckedCast((Object)FINALIZED_VALUE);
        }

        @Override
        public boolean isFinalizeOnRead() {
            return this.finalizeOnNextGet;
        }

        @Override
        public void beforeRead(DisplayName displayName) {
            String reason;
            if (this.disallowUnsafeRead && (reason = this.host.beforeRead()) != null) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot query the value of ");
                formatter.append((CharSequence)displayName.getDisplayName());
                formatter.append((CharSequence)" because ");
                formatter.append((CharSequence)reason);
                formatter.append((CharSequence)".");
                throw new IllegalStateException(formatter.toString());
            }
        }

        @Override
        public void beforeMutate(DisplayName displayName) {
            if (this.disallowChanges) {
                throw new IllegalStateException(String.format("The value for %s cannot be changed any further.", displayName.getDisplayName()));
            }
        }

        @Override
        public void disallowChanges() {
            this.disallowChanges = true;
        }

        @Override
        public void finalizeOnNextGet() {
            this.finalizeOnNextGet = true;
        }

        @Override
        public void disallowUnsafeRead() {
            this.disallowUnsafeRead = true;
            this.finalizeOnNextGet = true;
        }

        @Override
        public S explicitValue(S value) {
            this.explicitValue = true;
            return value;
        }

        @Override
        public S explicitValue(S value, S defaultValue) {
            if (!this.explicitValue) {
                return defaultValue;
            }
            return value;
        }

        @Override
        public S implicitValue() {
            this.explicitValue = false;
            return this.convention;
        }

        @Override
        public S applyConvention(S value, S convention) {
            this.convention = convention;
            if (!this.explicitValue) {
                return convention;
            }
            return value;
        }

        @Override
        void setConvention(S convention) {
            this.convention = convention;
        }
    }

    private static abstract class FinalizationState<S> {
        private FinalizationState() {
        }

        public abstract boolean isNotFinal();

        public abstract FinalizationState<S> finalState();

        abstract void setConvention(S var1);

        public abstract void disallowChanges();

        public abstract void finalizeOnNextGet();

        public abstract void disallowUnsafeRead();

        public abstract S explicitValue(S var1);

        public abstract S explicitValue(S var1, S var2);

        public abstract S applyConvention(S var1, S var2);

        public abstract S implicitValue();

        public abstract void beforeRead(DisplayName var1);

        public abstract boolean isFinalizeOnRead();

        public abstract void beforeMutate(DisplayName var1);
    }
}

