/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.util.function.Supplier;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

public class FilteredFileTree
extends CompositeFileTree
implements FileCollectionInternal.Source {
    private final CompositeFileTree tree;
    private final Supplier<? extends PatternSet> patternSupplier;

    public FilteredFileTree(CompositeFileTree tree, Supplier<? extends PatternSet> patternSupplier) {
        super((Factory<PatternSet>)tree.patternSetFactory);
        this.tree = tree;
        this.patternSupplier = patternSupplier;
    }

    @Override
    public String getDisplayName() {
        return this.tree.getDisplayName();
    }

    public CompositeFileTree getTree() {
        return this.tree;
    }

    public PatternSet getPatterns() {
        return this.patternSupplier.get();
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        PatternSet patterns = this.getPatterns();
        ResolvableFileCollectionResolveContext nestedContext = context.newContext();
        this.tree.visitContents(nestedContext);
        for (FileTree set : nestedContext.resolveAsFileTrees()) {
            context.add(set.matching((PatternFilterable)patterns));
        }
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.tree.visitDependencies(context);
    }
}

