/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.XmlProvider;
import org.gradle.api.tasks.Nested;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.tasks.internal.RelativeFileNameTransformer;
import org.gradle.ide.visualstudio.tasks.internal.VisualStudioFiltersFile;
import org.gradle.plugins.ide.api.XmlGeneratorTask;

@Incubating
public class GenerateFiltersFileTask
extends XmlGeneratorTask<VisualStudioFiltersFile> {
    private DefaultVisualStudioProject visualStudioProject;

    protected boolean getIncremental() {
        return true;
    }

    public void setVisualStudioProject(VisualStudioProject vsProject) {
        this.visualStudioProject = (DefaultVisualStudioProject)vsProject;
    }

    @Nested
    public VisualStudioProject getVisualStudioProject() {
        return this.visualStudioProject;
    }

    public File getInputFile() {
        return null;
    }

    public File getOutputFile() {
        return this.visualStudioProject.getFiltersFile().getLocation();
    }

    protected void configure(VisualStudioFiltersFile filtersFile) {
        DefaultVisualStudioProject vsProject = this.visualStudioProject;
        for (File sourceFile : vsProject.getSourceFiles()) {
            filtersFile.addSource(sourceFile);
        }
        for (File headerFile : vsProject.getHeaderFiles()) {
            filtersFile.addHeader(headerFile);
        }
        for (Action<? super XmlProvider> xmlAction : vsProject.getFiltersFile().getXmlActions()) {
            this.getXmlTransformer().addAction(xmlAction);
        }
    }

    protected VisualStudioFiltersFile create() {
        return new VisualStudioFiltersFile(this.getXmlTransformer(), RelativeFileNameTransformer.forFile(this.getProject().getRootDir(), this.visualStudioProject.getFiltersFile().getLocation()));
    }
}

