/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.ExecuteScheduledTransformationStepBuildOperationDetails;
import org.gradle.api.internal.artifacts.transform.ExecuteScheduledTransformationStepBuildOperationType;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.Try;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.resources.ResourceLock;

public abstract class TransformationNode
extends Node
implements SelfExecutingNode {
    private static final AtomicInteger ORDER_COUNTER = new AtomicInteger();
    private final int order = ORDER_COUNTER.incrementAndGet();
    protected final TransformationStep transformationStep;
    protected final ExecutionGraphDependenciesResolver dependenciesResolver;
    protected final BuildOperationExecutor buildOperationExecutor;
    protected final ArtifactTransformListener transformListener;
    protected Try<TransformationSubject> transformedSubject;

    public static ChainedTransformationNode chained(TransformationStep current, TransformationNode previous, ExecutionGraphDependenciesResolver executionGraphDependenciesResolver, BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
        return new ChainedTransformationNode(current, previous, executionGraphDependenciesResolver, buildOperationExecutor, transformListener);
    }

    public static InitialTransformationNode initial(TransformationStep initial, ResolvableArtifact artifact, ExecutionGraphDependenciesResolver executionGraphDependenciesResolver, BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
        return new InitialTransformationNode(initial, artifact, executionGraphDependenciesResolver, buildOperationExecutor, transformListener);
    }

    protected TransformationNode(TransformationStep transformationStep, ExecutionGraphDependenciesResolver dependenciesResolver, BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
        this.transformationStep = transformationStep;
        this.dependenciesResolver = dependenciesResolver;
        this.buildOperationExecutor = buildOperationExecutor;
        this.transformListener = transformListener;
    }

    public abstract ResolvableArtifact getInputArtifact();

    @Nullable
    public Project getOwningProject() {
        return this.transformationStep.getOwningProject();
    }

    public boolean isPublicNode() {
        return true;
    }

    public boolean requiresMonitoring() {
        return false;
    }

    public void resolveMutations() {
    }

    public String toString() {
        return this.transformationStep.getDisplayName();
    }

    public TransformationStep getTransformationStep() {
        return this.transformationStep;
    }

    public ExecutionGraphDependenciesResolver getDependenciesResolver() {
        return this.dependenciesResolver;
    }

    public Try<TransformationSubject> getTransformedSubject() {
        if (this.transformedSubject == null) {
            throw new IllegalStateException(String.format("Transformation %s has been scheduled and is now required, but did not execute, yet.", this.transformationStep.getDisplayName()));
        }
        return this.transformedSubject;
    }

    public Set<Node> getFinalizers() {
        return Collections.emptySet();
    }

    public void prepareForExecution() {
    }

    @Nullable
    public Project getProjectToLock() {
        return null;
    }

    public List<ResourceLock> getResourcesToLock() {
        return Collections.emptyList();
    }

    public Throwable getNodeFailure() {
        return null;
    }

    public void rethrowNodeFailure() {
    }

    public int compareTo(Node other) {
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return ((Object)((Object)this)).getClass().getName().compareTo(other.getClass().getName());
        }
        TransformationNode otherTransformation = (TransformationNode)other;
        return this.order - otherTransformation.order;
    }

    protected void processDependencies(Action<Node> processHardSuccessor, Set<Node> dependencies) {
        for (Node dependency : dependencies) {
            this.addDependencySuccessor(dependency);
            processHardSuccessor.execute((Object)dependency);
        }
    }

    public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
        this.processDependencies(processHardSuccessor, dependencyResolver.resolveDependenciesFor(null, (Object)this.transformationStep.getDependencies()));
        this.processDependencies(processHardSuccessor, dependencyResolver.resolveDependenciesFor(null, (Object)this.dependenciesResolver.computeDependencyNodes(this.transformationStep)));
    }

    private abstract class ArtifactTransformationStepBuildOperation
    implements CallableBuildOperation<Try<TransformationSubject>> {
        private static final String TRANSFORMING_PROGRESS_PREFIX = "Transforming ";

        private ArtifactTransformationStepBuildOperation() {
        }

        public final BuildOperationDescriptor.Builder description() {
            String transformerName = TransformationNode.this.transformationStep.getDisplayName();
            String subjectName = this.describeSubject();
            String basicName = subjectName + " with " + transformerName;
            return BuildOperationDescriptor.displayName((String)("Transform " + basicName)).progressDisplayName(TRANSFORMING_PROGRESS_PREFIX + basicName).operationType(BuildOperationCategory.TRANSFORM).details((Object)new ExecuteScheduledTransformationStepBuildOperationDetails(TransformationNode.this, transformerName, subjectName));
        }

        protected abstract String describeSubject();

        public Try<TransformationSubject> call(BuildOperationContext context) {
            Try<TransformationSubject> transformedSubject = this.transform();
            context.setResult((Object)ExecuteScheduledTransformationStepBuildOperationType.RESULT);
            transformedSubject.getFailure().ifPresent(arg_0 -> ((BuildOperationContext)context).failed(arg_0));
            return transformedSubject;
        }

        protected abstract Try<TransformationSubject> transform();
    }

    public static class ChainedTransformationNode
    extends TransformationNode {
        private final TransformationNode previousTransformationNode;

        public ChainedTransformationNode(TransformationStep transformationStep, TransformationNode previousTransformationNode, ExecutionGraphDependenciesResolver dependenciesResolver, BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
            super(transformationStep, dependenciesResolver, buildOperationExecutor, transformListener);
            this.previousTransformationNode = previousTransformationNode;
        }

        @Override
        public ResolvableArtifact getInputArtifact() {
            return this.previousTransformationNode.getInputArtifact();
        }

        public TransformationNode getPreviousTransformationNode() {
            return this.previousTransformationNode;
        }

        public void execute(final NodeExecutionContext context) {
            this.transformedSubject = (Try)this.buildOperationExecutor.call((CallableBuildOperation)new ArtifactTransformationStepBuildOperation(){

                @Override
                protected Try<TransformationSubject> transform() {
                    return previousTransformationNode.getTransformedSubject().flatMap(transformedSubject -> transformationStep.createInvocation((TransformationSubject)transformedSubject, dependenciesResolver, context).invoke());
                }

                @Override
                protected String describeSubject() {
                    return (String)previousTransformationNode.getTransformedSubject().map(Describable::getDisplayName).getOrMapFailure(Throwable::getMessage);
                }
            });
        }

        @Override
        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
            super.resolveDependencies(dependencyResolver, processHardSuccessor);
            this.addDependencySuccessor(this.previousTransformationNode);
            processHardSuccessor.execute((Object)this.previousTransformationNode);
        }
    }

    public static class InitialTransformationNode
    extends TransformationNode {
        private final ResolvableArtifact artifact;

        public InitialTransformationNode(TransformationStep transformationStep, ResolvableArtifact artifact, ExecutionGraphDependenciesResolver dependenciesResolver, BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
            super(transformationStep, dependenciesResolver, buildOperationExecutor, transformListener);
            this.artifact = artifact;
        }

        @Override
        public ResolvableArtifact getInputArtifact() {
            return this.artifact;
        }

        public void execute(final NodeExecutionContext context) {
            this.transformedSubject = (Try)this.buildOperationExecutor.call((CallableBuildOperation)new ArtifactTransformationStepBuildOperation(){

                @Override
                protected Try<TransformationSubject> transform() {
                    File file;
                    try {
                        file = artifact.getFile();
                    }
                    catch (ResolveException e) {
                        return Try.failure((Throwable)e);
                    }
                    catch (RuntimeException e) {
                        return Try.failure((Throwable)((Object)new DefaultLenientConfiguration.ArtifactResolveException("artifacts", transformationStep.getDisplayName(), "artifact transform", Collections.singleton(e))));
                    }
                    TransformationSubject initialArtifactTransformationSubject = TransformationSubject.initial(artifact.getId(), file);
                    return transformationStep.createInvocation(initialArtifactTransformationSubject, dependenciesResolver, context).invoke();
                }

                @Override
                protected String describeSubject() {
                    return "artifact " + artifact.getId().getDisplayName();
                }
            });
        }

        @Override
        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
            super.resolveDependencies(dependencyResolver, processHardSuccessor);
            this.processDependencies(processHardSuccessor, dependencyResolver.resolveDependenciesFor(null, (Object)this.artifact));
        }
    }
}

