/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.reflect.Method;
import org.gradle.api.Task;
import org.gradle.api.internal.changedetection.changes.ChangesOnlyIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.StatefulIncrementalTaskInputs;
import org.gradle.api.internal.project.taskfactory.AbstractIncrementalTaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaMethod;

public class IncrementalTaskInputsTaskAction
extends AbstractIncrementalTaskAction {
    private final Instantiator instantiator;

    public IncrementalTaskInputsTaskAction(Instantiator instantiator, Class<? extends Task> type, Method method) {
        super(type, method);
        this.instantiator = instantiator;
    }

    @Override
    protected void doExecute(Task task, String methodName) {
        InputChangesInternal inputChanges = this.getInputChanges();
        Iterable allFileChanges = inputChanges.getAllFileChanges();
        StatefulIncrementalTaskInputs incrementalTaskInputs = inputChanges.isIncremental() ? this.createIncrementalInputs(allFileChanges) : this.createRebuildInputs(allFileChanges);
        JavaMethod.of((Object)task, Object.class, (String)methodName, (Class[])new Class[]{IncrementalTaskInputs.class}).invoke((Object)task, new Object[]{incrementalTaskInputs});
    }

    private ChangesOnlyIncrementalTaskInputs createIncrementalInputs(Iterable<InputFileDetails> allFileChanges) {
        return (ChangesOnlyIncrementalTaskInputs)this.instantiator.newInstance(ChangesOnlyIncrementalTaskInputs.class, new Object[]{allFileChanges});
    }

    private RebuildIncrementalTaskInputs createRebuildInputs(Iterable<InputFileDetails> allFileChanges) {
        return (RebuildIncrementalTaskInputs)this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{allFileChanges});
    }
}

