/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.asm;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.asm.ClassRelevancyFilter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public class ClassDependenciesVisitor
extends ClassVisitor {
    private static final int API = 458752;
    private final IntSet constants = new IntOpenHashSet(2);
    private final Set<String> privateTypes = Sets.newHashSet();
    private final Set<String> accessibleTypes = Sets.newHashSet();
    private final Predicate<String> typeFilter;
    private final StringInterner interner;
    private boolean isAnnotationType;
    private boolean dependencyToAll;
    private final RetentionPolicyVisitor retentionPolicyVisitor = new RetentionPolicyVisitor();

    private ClassDependenciesVisitor(Predicate<String> typeFilter, ClassReader reader, StringInterner interner) {
        super(458752);
        this.typeFilter = typeFilter;
        this.interner = interner;
        this.collectRemainingClassDependencies(reader);
    }

    public static ClassAnalysis analyze(String className, ClassReader reader, StringInterner interner) {
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor(new ClassRelevancyFilter(className), reader, interner);
        reader.accept((ClassVisitor)visitor, 6);
        visitor.privateTypes.removeAll(visitor.accessibleTypes);
        return new ClassAnalysis(interner.intern(className), visitor.getPrivateClassDependencies(), visitor.getAccessibleClassDependencies(), visitor.isDependencyToAll(), visitor.getConstants());
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Set<String> types;
        this.isAnnotationType = this.isAnnotationType(interfaces);
        Set<String> set = types = ClassDependenciesVisitor.isAccessible(access) ? this.accessibleTypes : this.privateTypes;
        if (superName != null) {
            String type = this.typeOfFromSlashyString(superName);
            this.maybeAddDependentType(types, type);
        }
        for (String s : interfaces) {
            String interfaceType = this.typeOfFromSlashyString(s);
            this.maybeAddDependentType(types, interfaceType);
        }
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        this.dependencyToAll = true;
        return null;
    }

    private void collectRemainingClassDependencies(ClassReader reader) {
        char[] charBuffer = new char[reader.getMaxStringLength()];
        for (int i = 1; i < reader.getItemCount(); ++i) {
            String name;
            int itemOffset = reader.getItem(i);
            if (itemOffset <= 0 || reader.readByte(itemOffset - 1) != 7) continue;
            String classDescriptor = reader.readUTF8(itemOffset, charBuffer);
            Type type = Type.getObjectType((String)classDescriptor);
            while (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() != 10 || this.accessibleTypes.contains(name = type.getClassName())) continue;
            this.maybeAddDependentType(this.privateTypes, name);
        }
    }

    protected void maybeAddDependentType(Set<String> types, String type) {
        if (this.typeFilter.apply((Object)type)) {
            types.add(this.intern(type));
        }
    }

    private String intern(String type) {
        return this.interner.intern(type);
    }

    protected String typeOfFromSlashyString(String slashyStyleDesc) {
        return Type.getObjectType((String)slashyStyleDesc).getClassName();
    }

    public Set<String> getPrivateClassDependencies() {
        return this.privateTypes;
    }

    public Set<String> getAccessibleClassDependencies() {
        return this.accessibleTypes;
    }

    public IntSet getConstants() {
        return this.constants;
    }

    private boolean isAnnotationType(String[] interfaces) {
        return interfaces.length == 1 && interfaces[0].equals("java/lang/annotation/Annotation");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Set<String> types = ClassDependenciesVisitor.isAccessible(access) ? this.accessibleTypes : this.privateTypes;
        this.maybeAddDependentType(types, this.descTypeOf(desc));
        if (ClassDependenciesVisitor.isAccessibleConstant(access, value)) {
            this.constants.add((name + '|' + value).hashCode());
        }
        return new FieldVisitor(types);
    }

    protected String descTypeOf(String desc) {
        Type type = Type.getType((String)desc);
        if (type.getSort() == 9 && type.getDimensions() > 0) {
            type = type.getElementType();
        }
        return type.getClassName();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Set<String> types = ClassDependenciesVisitor.isAccessible(access) ? this.accessibleTypes : this.privateTypes;
        Type methodType = Type.getMethodType((String)desc);
        this.maybeAddDependentType(types, methodType.getReturnType().getClassName());
        for (Type argType : methodType.getArgumentTypes()) {
            this.maybeAddDependentType(types, argType.getClassName());
        }
        return new MethodVisitor(types);
    }

    public org.objectweb.asm.AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isAnnotationType && "Ljava/lang/annotation/Retention;".equals(desc)) {
            return this.retentionPolicyVisitor;
        }
        this.maybeAddDependentType(this.accessibleTypes, Type.getType((String)desc).getClassName());
        return new AnnotationVisitor(this.accessibleTypes);
    }

    private static boolean isAccessible(int access) {
        return (access & 2) == 0;
    }

    private static boolean isAccessibleConstant(int access, Object value) {
        return ClassDependenciesVisitor.isConstant(access) && ClassDependenciesVisitor.isAccessible(access) && value != null;
    }

    private static boolean isConstant(int access) {
        return (access & 0x10) != 0 && (access & 8) != 0;
    }

    public boolean isDependencyToAll() {
        return this.dependencyToAll;
    }

    private class AnnotationVisitor
    extends org.objectweb.asm.AnnotationVisitor {
        private final Set<String> types;

        public AnnotationVisitor(Set<String> types) {
            super(458752);
            this.types = types;
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                ClassDependenciesVisitor.this.maybeAddDependentType(this.types, ((Type)value).getClassName());
            }
        }

        public org.objectweb.asm.AnnotationVisitor visitArray(String name) {
            return this;
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String name, String descriptor) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor).getClassName());
            return this;
        }
    }

    private class RetentionPolicyVisitor
    extends org.objectweb.asm.AnnotationVisitor {
        public RetentionPolicyVisitor() {
            super(458752);
        }

        public void visitEnum(String name, String desc, String value) {
            RetentionPolicy policy;
            if ("Ljava/lang/annotation/RetentionPolicy;".equals(desc) && (policy = RetentionPolicy.valueOf(value)) == RetentionPolicy.SOURCE) {
                ClassDependenciesVisitor.this.dependencyToAll = true;
            }
        }
    }

    private class MethodVisitor
    extends org.objectweb.asm.MethodVisitor {
        private final Set<String> types;

        protected MethodVisitor(Set<String> types) {
            super(458752);
            this.types = types;
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, ClassDependenciesVisitor.this.descTypeOf(desc));
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor).getClassName());
            return new AnnotationVisitor(this.types);
        }

        public org.objectweb.asm.AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor).getClassName());
            return new AnnotationVisitor(this.types);
        }

        public org.objectweb.asm.AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor).getClassName());
            return new AnnotationVisitor(this.types);
        }
    }

    private class FieldVisitor
    extends org.objectweb.asm.FieldVisitor {
        private final Set<String> types;

        public FieldVisitor(Set<String> types) {
            super(458752);
            this.types = types;
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor).getClassName());
            return new AnnotationVisitor(this.types);
        }

        public org.objectweb.asm.AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor).getClassName());
            return new AnnotationVisitor(this.types);
        }
    }
}

