/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.model.psi.PsiSymbolReference;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.MultiRangeReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;

public class ReferenceRange {
    private ReferenceRange() {
    }

    @NotNull
    public static List<TextRange> getRanges(@NotNull PsiReference ref) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(0);
        }
        return ReferenceRange.getRanges((PsiSymbolReference)ref);
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<TextRange> getRanges(@NotNull PsiSymbolReference ref) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(1);
        }
        if (ref instanceof MultiRangeReference) {
            List<TextRange> list2 = ((MultiRangeReference)ref).getRanges();
            if (list2 == null) {
                ReferenceRange.$$$reportNull$$$0(2);
            }
            return list2;
        }
        List<TextRange> list3 = Collections.singletonList(ref.getRangeInElement());
        if (list3 == null) {
            ReferenceRange.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @NotNull
    public static List<TextRange> getAbsoluteRanges(@NotNull PsiReference ref) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(4);
        }
        return ReferenceRange.getAbsoluteRanges((PsiSymbolReference)ref);
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<TextRange> getAbsoluteRanges(@NotNull PsiSymbolReference ref) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(5);
        }
        PsiElement elt = ref.getElement();
        List<TextRange> relativeRanges = ReferenceRange.getRanges(ref);
        ArrayList<TextRange> answer = new ArrayList<TextRange>(relativeRanges.size());
        int parentOffset = elt.getTextRange().getStartOffset();
        for (TextRange relativeRange : relativeRanges) {
            answer.add(relativeRange.shiftRight(parentOffset));
        }
        ArrayList<TextRange> arrayList = answer;
        if (arrayList == null) {
            ReferenceRange.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public static TextRange getRange(@NotNull PsiReference ref) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(7);
        }
        if (ref instanceof MultiRangeReference) {
            List<TextRange> ranges2 = ((MultiRangeReference)ref).getRanges();
            return new TextRange(ranges2.get(0).getStartOffset(), ranges2.get(ranges2.size() - 1).getEndOffset());
        }
        return ref.getRangeInElement();
    }

    public static boolean containsOffsetInElement(@NotNull PsiReference ref, int offset2) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(8);
        }
        return ReferenceRange.containsOffsetInElement((PsiSymbolReference)ref, offset2);
    }

    @ApiStatus.Experimental
    public static boolean containsOffsetInElement(@NotNull PsiSymbolReference ref, int offset2) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(9);
        }
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.containsOffset(offset2)) continue;
                return true;
            }
            return false;
        }
        return ref.getRangeInElement().containsOffset(offset2);
    }

    @ApiStatus.Experimental
    public static boolean containsRangeInElement(@NotNull PsiSymbolReference ref, @NotNull TextRange rangeInElement) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(10);
        }
        if (rangeInElement == null) {
            ReferenceRange.$$$reportNull$$$0(11);
        }
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.contains(rangeInElement)) continue;
                return true;
            }
            return false;
        }
        return ref.getRangeInElement().contains(rangeInElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/ReferenceRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/ReferenceRange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteRanges";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsOffsetInElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsRangeInElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

