/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.twirl;

import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.internal.twirl.PlayTwirlAdapterV23X;
import org.gradle.play.internal.twirl.PlayTwirlAdapterV26X;
import org.gradle.play.internal.twirl.TwirlCompilerAdapterV10X;
import org.gradle.play.internal.twirl.TwirlCompilerAdapterV13X;
import org.gradle.play.internal.twirl.VersionedPlayTwirlAdapter;
import org.gradle.play.internal.twirl.VersionedTwirlCompilerAdapter;
import org.gradle.play.platform.PlayPlatform;

public class TwirlCompilerAdapterFactory {
    public static VersionedTwirlCompilerAdapter createAdapter(PlayPlatform playPlatform) {
        String playVersion = playPlatform.getPlayVersion();
        String scalaCompatibilityVersion = playPlatform.getScalaPlatform().getScalaCompatibilityVersion();
        VersionedPlayTwirlAdapter playTwirlAdapter = TwirlCompilerAdapterFactory.createPlayTwirlAdapter(playPlatform);
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_3_X: {
                return new TwirlCompilerAdapterV10X("1.0.4", scalaCompatibilityVersion, playTwirlAdapter);
            }
            case PLAY_2_4_X: 
            case PLAY_2_5_X: {
                return new TwirlCompilerAdapterV10X("1.1.1", scalaCompatibilityVersion, playTwirlAdapter);
            }
            case PLAY_2_6_X: {
                return new TwirlCompilerAdapterV13X("1.3.13", scalaCompatibilityVersion, playTwirlAdapter);
            }
        }
        throw new RuntimeException("Could not create Twirl compile spec for Play version: " + playVersion);
    }

    public static VersionedPlayTwirlAdapter createPlayTwirlAdapter(PlayPlatform playPlatform) {
        String playVersion = playPlatform.getPlayVersion();
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_3_X: 
            case PLAY_2_4_X: 
            case PLAY_2_5_X: {
                return new PlayTwirlAdapterV23X();
            }
            case PLAY_2_6_X: {
                return new PlayTwirlAdapterV26X();
            }
        }
        throw new RuntimeException("Could not create Twirl adapter spec for Play version: " + playVersion);
    }
}

