/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgUtilsKt;
import org.jetbrains.kotlin.fir.analysis.cfa.ControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.FirCallsEffectAnalyzer;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.ContractUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.description.ConeCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeEffectDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.InitBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.InitBlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.PropertyInitializerEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.PropertyInitializerExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004%&'(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001e\u001a\u00020\u001f*\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001f*\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010\u0013*\u0004\u0018\u00010\u0018H\u0002R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "()V", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getContractDescription", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkerContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "referenceToSymbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "getArgumentCallsEffect", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "arg", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getParameterCallsEffect", "index", "", "getParameterCallsEffectDeclaration", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "isFunctionalTypeRef", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isInPlaceLambda", "toQualifiedReference", "CapturedLambdaFinder", "IllegalScopeContext", "InvocationDataCollector", "LambdaInvocationInfo", "checkers"})
public final class FirCallsEffectAnalyzer
extends FirControlFlowChecker {
    @NotNull
    public static final FirCallsEffectAnalyzer INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext checkerContext) {
        void destination$iv;
        void $this$filterTo$iv;
        ConeCallsEffectDeclaration effectDeclaration;
        boolean bl;
        Object it;
        boolean $i$f$any;
        FirFunction function2;
        block23: {
            block22: {
                boolean bl2;
                block21: {
                    Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    Intrinsics.checkNotNullParameter((Object)checkerContext, (String)"checkerContext");
                    FirDeclaration firDeclaration = graph2.getDeclaration();
                    if (!(firDeclaration instanceof FirFunction)) {
                        firDeclaration = null;
                    }
                    FirFunction firFunction = (FirFunction)firDeclaration;
                    if (firFunction == null) {
                        return;
                    }
                    function2 = firFunction;
                    if (!(function2 instanceof FirContractDescriptionOwner)) {
                        return;
                    }
                    List<ConeEffectDeclaration> list2 = ContractUtilsKt.getConeEffects(((FirContractDescriptionOwner)((Object)function2)).getContractDescription());
                    if (list2 == null) break block22;
                    Iterable $this$any$iv = list2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (ConeEffectDeclaration)element$iv;
                            boolean bl3 = false;
                            if (!(it instanceof ConeCallsEffectDeclaration)) continue;
                            bl2 = true;
                            break block21;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) break block23;
            }
            return;
        }
        $i$f$any = false;
        Map functionalTypeEffects = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed2 = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ConeCallsEffectDeclaration effectDeclaration2;
            Iterator parameter;
            int n = index$iv22++;
            bl = false;
            if (n < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            int index2 = n;
            boolean bl4 = false;
            if (!INSTANCE.isFunctionalTypeRef(((FirValueParameter)((Object)parameter)).getReturnTypeRef(), function2.getSession()) || (effectDeclaration2 = INSTANCE.getParameterCallsEffectDeclaration(((FirContractDescriptionOwner)((Object)function2)).getContractDescription(), index2)) == null) continue;
            functionalTypeEffects.put(((FirValueParameter)((Object)parameter)).getSymbol(), effectDeclaration2);
        }
        if (this.isFunctionalTypeRef(function2.getReceiverTypeRef(), function2.getSession()) && (effectDeclaration = this.getParameterCallsEffectDeclaration(((FirContractDescriptionOwner)((Object)function2)).getContractDescription(), -1)) != null) {
            functionalTypeEffects.put(function2.getSymbol(), effectDeclaration);
        }
        if (functionalTypeEffects.isEmpty()) {
            return;
        }
        $i$f$forEachIndexed2 = false;
        Map leakedSymbols = new LinkedHashMap();
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, new CapturedLambdaFinder(function2), new IllegalScopeContext(functionalTypeEffects.keySet(), leakedSymbols));
        it = leakedSymbols;
        boolean item$iv = false;
        for (Map.Entry $i$f$forEachIndexed2 : it.entrySet()) {
            void symbol22;
            Object object = $i$f$forEachIndexed2;
            bl = false;
            it = (AbstractFirBasedSymbol)object.getKey();
            object = $i$f$forEachIndexed2;
            bl = false;
            List leakedPlaces = (List)object.getValue();
            FirSourceElement firSourceElement = ((FirContractDescriptionOwner)((Object)function2)).getContractDescription().getSource();
            if (firSourceElement != null) {
                object = firSourceElement;
                bl = false;
                boolean parameter = false;
                Object it2 = object;
                boolean bl5 = false;
                reporter.report((FirDiagnostic)FirErrors.INSTANCE.getLEAKED_IN_PLACE_LAMBDA().on((FirSourceElement)it2, (AbstractFirBasedSymbol<?>)symbol22));
            }
            Iterable $this$forEach$iv = leakedPlaces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirSourceElement it3 = (FirSourceElement)element$iv;
                boolean bl6 = false;
                reporter.report((FirDiagnostic)FirErrors.INSTANCE.getLEAKED_IN_PLACE_LAMBDA().on(it3, (AbstractFirBasedSymbol<?>)symbol22));
            }
        }
        Iterable index$iv22 = functionalTypeEffects.keySet();
        boolean symbol22 = false;
        Collection symbol22 = new LinkedHashSet();
        ControlFlowInfo controlFlowInfo = LambdaInvocationInfo.Companion.getEMPTY();
        TraverseDirection traverseDirection = TraverseDirection.Forward;
        ControlFlowGraph controlFlowGraph = graph2;
        boolean $i$f$filterTo22 = false;
        for (Object element$iv : $this$filterTo$iv) {
            AbstractFirBasedSymbol it4 = (AbstractFirBasedSymbol)element$iv;
            boolean bl7 = false;
            Map it3 = leakedSymbols;
            boolean bl6 = false;
            Map map2 = it3;
            boolean bl8 = false;
            if (!(!map2.containsKey(it4))) continue;
            destination$iv.add(element$iv);
        }
        void var30_53 = destination$iv;
        Set set = (Set)var30_53;
        Map<CFGNode<?>, ControlFlowInfo> invocationData = CfgTraverserKt.collectDataForNode(controlFlowGraph, traverseDirection, controlFlowInfo, new InvocationDataCollector(set));
        Object $i$f$filterTo22 = functionalTypeEffects;
        boolean $this$forEach$iv = false;
        Iterator iterator2 = $i$f$filterTo22.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry element$iv = entry = iterator2.next();
            boolean it4 = false;
            $i$f$filterTo22 = (AbstractFirBasedSymbol)element$iv.getKey();
            element$iv = entry;
            it4 = false;
            ConeCallsEffectDeclaration effectDeclaration3 = (ConeCallsEffectDeclaration)element$iv.getValue();
            Iterable $this$forEach$iv2 = CfgUtilsKt.getPreviousCfgNodes(graph2.getExitNode());
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FirSourceElement firSourceElement;
                EventOccurrencesRange foundRange;
                void symbol3;
                CFGNode node = (CFGNode)element$iv2;
                boolean bl9 = false;
                EventOccurrencesRange requiredRange = effectDeclaration3.getKind();
                EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)((LambdaInvocationInfo)MapsKt.getValue(invocationData, (Object)node)).get(symbol3));
                if (eventOccurrencesRange == null) {
                    eventOccurrencesRange = EventOccurrencesRange.ZERO;
                }
                if (requiredRange.contains(foundRange = eventOccurrencesRange)) continue;
                if (((FirContractDescriptionOwner)((Object)function2)).getContractDescription().getSource() == null) continue;
                boolean bl10 = false;
                boolean bl11 = false;
                FirSourceElement it5 = firSourceElement;
                boolean bl12 = false;
                reporter.report((FirDiagnostic)FirErrors.INSTANCE.getWRONG_INVOCATION_KIND().on(it5, (AbstractFirBasedSymbol<?>)symbol3, requiredRange, foundRange));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFunctionalTypeRef(FirTypeRef $this$isFunctionalTypeRef, FirSession session2) {
        FirTypeRef firTypeRef = $this$isFunctionalTypeRef;
        Object object = firTypeRef;
        if (firTypeRef == null) return false;
        FirTypeRef $this$coneTypeSafe$iv = object;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef2 = $this$coneTypeSafe$iv;
        if (!(firTypeRef2 instanceof FirResolvedTypeRef)) {
            firTypeRef2 = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef2;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            return false;
        }
        object = coneKotlinType;
        if (coneKotlinType == null) return false;
        if (!InferenceUtilsKt.isBuiltinFunctionalType((ConeKotlinType)object, session2)) return false;
        return true;
    }

    private final FirContractDescription getContractDescription(FirFunction<?> $this$contractDescription) {
        FirFunction<?> firFunction = $this$contractDescription;
        if (!(firFunction instanceof FirContractDescriptionOwner)) {
            firFunction = null;
        }
        FirContractDescriptionOwner firContractDescriptionOwner = (FirContractDescriptionOwner)((Object)firFunction);
        return firContractDescriptionOwner != null ? firContractDescriptionOwner.getContractDescription() : null;
    }

    private final ConeCallsEffectDeclaration getParameterCallsEffectDeclaration(FirContractDescription $this$getParameterCallsEffectDeclaration, int index2) {
        ConeEffectDeclaration callsEffect;
        ConeEffectDeclaration coneEffectDeclaration;
        ConeEffectDeclaration coneEffectDeclaration2;
        List<ConeEffectDeclaration> effects;
        FirContractDescription firContractDescription = $this$getParameterCallsEffectDeclaration;
        List<ConeEffectDeclaration> list2 = effects = firContractDescription != null ? ContractUtilsKt.getConeEffects(firContractDescription) : null;
        if (list2 != null) {
            Object v2;
            block4: {
                Iterable iterable = list2;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ConeEffectDeclaration it = (ConeEffectDeclaration)t;
                    boolean bl3 = false;
                    if (!(it instanceof ConeCallsEffectDeclaration && ((ConeCallsEffectDeclaration)it).getValueParameterReference().getParameterIndex() == index2)) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            coneEffectDeclaration2 = v2;
        } else {
            coneEffectDeclaration2 = null;
        }
        if (!((coneEffectDeclaration = (callsEffect = coneEffectDeclaration2)) instanceof ConeCallsEffectDeclaration)) {
            coneEffectDeclaration = null;
        }
        return (ConeCallsEffectDeclaration)coneEffectDeclaration;
    }

    private final EventOccurrencesRange getArgumentCallsEffect(FirFunctionCall $this$getArgumentCallsEffect, FirExpression arg) {
        EventOccurrencesRange eventOccurrencesRange;
        FirFunction function2;
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol($this$getArgumentCallsEffect);
        if (!(firCallableSymbol instanceof FirFunctionSymbol)) {
            firCallableSymbol = null;
        }
        FirFunctionSymbol firFunctionSymbol = (FirFunctionSymbol)firCallableSymbol;
        FirFunction firFunction = function2 = firFunctionSymbol != null ? (FirFunction)firFunctionSymbol.getFir() : null;
        FirContractDescription contractDescription = firFunction != null ? this.getContractDescription(firFunction) : null;
        FirArgumentList firArgumentList = $this$getArgumentCallsEffect.getArgumentList();
        if (!(firArgumentList instanceof FirResolvedArgumentList)) {
            firArgumentList = null;
        }
        FirResolvedArgumentList resolvedArguments = (FirResolvedArgumentList)firArgumentList;
        if (function2 != null && resolvedArguments != null) {
            FirValueParameter parameter = resolvedArguments.getMapping().get(arg);
            eventOccurrencesRange = this.getParameterCallsEffect(contractDescription, kotlin.collections.CollectionsKt.indexOf(function2.getValueParameters(), (Object)parameter));
        } else {
            eventOccurrencesRange = null;
        }
        return eventOccurrencesRange;
    }

    private final EventOccurrencesRange getParameterCallsEffect(FirContractDescription $this$getParameterCallsEffect, int index2) {
        ConeCallsEffectDeclaration coneCallsEffectDeclaration = this.getParameterCallsEffectDeclaration($this$getParameterCallsEffect, index2);
        return coneCallsEffectDeclaration != null ? coneCallsEffectDeclaration.getKind() : null;
    }

    private final boolean isInPlaceLambda(FirFunction<?> $this$isInPlaceLambda) {
        return $this$isInPlaceLambda instanceof FirAnonymousFunction && ((FirAnonymousFunction)$this$isInPlaceLambda).isLambda() && ((FirAnonymousFunction)$this$isInPlaceLambda).getInvocationKind() != null;
    }

    private final FirReference toQualifiedReference(FirExpression $this$toQualifiedReference) {
        FirExpression firExpression2 = $this$toQualifiedReference;
        if (!(firExpression2 instanceof FirQualifiedAccess)) {
            firExpression2 = null;
        }
        FirQualifiedAccess firQualifiedAccess = (FirQualifiedAccess)((Object)firExpression2);
        return firQualifiedAccess != null ? firQualifiedAccess.getCalleeReference() : null;
    }

    private final AbstractFirBasedSymbol<?> referenceToSymbol(FirReference reference) {
        FirReference firReference = reference;
        return firReference instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference).getResolvedSymbol() : (firReference instanceof FirThisReference ? ((FirThisReference)reference).getBoundSymbol() : null);
    }

    private FirCallsEffectAnalyzer() {
    }

    static {
        FirCallsEffectAnalyzer firCallsEffectAnalyzer;
        INSTANCE = firCallsEffectAnalyzer = new FirCallsEffectAnalyzer();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u001c\u0010\u0005\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ2\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u0013R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0005\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$IllegalScopeContext;", "", "functionalTypeSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "leakedSymbols", "", "", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "(Ljava/util/Set;Ljava/util/Map;)V", "illegalScopeDepth", "", "Ljava/lang/Integer;", "inIllegalScope", "", "getInIllegalScope", "()Z", "scopeDepth", "checkExpressionForLeakedSymbols", "", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "source", "illegalUsage", "Lkotlin/Function0;", "enterScope", "legal", "exitScope", "checkers"})
    private static final class IllegalScopeContext {
        private int scopeDepth;
        private Integer illegalScopeDepth;
        private final Set<AbstractFirBasedSymbol<?>> functionalTypeSymbols;
        private final Map<AbstractFirBasedSymbol<?>, List<FirSourceElement>> leakedSymbols;

        public final boolean getInIllegalScope() {
            return this.illegalScopeDepth != null;
        }

        public final void enterScope(boolean legal) {
            int n = this.scopeDepth;
            this.scopeDepth = n + 1;
            if (this.illegalScopeDepth == null && !legal) {
                this.illegalScopeDepth = this.scopeDepth;
            }
        }

        public final void exitScope() {
            Integer n = this.illegalScopeDepth;
            if (n != null && this.scopeDepth == n) {
                this.illegalScopeDepth = null;
            }
            int n2 = this.scopeDepth;
            this.scopeDepth = n2 + -1;
        }

        public final void checkExpressionForLeakedSymbols(@Nullable FirExpression fir, @Nullable FirSourceElement source, @NotNull Function0<Boolean> illegalUsage) {
            int $i$f$checkExpressionForLeakedSymbols = 0;
            Intrinsics.checkNotNullParameter(illegalUsage, (String)"illegalUsage");
            AbstractFirBasedSymbol symbol2 = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir));
            if (symbol2 != null && this.functionalTypeSymbols.contains(symbol2) && (this.getInIllegalScope() || ((Boolean)illegalUsage.invoke()).booleanValue())) {
                Object object;
                Map $this$getOrPut$iv = this.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(symbol2);
                if (value$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(symbol2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                CollectionsKt.addIfNotNull((Collection)object, source);
            }
        }

        public static /* synthetic */ void checkExpressionForLeakedSymbols$default(IllegalScopeContext this_, FirExpression fir, FirSourceElement source, Function0 illegalUsage, int n, Object object) {
            if ((n & 2) != 0) {
                FirExpression firExpression2 = fir;
                FirSourceElement firSourceElement = source = firExpression2 != null ? firExpression2.getSource() : null;
            }
            if ((n & 4) != 0) {
                illegalUsage = checkExpressionForLeakedSymbols.1.INSTANCE;
            }
            boolean $i$f$checkExpressionForLeakedSymbols = false;
            Intrinsics.checkNotNullParameter((Object)illegalUsage, (String)"illegalUsage");
            AbstractFirBasedSymbol symbol2 = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir));
            if (symbol2 != null && this_.functionalTypeSymbols.contains(symbol2) && (this_.getInIllegalScope() || ((Boolean)illegalUsage.invoke()).booleanValue())) {
                Object object2;
                Map $this$getOrPut$iv = this_.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(symbol2);
                if (value$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(symbol2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                CollectionsKt.addIfNotNull((Collection)object2, source);
            }
        }

        public IllegalScopeContext(@NotNull Set<? extends AbstractFirBasedSymbol<?>> functionalTypeSymbols, @NotNull Map<AbstractFirBasedSymbol<?>, List<FirSourceElement>> leakedSymbols) {
            Intrinsics.checkNotNullParameter(functionalTypeSymbols, (String)"functionalTypeSymbols");
            Intrinsics.checkNotNullParameter(leakedSymbols, (String)"leakedSymbols");
            this.functionalTypeSymbols = functionalTypeSymbols;
            this.leakedSymbols = leakedSymbols;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u001c\u0010\u0015\u001a\u00020\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$CapturedLambdaFinder;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$IllegalScopeContext;", "rootFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "getRootFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "visitFunctionCallNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallNode;", "data", "visitFunctionEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionEnterNode;", "visitFunctionExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionExitNode;", "visitInitBlockEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/InitBlockEnterNode;", "visitInitBlockExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/InitBlockExitNode;", "visitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitPropertyInitializerEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/PropertyInitializerEnterNode;", "visitPropertyInitializerExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/PropertyInitializerExitNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    private static final class CapturedLambdaFinder
    extends ControlFlowGraphVisitor<Unit, IllegalScopeContext> {
        private final FirFunction<?> rootFunction;

        @Override
        public void visitNode(@NotNull CFGNode<?> node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitFunctionEnterNode(@NotNull FunctionEnterNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.enterScope(node.getFir() == this.rootFunction || INSTANCE.isInPlaceLambda((FirFunction)node.getFir()));
        }

        @Override
        public void visitFunctionExitNode(@NotNull FunctionExitNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.exitScope();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPropertyInitializerEnterNode(@NotNull PropertyInitializerEnterNode node, @NotNull IllegalScopeContext data) {
            void this_$iv;
            FirExpression fir$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.enterScope(false);
            IllegalScopeContext illegalScopeContext = data;
            FirExpression firExpression2 = fir$iv = node.getFir().getInitializer();
            FirSourceElement source$iv = firExpression2 != null ? firExpression2.getSource() : null;
            boolean $i$f$checkExpressionForLeakedSymbols = false;
            AbstractFirBasedSymbol symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
            if (symbol$iv != null && ((IllegalScopeContext)this_$iv).functionalTypeSymbols.contains(symbol$iv) && (this_$iv.getInIllegalScope() || false)) {
                Object object;
                Map $this$getOrPut$iv$iv = ((IllegalScopeContext)this_$iv).leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                CollectionsKt.addIfNotNull((Collection)object, source$iv);
            }
        }

        @Override
        public void visitPropertyInitializerExitNode(@NotNull PropertyInitializerExitNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.exitScope();
        }

        @Override
        public void visitInitBlockEnterNode(@NotNull InitBlockEnterNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.enterScope(false);
        }

        @Override
        public void visitInitBlockExitNode(@NotNull InitBlockExitNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.exitScope();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull IllegalScopeContext data) {
            block5: {
                Object object;
                void this_$iv;
                AbstractFirBasedSymbol symbol$iv;
                FirSourceElement source$iv;
                block6: {
                    FirExpression fir$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    IllegalScopeContext illegalScopeContext = data;
                    FirExpression firExpression2 = fir$iv = node.getFir().getRValue();
                    source$iv = firExpression2 != null ? firExpression2.getSource() : null;
                    boolean $i$f$checkExpressionForLeakedSymbols = false;
                    symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
                    if (symbol$iv == null || !((IllegalScopeContext)this_$iv).functionalTypeSymbols.contains(symbol$iv)) break block5;
                    if (this_$iv.getInIllegalScope()) break block6;
                    boolean bl = false;
                    if (!true) break block5;
                }
                Map $this$getOrPut$iv$iv = ((IllegalScopeContext)this_$iv).leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                CollectionsKt.addIfNotNull((Collection)object, source$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull IllegalScopeContext data) {
            block5: {
                Object object;
                void this_$iv;
                AbstractFirBasedSymbol symbol$iv;
                FirSourceElement source$iv;
                block6: {
                    FirExpression fir$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    IllegalScopeContext illegalScopeContext = data;
                    FirExpression firExpression2 = fir$iv = node.getFir().getInitializer();
                    source$iv = firExpression2 != null ? firExpression2.getSource() : null;
                    boolean $i$f$checkExpressionForLeakedSymbols = false;
                    symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
                    if (symbol$iv == null || !((IllegalScopeContext)this_$iv).functionalTypeSymbols.contains(symbol$iv)) break block5;
                    if (this_$iv.getInIllegalScope()) break block6;
                    boolean bl = false;
                    if (!true) break block5;
                }
                Map $this$getOrPut$iv$iv = ((IllegalScopeContext)this_$iv).leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                CollectionsKt.addIfNotNull((Collection)object, source$iv);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void visitFunctionCallNode(@NotNull FunctionCallNode node, @NotNull IllegalScopeContext data) {
            block13: {
                block14: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    v0 = FirExpressionUtilKt.toResolvedCallableSymbol(node.getFir());
                    if (!(v0 instanceof FirFunctionSymbol)) {
                        v0 = null;
                    }
                    v1 = contractDescription = (v2 = (functionSymbol = (FirFunctionSymbol)v0)) != null && (v2 = (FirFunction)v2.getFir()) != null ? FirCallsEffectAnalyzer.access$getContractDescription$p(FirCallsEffectAnalyzer.INSTANCE, (FirFunction)v2) : null;
                    v3 = node.getFir().getExplicitReceiver();
                    if (v3 == null || (v3 = v3.getSource()) == null) {
                        v3 = node.getFir().getSource();
                    }
                    callSource = v3;
                    var6_6 = data;
                    fir$iv = node.getFir().getExplicitReceiver();
                    $i$f$checkExpressionForLeakedSymbols = false;
                    symbol$iv = FirCallsEffectAnalyzer.access$referenceToSymbol(FirCallsEffectAnalyzer.INSTANCE, FirCallsEffectAnalyzer.access$toQualifiedReference(FirCallsEffectAnalyzer.INSTANCE, fir$iv));
                    if (symbol$iv == null || !IllegalScopeContext.access$getFunctionalTypeSymbols$p((IllegalScopeContext)this_$iv).contains(symbol$iv)) break block13;
                    if (this_$iv.getInIllegalScope()) break block14;
                    $i$a$-checkExpressionForLeakedSymbols-FirCallsEffectAnalyzer$CapturedLambdaFinder$visitFunctionCallNode$1 = false;
                    v4 = functionSymbol;
                    if (v4 != null && (v4 = v4.getCallableId()) != null && ResolveUtilsKt.isInvoke((CallableId)v4)) ** GOTO lbl-1000
                    v5 = contractDescription;
                    if ((v5 != null ? FirCallsEffectAnalyzer.access$getParameterCallsEffect(FirCallsEffectAnalyzer.INSTANCE, v5, -1) : null) == null) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) break block13;
                }
                $this$getOrPut$iv$iv = IllegalScopeContext.access$getLeakedSymbols$p((IllegalScopeContext)this_$iv);
                $i$f$getOrPut = false;
                value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    $i$a$-unknown-FirCallsEffectAnalyzer$IllegalScopeContext$checkExpressionForLeakedSymbols$2$iv = false;
                    var15_18 = false;
                    answer$iv$iv = new ArrayList<E>();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    v7 /* !! */  = answer$iv$iv;
                } else {
                    v7 /* !! */  = value$iv$iv;
                }
                CollectionsKt.addIfNotNull((Collection)v7 /* !! */ , callSource);
            }
            for (FirExpression arg : node.getFir().getArgumentList().getArguments()) {
                this_$iv = data;
                v8 = arg;
                source$iv = v8 != null ? v8.getSource() : null;
                $i$f$checkExpressionForLeakedSymbols = false;
                symbol$iv = FirCallsEffectAnalyzer.access$referenceToSymbol(FirCallsEffectAnalyzer.INSTANCE, FirCallsEffectAnalyzer.access$toQualifiedReference(FirCallsEffectAnalyzer.INSTANCE, arg));
                if (symbol$iv == null || !IllegalScopeContext.access$getFunctionalTypeSymbols$p(this_$iv).contains(symbol$iv)) continue;
                if (!this_$iv.getInIllegalScope()) {
                    $i$a$-checkExpressionForLeakedSymbols-FirCallsEffectAnalyzer$CapturedLambdaFinder$visitFunctionCallNode$2 = false;
                    if (!(FirCallsEffectAnalyzer.access$getArgumentCallsEffect(FirCallsEffectAnalyzer.INSTANCE, node.getFir(), arg) == null)) continue;
                }
                $this$getOrPut$iv$iv = IllegalScopeContext.access$getLeakedSymbols$p(this_$iv);
                $i$f$getOrPut = false;
                value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    $i$a$-unknown-FirCallsEffectAnalyzer$IllegalScopeContext$checkExpressionForLeakedSymbols$2$iv = false;
                    var17_22 = false;
                    answer$iv$iv = new ArrayList<E>();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    v9 /* !! */  = answer$iv$iv;
                } else {
                    v9 /* !! */  = value$iv$iv;
                }
                CollectionsKt.addIfNotNull((Collection)v9 /* !! */ , source$iv);
            }
        }

        @NotNull
        public final FirFunction<?> getRootFunction() {
            return this.rootFunction;
        }

        public CapturedLambdaFinder(@NotNull FirFunction<?> rootFunction) {
            Intrinsics.checkNotNullParameter(rootFunction, (String)"rootFunction");
            this.rootFunction = rootFunction;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \r2\u0018\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\rB\u001f\u0012\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000R0\u0010\u0007\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0004\u0012\u00020\u00000\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "map", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentMap;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "constructor", "Lkotlin/Function1;", "getConstructor", "()Lkotlin/jvm/functions/Function1;", "merge", "other", "Companion", "checkers"})
    private static final class LambdaInvocationInfo
    extends ControlFlowInfo<LambdaInvocationInfo, FirBasedSymbol<?>, EventOccurrencesRange> {
        private final Function1<PersistentMap<FirBasedSymbol<?>, ? extends EventOccurrencesRange>, LambdaInvocationInfo> constructor;
        private static final LambdaInvocationInfo EMPTY;
        @NotNull
        public static final Companion Companion;

        @Override
        @NotNull
        protected Function1<PersistentMap<FirBasedSymbol<?>, ? extends EventOccurrencesRange>, LambdaInvocationInfo> getConstructor() {
            return this.constructor;
        }

        @NotNull
        public final LambdaInvocationInfo merge(@NotNull LambdaInvocationInfo other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            LambdaInvocationInfo result2 = this;
            for (FirBasedSymbol symbol2 : kotlin.collections.CollectionsKt.union((Iterable)this.keySet(), (Iterable)other.keySet())) {
                EventOccurrencesRange eventOccurrencesRange;
                EventOccurrencesRange kind1;
                EventOccurrencesRange eventOccurrencesRange2 = (EventOccurrencesRange)((Object)this.get((Object)symbol2));
                if (eventOccurrencesRange2 == null) {
                    eventOccurrencesRange2 = kind1 = EventOccurrencesRange.ZERO;
                }
                if ((eventOccurrencesRange = (EventOccurrencesRange)((Object)other.get((Object)symbol2))) == null) {
                    eventOccurrencesRange = EventOccurrencesRange.ZERO;
                }
                EventOccurrencesRange kind2 = eventOccurrencesRange;
                result2 = (LambdaInvocationInfo)result2.put(symbol2, (Object)kind1.or(kind2));
            }
            return result2;
        }

        public LambdaInvocationInfo(@NotNull PersistentMap<FirBasedSymbol<?>, ? extends EventOccurrencesRange> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            super(map2);
            this.constructor = constructor.1.INSTANCE;
        }

        public /* synthetic */ LambdaInvocationInfo(PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                persistentMap = ExtensionsKt.persistentMapOf(new Pair[0]);
            }
            this(persistentMap);
        }

        public LambdaInvocationInfo() {
            this(null, 1, null);
        }

        static {
            Companion = new Companion(null);
            EMPTY = new LambdaInvocationInfo(null, 1, null);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "checkers"})
        public static final class Companion {
            @NotNull
            public final LambdaInvocationInfo getEMPTY() {
                return EMPTY;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0017\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J#\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0001J\u001e\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\"\u0010\u0012\u001a\u00020\u00022\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u001c\u0010\u0014\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J%\u0010\u0017\u001a\u00020\u0002*\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0082\bR\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$InvocationDataCollector;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "", "functionalTypeSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "(Ljava/util/Set;)V", "getFunctionalTypeSymbols", "()Ljava/util/Set;", "collectDataForReference", "", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "visitFunctionCallNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallNode;", "data", "visitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "addInvocationInfo", "range", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "checkReference", "rangeGetter", "Lkotlin/Function0;", "checkers"})
    private static final class InvocationDataCollector
    extends ControlFlowGraphVisitor<LambdaInvocationInfo, Collection<? extends LambdaInvocationInfo>> {
        private final Set<AbstractFirBasedSymbol<?>> functionalTypeSymbols;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public LambdaInvocationInfo visitNode(@NotNull CFGNode<?> node, @NotNull Collection<LambdaInvocationInfo> data) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (data.isEmpty()) {
                return LambdaInvocationInfo.Companion.getEMPTY();
            }
            Iterable $this$reduce$iv = data;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p2;
                LambdaInvocationInfo lambdaInvocationInfo = (LambdaInvocationInfo)iterator$iv.next();
                LambdaInvocationInfo p1 = (LambdaInvocationInfo)accumulator$iv;
                boolean bl = false;
                accumulator$iv = p1.merge((LambdaInvocationInfo)p2);
            }
            return (LambdaInvocationInfo)accumulator$iv;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public LambdaInvocationInfo visitFunctionCallNode(@NotNull FunctionCallNode node, @NotNull Collection<LambdaInvocationInfo> data) {
            LambdaInvocationInfo lambdaInvocationInfo;
            EventOccurrencesRange eventOccurrencesRange;
            void var13_13;
            void var14_12;
            void $this$checkReference$iv;
            FirReference firReference;
            void this_$iv;
            FirFunctionSymbol functionSymbol;
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            LambdaInvocationInfo dataForNode = this.visitNode((CFGNode)node, data);
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(node.getFir());
            if (!(firCallableSymbol instanceof FirFunctionSymbol)) {
                firCallableSymbol = null;
            }
            FirContractDescription contractDescription = (object = (functionSymbol = (FirFunctionSymbol)firCallableSymbol)) != null && (object = (FirFunction)((AbstractFirBasedSymbol)object).getFir()) != null ? INSTANCE.getContractDescription((FirFunction)object) : null;
            Object object2 = dataForNode;
            InvocationDataCollector invocationDataCollector = this;
            Object reference$iv = INSTANCE.toQualifiedReference(node.getFir().getExplicitReceiver());
            boolean $i$f$checkReference2 = false;
            if (((InvocationDataCollector)this_$iv).collectDataForReference((FirReference)reference$iv)) {
                EventOccurrencesRange eventOccurrencesRange2;
                firReference = reference$iv;
                var14_12 = $this$checkReference$iv;
                var13_13 = this_$iv;
                boolean bl = false;
                Object object3 = functionSymbol;
                if (object3 != null && (object3 = ((FirFunctionSymbol)object3).getCallableId()) != null && ResolveUtilsKt.isInvoke((CallableId)object3)) {
                    eventOccurrencesRange2 = EventOccurrencesRange.EXACTLY_ONCE;
                } else {
                    eventOccurrencesRange2 = INSTANCE.getParameterCallsEffect(contractDescription, -1);
                    if (eventOccurrencesRange2 == null) {
                        eventOccurrencesRange2 = EventOccurrencesRange.UNKNOWN;
                    }
                }
                eventOccurrencesRange = eventOccurrencesRange2;
                lambdaInvocationInfo = ((InvocationDataCollector)var13_13).addInvocationInfo((LambdaInvocationInfo)var14_12, firReference, eventOccurrencesRange);
            } else {
                lambdaInvocationInfo = $this$checkReference$iv;
            }
            dataForNode = lambdaInvocationInfo;
            object2 = node.getFir().getArgumentList().getArguments().iterator();
            while (object2.hasNext()) {
                LambdaInvocationInfo lambdaInvocationInfo2;
                void $this$checkReference$iv2;
                void this_$iv2;
                FirExpression arg = (FirExpression)object2.next();
                LambdaInvocationInfo $i$f$checkReference2 = dataForNode;
                reference$iv = this;
                FirReference reference$iv2 = INSTANCE.toQualifiedReference(arg);
                boolean $i$f$checkReference3 = false;
                if (((InvocationDataCollector)this_$iv2).collectDataForReference(reference$iv2)) {
                    firReference = reference$iv2;
                    var14_12 = $this$checkReference$iv2;
                    var13_13 = this_$iv2;
                    boolean bl = false;
                    EventOccurrencesRange eventOccurrencesRange3 = INSTANCE.getArgumentCallsEffect(node.getFir(), arg);
                    if (eventOccurrencesRange3 == null) {
                        eventOccurrencesRange3 = EventOccurrencesRange.ZERO;
                    }
                    eventOccurrencesRange = eventOccurrencesRange3;
                    lambdaInvocationInfo2 = ((InvocationDataCollector)var13_13).addInvocationInfo((LambdaInvocationInfo)var14_12, firReference, eventOccurrencesRange);
                } else {
                    lambdaInvocationInfo2 = $this$checkReference$iv2;
                }
                dataForNode = lambdaInvocationInfo2;
            }
            return dataForNode;
        }

        private final boolean collectDataForReference(FirReference reference) {
            boolean bl = false;
            return reference != null && kotlin.collections.CollectionsKt.contains((Iterable)this.functionalTypeSymbols, (Object)INSTANCE.referenceToSymbol(reference));
        }

        private final LambdaInvocationInfo addInvocationInfo(LambdaInvocationInfo $this$addInvocationInfo, FirReference reference, EventOccurrencesRange range) {
            LambdaInvocationInfo lambdaInvocationInfo;
            AbstractFirBasedSymbol symbol2 = INSTANCE.referenceToSymbol(reference);
            if (symbol2 != null) {
                EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)$this$addInvocationInfo.get((Object)symbol2));
                if (eventOccurrencesRange == null) {
                    eventOccurrencesRange = EventOccurrencesRange.ZERO;
                }
                EventOccurrencesRange existingKind = eventOccurrencesRange;
                EventOccurrencesRange kind = existingKind.plus(range);
                lambdaInvocationInfo = (LambdaInvocationInfo)$this$addInvocationInfo.put(symbol2, (Object)kind);
            } else {
                lambdaInvocationInfo = $this$addInvocationInfo;
            }
            return lambdaInvocationInfo;
        }

        @NotNull
        public final Set<AbstractFirBasedSymbol<?>> getFunctionalTypeSymbols() {
            return this.functionalTypeSymbols;
        }

        public InvocationDataCollector(@NotNull Set<? extends AbstractFirBasedSymbol<?>> functionalTypeSymbols) {
            Intrinsics.checkNotNullParameter(functionalTypeSymbols, (String)"functionalTypeSymbols");
            this.functionalTypeSymbols = functionalTypeSymbols;
        }
    }
}

