/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.ControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\"\u0010\u0010\u001a\u00020\u00022\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u001e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00142\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u001e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationInfoCollector;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationInfo;", "", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Ljava/util/Set;)V", "getData", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "processVariableWithAssignment", "dataForNode", "symbol", "visitNode", "node", "data", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
public final class PropertyInitializationInfoCollector
extends ControlFlowGraphVisitor<PropertyInitializationInfo, Collection<? extends PropertyInitializationInfo>> {
    private final Set<FirPropertySymbol> localProperties;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PropertyInitializationInfo visitNode(@NotNull CFGNode<?> node, @NotNull Collection<PropertyInitializationInfo> data) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (data.isEmpty()) {
            return PropertyInitializationInfo.Companion.getEMPTY();
        }
        Iterable $this$reduce$iv = data;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p2;
            PropertyInitializationInfo propertyInitializationInfo = (PropertyInitializationInfo)iterator$iv.next();
            PropertyInitializationInfo p1 = (PropertyInitializationInfo)accumulator$iv;
            boolean bl = false;
            accumulator$iv = p1.merge((PropertyInitializationInfo)p2);
        }
        return (PropertyInitializationInfo)accumulator$iv;
    }

    @Override
    @NotNull
    public PropertyInitializationInfo visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull Collection<PropertyInitializationInfo> data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        PropertyInitializationInfo dataForNode = this.visitNode((CFGNode)node, data);
        FirReference firReference = node.getFir().getLValue();
        if (!(firReference instanceof FirResolvedNamedReference)) {
            firReference = null;
        }
        FirResolvedNamedReference firResolvedNamedReference = (FirResolvedNamedReference)firReference;
        if (firResolvedNamedReference == null) {
            return dataForNode;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = reference.getResolvedSymbol();
        if (!(abstractFirBasedSymbol instanceof FirPropertySymbol)) {
            abstractFirBasedSymbol = null;
        }
        FirPropertySymbol firPropertySymbol = (FirPropertySymbol)abstractFirBasedSymbol;
        if (firPropertySymbol == null) {
            return dataForNode;
        }
        FirPropertySymbol symbol2 = firPropertySymbol;
        return !this.localProperties.contains(symbol2) ? dataForNode : this.processVariableWithAssignment(dataForNode, symbol2);
    }

    @Override
    @NotNull
    public PropertyInitializationInfo visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull Collection<PropertyInitializationInfo> data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        PropertyInitializationInfo dataForNode = this.visitNode((CFGNode)node, data);
        return node.getFir().getInitializer() == null && node.getFir().getDelegate() == null ? dataForNode : this.processVariableWithAssignment(dataForNode, node.getFir().getSymbol());
    }

    @NotNull
    public final Map<CFGNode<?>, PropertyInitializationInfo> getData(@NotNull ControlFlowGraph graph2) {
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        return CfgTraverserKt.collectDataForNode(graph2, TraverseDirection.Forward, (ControlFlowInfo)PropertyInitializationInfo.Companion.getEMPTY(), this);
    }

    private final PropertyInitializationInfo processVariableWithAssignment(PropertyInitializationInfo dataForNode, FirPropertySymbol symbol2) {
        EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)dataForNode.get((Object)symbol2));
        if (eventOccurrencesRange == null) {
            eventOccurrencesRange = EventOccurrencesRange.ZERO;
        }
        EventOccurrencesRange existingKind = eventOccurrencesRange;
        EventOccurrencesRange kind = existingKind.plus(EventOccurrencesRange.EXACTLY_ONCE);
        return (PropertyInitializationInfo)dataForNode.put(symbol2, (Object)kind);
    }

    public PropertyInitializationInfoCollector(@NotNull Set<? extends FirPropertySymbol> localProperties) {
        Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
        this.localProperties = localProperties;
    }
}

