/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u0011H\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u0012H\u0002J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\u0016\u0010\u0015\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypeInitializedWithoutPrimaryConstructor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "anySupertypeHasConstructorParentheses", "", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getChildren", "", "report", "source", "checkers"})
public final class FirSupertypeInitializedWithoutPrimaryConstructor
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirSupertypeInitializedWithoutPrimaryConstructor INSTANCE;

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean hasPrimaryConstructor;
        boolean hasSupertypeWithConstructor;
        block5: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (!(declaration2 instanceof FirRegularClass) || ((FirRegularClass)declaration2).getClassKind() == ClassKind.INTERFACE) {
                return;
            }
            FirSourceElement firSourceElement = declaration2.getSource();
            hasSupertypeWithConstructor = firSourceElement != null && this.anySupertypeHasConstructorParentheses(firSourceElement);
            Iterable $this$any$iv = ((FirRegularClass)declaration2).getDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof FirConstructor && ((FirConstructor)it).isPrimary())) continue;
                    bl = true;
                    break block5;
                }
                bl = hasPrimaryConstructor = false;
            }
        }
        if (hasSupertypeWithConstructor && !hasPrimaryConstructor) {
            this.report(reporter, declaration2.getSource());
        }
    }

    private final boolean anySupertypeHasConstructorParentheses(FirSourceElement $this$anySupertypeHasConstructorParentheses) {
        PsiElement localPsi = FirSourceElementKt.getPsi($this$anySupertypeHasConstructorParentheses);
        LighterASTNode localLightNode = FirSourceElementKt.getLightNode($this$anySupertypeHasConstructorParentheses);
        if (localPsi != null && !(localPsi instanceof PsiErrorElement)) {
            return this.anySupertypeHasConstructorParentheses(localPsi);
        }
        if (localLightNode != null && $this$anySupertypeHasConstructorParentheses instanceof FirLightSourceElement) {
            return this.anySupertypeHasConstructorParentheses(localLightNode, ((FirLightSourceElement)$this$anySupertypeHasConstructorParentheses).getTree());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean anySupertypeHasConstructorParentheses(PsiElement $this$anySupertypeHasConstructorParentheses) {
        PsiElement[] children2 = $this$anySupertypeHasConstructorParentheses.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)children2, (String)"children");
        PsiElement[] psiElementArray = children2;
        boolean bl = false;
        PsiElement[] psiElementArray2 = psiElementArray;
        int n = 0;
        if (psiElementArray2.length == 0) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        if (children2[0] instanceof PsiErrorElement) return false;
        PsiElement psiElement = children2[0];
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"children[0]");
        PsiElement[] psiElementArray3 = psiElement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"children[0].children");
        PsiElement[] $this$any$iv = psiElementArray3;
        boolean $i$f$any = false;
        psiElementArray2 = $this$any$iv;
        n = psiElementArray2.length;
        int n2 = 0;
        while (n2 < n) {
            PsiElement element$iv;
            PsiElement it = element$iv = psiElementArray2[n2];
            boolean bl4 = false;
            if (it instanceof KtSuperTypeCallEntry) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private final boolean anySupertypeHasConstructorParentheses(LighterASTNode $this$anySupertypeHasConstructorParentheses, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        boolean bl;
        block6: {
            Object v0;
            block5: {
                Iterable iterable = this.getChildren($this$anySupertypeHasConstructorParentheses, tree);
                boolean bl2 = false;
                Iterable iterable2 = iterable;
                boolean bl3 = false;
                Iterator iterator2 = iterable2.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    LighterASTNode it = (LighterASTNode)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.SUPER_TYPE_LIST)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            LighterASTNode lighterASTNode = v0;
            if (lighterASTNode == null) {
                return false;
            }
            LighterASTNode superTypes2 = lighterASTNode;
            Iterable $this$any$iv = this.getChildren(superTypes2, tree);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LighterASTNode it = (LighterASTNode)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.SUPER_TYPE_CALL_ENTRY)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<LighterASTNode> getChildren(LighterASTNode $this$getChildren, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        List list2;
        Ref<T[]> children2 = new Ref<T[]>();
        int count = tree.getChildren($this$getChildren, children2);
        if (count > 0) {
            Object[] objectArray = children2.get();
            Intrinsics.checkNotNullExpressionValue(objectArray, (String)"children.get()");
            list2 = ArraysKt.filterNotNull((Object[])objectArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR().on(it));
        }
    }

    private FirSupertypeInitializedWithoutPrimaryConstructor() {
    }

    static {
        FirSupertypeInitializedWithoutPrimaryConstructor firSupertypeInitializedWithoutPrimaryConstructor;
        INSTANCE = firSupertypeInitializedWithoutPrimaryConstructor = new FirSupertypeInitializedWithoutPrimaryConstructor();
    }
}

