/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt$WhenMappings;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u001e\u0010\t\u001a\u00020\u0006*\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u000b\u001a0\u0010\t\u001a\u00020\u0006*\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\rH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001f\u0010\u0012\u001a\u00020\u0013*\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0015\u00a2\u0006\u0002\u0010\u0016\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0017"}, d2={"classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getClassId", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/name/ClassId;", "isMarkedNullable", "", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "isNullable", "contains", "predicate", "Lkotlin/Function1;", "visited", "Lorg/jetbrains/kotlin/utils/SmartSet;", "toTypeProjection", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "withArguments", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "typeArguments", "", "(Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "cones"})
public final class ConeTypeUtilsKt {
    public static final boolean isNullable(@NotNull ConeKotlinType $this$isNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"$this$isNullable");
        return $this$isNullable.getNullability() != ConeNullability.NOT_NULL;
    }

    public static final boolean isMarkedNullable(@NotNull ConeKotlinType $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedNullable, (String)"$this$isMarkedNullable");
        return $this$isMarkedNullable.getNullability() == ConeNullability.NULLABLE;
    }

    @Nullable
    public static final ClassId getClassId(@NotNull ConeKotlinType $this$classId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"$this$classId");
        ConeKotlinType $this$safeAs$iv = $this$classId;
        boolean $i$f$safeAs = false;
        ConeKotlinType coneKotlinType = $this$safeAs$iv;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (object = (ConeClassLikeType)coneKotlinType) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null;
    }

    public static final boolean contains(@NotNull ConeKotlinType $this$contains, @NotNull Function1<? super ConeKotlinType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"$this$contains");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return ConeTypeUtilsKt.contains($this$contains, predicate, null);
    }

    private static final boolean contains(ConeKotlinType $this$contains, Function1<? super ConeKotlinType, Boolean> predicate, SmartSet<ConeKotlinType> visited2) {
        boolean bl;
        block14: {
            SmartSet<ConeKotlinType> smartSet = visited2;
            if (smartSet != null) {
                if (smartSet.contains($this$contains)) {
                    return false;
                }
            }
            if (((Boolean)predicate.invoke((Object)$this$contains)).booleanValue()) {
                return true;
            }
            SmartSet<ConeKotlinType> smartSet2 = visited2;
            if (smartSet2 == null) {
                smartSet2 = SmartSet.Companion.create();
            }
            SmartSet<ConeKotlinType> visited3 = smartSet2;
            Object object = visited3;
            boolean bl2 = false;
            object.add($this$contains);
            object = $this$contains;
            if (object instanceof ConeFlexibleType) {
                bl = ConeTypeUtilsKt.contains(((ConeFlexibleType)$this$contains).getLowerBound(), predicate, visited3) || ConeTypeUtilsKt.contains(((ConeFlexibleType)$this$contains).getUpperBound(), predicate, visited3);
            } else if (object instanceof ConeDefinitelyNotNullType) {
                bl = ConeTypeUtilsKt.contains(((ConeDefinitelyNotNullType)$this$contains).getOriginal(), predicate, visited3);
            } else if (object instanceof ConeIntersectionType) {
                Iterable $this$any$iv = ((ConeIntersectionType)$this$contains).getIntersectedTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl3 = false;
                        if (!ConeTypeUtilsKt.contains(it, predicate, visited3)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            } else {
                ConeTypeProjection[] $this$any$iv = $this$contains.getTypeArguments();
                boolean $i$f$any = false;
                ConeTypeProjection[] coneTypeProjectionArray = $this$any$iv;
                int n = coneTypeProjectionArray.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it = element$iv = coneTypeProjectionArray[i];
                    boolean bl4 = false;
                    if (!(it instanceof ConeKotlinTypeProjection && ConeTypeUtilsKt.contains(((ConeKotlinTypeProjection)it).getType(), predicate, visited3))) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final ConeClassLikeType withArguments(@NotNull ConeClassLikeType $this$withArguments, @NotNull ConeTypeProjection[] typeArguments2) {
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter((Object)$this$withArguments, (String)"$this$withArguments");
        Intrinsics.checkNotNullParameter((Object)typeArguments2, (String)"typeArguments");
        ConeClassLikeType coneClassLikeType2 = $this$withArguments;
        if (coneClassLikeType2 instanceof ConeClassLikeTypeImpl) {
            coneClassLikeType = new ConeClassLikeTypeImpl($this$withArguments.getLookupTag(), typeArguments2, ConeTypeUtilsKt.isNullable($this$withArguments), $this$withArguments.getAttributes());
        } else if (coneClassLikeType2 instanceof ConeClassErrorType) {
            coneClassLikeType = $this$withArguments;
        } else {
            String string2 = "Unknown cone type: " + Reflection.getOrCreateKotlinClass($this$withArguments.getClass());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return coneClassLikeType;
    }

    @NotNull
    public static final ConeTypeProjection toTypeProjection(@NotNull ConeKotlinType $this$toTypeProjection, @NotNull Variance variance) {
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        Intrinsics.checkNotNullParameter((Object)$this$toTypeProjection, (String)"$this$toTypeProjection");
        Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"variance");
        switch (ConeTypeUtilsKt$WhenMappings.$EnumSwitchMapping$0[variance.ordinal()]) {
            case 1: {
                coneKotlinTypeProjection = $this$toTypeProjection;
                break;
            }
            case 2: {
                coneKotlinTypeProjection = new ConeKotlinTypeProjectionIn($this$toTypeProjection);
                break;
            }
            case 3: {
                coneKotlinTypeProjection = new ConeKotlinTypeProjectionOut($this$toTypeProjection);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneKotlinTypeProjection;
    }
}

