/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.File;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class StartParamsValidatingActionExecuter
implements BuildActionExecuter<BuildActionParameters, BuildRequestContext> {
    private final BuildActionExecuter<BuildActionParameters, BuildRequestContext> delegate;

    public StartParamsValidatingActionExecuter(BuildActionExecuter<BuildActionParameters, BuildRequestContext> delegate) {
        this.delegate = delegate;
    }

    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext requestContext) {
        StartParameterInternal startParameter = action.getStartParameter();
        if (startParameter.getBuildFile() != null) {
            StartParamsValidatingActionExecuter.validateIsFileAndExists(startParameter.getBuildFile(), "build file");
        }
        if (startParameter.getProjectDir() != null && !startParameter.getProjectDir().isDirectory()) {
            if (!startParameter.getProjectDir().exists()) {
                throw new IllegalArgumentException(String.format("The specified project directory '%s' does not exist.", startParameter.getProjectDir()));
            }
            throw new IllegalArgumentException(String.format("The specified project directory '%s' is not a directory.", startParameter.getProjectDir()));
        }
        if (startParameter.getSettingsFile() != null) {
            StartParamsValidatingActionExecuter.validateIsFileAndExists(startParameter.getSettingsFile(), "settings file");
        }
        for (File initScript : startParameter.getInitScripts()) {
            StartParamsValidatingActionExecuter.validateIsFileAndExists(initScript, "initialization script");
        }
        return this.delegate.execute(action, actionParameters, requestContext);
    }

    private static void validateIsFileAndExists(File file, String fileType) {
        if (!file.isFile()) {
            if (!file.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s '%s' does not exist.", fileType, file));
            }
            throw new IllegalArgumentException(String.format("The specified %s '%s' is not a file.", fileType, file));
        }
    }
}

