/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.util.GUtil;

public class DefaultProjectRegistry<T extends ProjectIdentifier>
implements ProjectRegistry<T> {
    private Map<String, T> projects = new HashMap<String, T>();
    private Map<String, Set<T>> subProjects = new HashMap<String, Set<T>>();

    @Override
    public void addProject(T project) {
        this.projects.put(project.getPath(), project);
        this.subProjects.put(project.getPath(), new HashSet());
        this.addProjectToParentSubProjects(project);
    }

    public T removeProject(String path) {
        ProjectIdentifier project = (ProjectIdentifier)this.projects.remove(path);
        assert (project != null);
        this.subProjects.remove(path);
        for (ProjectIdentifier loopProject = project.getParentIdentifier(); loopProject != null; loopProject = loopProject.getParentIdentifier()) {
            this.subProjects.get(loopProject.getPath()).remove(project);
        }
        return (T)project;
    }

    private void addProjectToParentSubProjects(T project) {
        for (ProjectIdentifier loopProject = project.getParentIdentifier(); loopProject != null; loopProject = loopProject.getParentIdentifier()) {
            this.subProjects.get(loopProject.getPath()).add(project);
        }
    }

    @Override
    public int size() {
        return this.projects.size();
    }

    @Override
    public Set<T> getAllProjects() {
        return new HashSet<T>(this.projects.values());
    }

    @Override
    public T getRootProject() {
        return this.getProject(":");
    }

    @Override
    public T getProject(String path) {
        return (T)((ProjectIdentifier)this.projects.get(path));
    }

    @Override
    public T getProject(final File projectDir) {
        Set<T> projects = this.findAll(new Spec<T>(){

            public boolean isSatisfiedBy(T element) {
                return element.getProjectDir().equals(projectDir);
            }
        });
        if (projects.size() > 1) {
            throw new InvalidUserDataException(String.format("Found multiple projects with project directory '%s': %s", projectDir, projects));
        }
        return (T)(projects.size() == 1 ? (ProjectIdentifier)projects.iterator().next() : null);
    }

    @Override
    public Set<T> getAllProjects(String path) {
        HashSet<T> result = new HashSet<T>(this.getSubProjects(path));
        if (this.projects.get(path) != null) {
            result.add((ProjectIdentifier)this.projects.get(path));
        }
        return result;
    }

    @Override
    public Set<T> getSubProjects(String path) {
        return (Set)GUtil.getOrDefault(this.subProjects.get(path), HashSet::new);
    }

    @Override
    public Set<T> findAll(Spec<? super T> constraint) {
        HashSet<ProjectIdentifier> matches = new HashSet<ProjectIdentifier>();
        for (ProjectIdentifier project : this.projects.values()) {
            if (!constraint.isSatisfiedBy((Object)project)) continue;
            matches.add(project);
        }
        return matches;
    }
}

