/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.util.NumberUtil;

public class ResourceOperation {
    private final ProgressLogger progressLogger;
    private final Type operationType;
    private final String contentLengthString;
    private long loggedKBytes;
    private long totalProcessedBytes;

    public ResourceOperation(ProgressLogger progressLogger, Type type, long contentLength) {
        this.progressLogger = progressLogger;
        this.operationType = type;
        this.contentLengthString = NumberUtil.formatBytes((Long)(contentLength == 0L ? null : Long.valueOf(contentLength)));
    }

    public void logProcessedBytes(long processedBytes) {
        this.totalProcessedBytes += processedBytes;
        long processedKiB = this.totalProcessedBytes / 1024L;
        if (processedKiB > this.loggedKBytes) {
            this.loggedKBytes = processedKiB;
            String progressMessage = String.format("%s/%s %sed", new Object[]{NumberUtil.formatBytes((Long)this.totalProcessedBytes), this.contentLengthString, this.operationType});
            this.progressLogger.progress(progressMessage);
        }
    }

    public void completed() {
        this.progressLogger.completed();
    }

    public static enum Type {
        download,
        upload;


        public String getCapitalized() {
            return StringUtils.capitalize((String)this.toString());
        }
    }
}

