/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import org.gradle.api.internal.tasks.CurrentJvmJavaToolChain;
import org.gradle.api.internal.tasks.JavaHomeBasedJavaToolChain;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.jvm.toolchain.internal.JavaCompilerFactory;
import org.gradle.process.internal.ExecActionFactory;

public class JavaToolChainFactory {
    private final JavaCompilerFactory javaCompilerFactory;
    private final ExecActionFactory execActionFactory;
    private final JvmVersionDetector jvmVersionDetector;

    public JavaToolChainFactory(JavaCompilerFactory javaCompilerFactory, ExecActionFactory execActionFactory, JvmVersionDetector jvmVersionDetector) {
        this.javaCompilerFactory = javaCompilerFactory;
        this.execActionFactory = execActionFactory;
        this.jvmVersionDetector = jvmVersionDetector;
    }

    public JavaToolChain forCompileOptions(CompileOptions compileOptions) {
        ForkOptions forkOptions;
        File javaHome;
        if (compileOptions.isFork() && (javaHome = (forkOptions = compileOptions.getForkOptions()).getJavaHome()) != null) {
            return new JavaHomeBasedJavaToolChain(javaHome, this.javaCompilerFactory, this.execActionFactory, this.jvmVersionDetector);
        }
        return new CurrentJvmJavaToolChain(this.javaCompilerFactory, this.execActionFactory);
    }
}

