/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;

public class FileNameDerivingClassNameConverter
implements SourceFileClassNameConverter {
    @Override
    public Collection<String> getClassNames(String sourceFileRelativePath) {
        return Collections.singleton(FileNameDerivingClassNameConverter.findClassNameForRelativePath(sourceFileRelativePath));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Optional<String> getRelativeSourcePath(String className) {
        int innerClassIdx = className.indexOf("$");
        String baseName = innerClassIdx > 0 ? className.substring(0, innerClassIdx) : className;
        return Optional.of(baseName.replace('.', '/') + ".java");
    }

    private static String findClassNameForRelativePath(String relativePath) {
        return relativePath.replace('/', '.').replaceAll("\\.java$", "");
    }
}

