/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.internal.catalog.BundleModel;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.internal.catalog.VersionModel;

public class DefaultVersionCatalog
implements Serializable {
    private final String name;
    private final String description;
    private final Map<String, DependencyModel> aliasToDependency;
    private final Map<String, BundleModel> bundles;
    private final Map<String, VersionModel> versions;
    private final int hashCode;

    public DefaultVersionCatalog(String name, String description, Map<String, DependencyModel> aliasToDependency, Map<String, BundleModel> bundles, Map<String, VersionModel> versions) {
        this.name = name;
        this.description = description;
        this.aliasToDependency = aliasToDependency;
        this.bundles = bundles;
        this.versions = versions;
        this.hashCode = this.doComputeHashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getDependencyAliases() {
        return this.aliasToDependency.keySet().stream().sorted().collect(Collectors.toList());
    }

    public List<String> getBundleAliases() {
        return this.bundles.keySet().stream().sorted().collect(Collectors.toList());
    }

    public DependencyModel getDependencyData(String alias) {
        return this.aliasToDependency.get(alias);
    }

    public List<String> getVersionAliases() {
        return this.versions.keySet().stream().sorted().collect(Collectors.toList());
    }

    public BundleModel getBundle(String name) {
        return this.bundles.get(name);
    }

    public VersionModel getVersion(String name) {
        return this.versions.get(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultVersionCatalog that = (DefaultVersionCatalog)o;
        if (!this.aliasToDependency.equals(that.aliasToDependency)) {
            return false;
        }
        if (!this.bundles.equals(that.bundles)) {
            return false;
        }
        return this.versions.equals(that.versions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int doComputeHashCode() {
        int result = this.aliasToDependency.hashCode();
        result = 31 * result + this.bundles.hashCode();
        result = 31 * result + this.versions.hashCode();
        return result;
    }

    public boolean isNotEmpty() {
        return !this.aliasToDependency.isEmpty() || !this.bundles.isEmpty() || !this.versions.isEmpty();
    }
}

