/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectAnnotationSource;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectKotlinClassKt;
import org.jetbrains.kotlin.descriptors.runtime.components.SignatureSerializer;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectClassUtilKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ClassLiteralValue;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001a\u0010\u0018\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0019\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/components/ReflectClassStructure;", "", "()V", "loadClassAnnotations", "", "klass", "Ljava/lang/Class;", "visitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationVisitor;", "loadConstructorAnnotations", "memberVisitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$MemberVisitor;", "loadFieldAnnotations", "loadMethodAnnotations", "processAnnotation", "annotation", "", "processAnnotationArgumentValue", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationArgumentVisitor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "value", "processAnnotationArguments", "annotationType", "visitMembers", "classLiteralValue", "Lorg/jetbrains/kotlin/resolve/constants/ClassLiteralValue;", "descriptors.runtime"})
final class ReflectClassStructure {
    @NotNull
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    public final void loadClassAnnotations(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"klass.declaredAnnotations");
        for (Annotation annotation2 : annotationArray) {
            Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"annotation");
            this.processAnnotation(visitor2, annotation2);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)memberVisitor, (String)"memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"klass.declaredMethods");
        Method[] methodArray2 = methodArray;
        int n = 0;
        int n2 = methodArray2.length;
        while (n < n2) {
            Method method = methodArray2[n];
            ++n;
            Annotation[] annotationArray = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"identifier(method.name)");
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            Annotation[] annotationArray2 = memberVisitor.visitMethod((Name)annotationArray, SignatureSerializer.INSTANCE.methodDesc(method));
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = method.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"method.declaredAnnotations");
            for (Annotation annotation2 : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = (KotlinJvmBinaryClass.AnnotationVisitor)visitor2;
                Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] annotationArray3 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray3, (String)"method.parameterAnnotations");
            annotationArray2 = annotationArray3;
            int n3 = 0;
            int n4 = ((Object[])annotationArray2).length;
            while (n3 < n4) {
                int parameterIndex = n3;
                Annotation annotations2 = annotationArray2[n3];
                ++n3;
                Intrinsics.checkNotNullExpressionValue((Object)annotations2, (String)"annotations");
                for (Annotation annotation3 : annotations2) {
                    Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation3));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Intrinsics.checkNotNullExpressionValue((Object)annotation3, (String)"annotation");
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation3));
                    if (annotationArgumentVisitor == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
                    boolean bl = false;
                    boolean bl2 = false;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor2;
                    boolean bl3 = false;
                    this.processAnnotationArguments(it, annotation3, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"klass.declaredConstructors");
        Constructor<?>[] constructorArray2 = constructorArray;
        int n = 0;
        int n2 = constructorArray2.length;
        while (n < n2) {
            Constructor<?> constructor2 = constructorArray2[n];
            ++n;
            Annotation[] annotationArray = Name.special("<init>");
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"special(\"<init>\")");
            Intrinsics.checkNotNullExpressionValue(constructor2, (String)"constructor");
            Annotation[] annotationArray2 = memberVisitor.visitMethod((Name)annotationArray, SignatureSerializer.INSTANCE.constructorDesc(constructor2));
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = constructor2.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"constructor.declaredAnnotations");
            for (Annotation annotation2 : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = (KotlinJvmBinaryClass.AnnotationVisitor)visitor2;
                Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] parameterAnnotations = constructor2.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)parameterAnnotations, (String)"parameterAnnotations");
            Object[] objectArray = (Object[])parameterAnnotations;
            int n3 = 0;
            Object[] objectArray2 = objectArray;
            int n4 = 0;
            if (!(objectArray2.length == 0)) {
                int shift = constructor2.getParameterTypes().length - ((Object[])parameterAnnotations).length;
                Annotation[][] annotationArray3 = parameterAnnotations;
                int n5 = 0;
                n4 = ((Object[])annotationArray3).length;
                while (n5 < n4) {
                    int parameterIndex = n5;
                    Annotation[] annotations2 = annotationArray3[n5];
                    ++n5;
                    Intrinsics.checkNotNullExpressionValue((Object)annotations2, (String)"annotations");
                    for (Annotation annotation3 : annotations2) {
                        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation3));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Intrinsics.checkNotNullExpressionValue((Object)annotation3, (String)"annotation");
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation3));
                        if (annotationArgumentVisitor == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
                        boolean bl = false;
                        boolean bl2 = false;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor2;
                        boolean bl3 = false;
                        this.processAnnotationArguments(it, annotation3, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"klass.declaredFields");
        Field[] fieldArray2 = fieldArray;
        int n = 0;
        int n2 = fieldArray2.length;
        while (n < n2) {
            Field field = fieldArray2[n];
            ++n;
            Annotation[] annotationArray = Name.identifier(field.getName());
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"identifier(field.name)");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            Annotation[] annotationArray2 = memberVisitor.visitField((Name)annotationArray, SignatureSerializer.INSTANCE.fieldDesc(field), null);
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = field.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"field.declaredAnnotations");
            for (Annotation annotation2 : annotationArray) {
                Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"annotation");
                this.processAnnotation((KotlinJvmBinaryClass.AnnotationVisitor)visitor2, annotation2);
            }
            visitor2.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation2) {
        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation2));
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation2));
        if (annotationArgumentVisitor != null) {
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
            boolean bl = false;
            boolean bl2 = false;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor2;
            boolean bl3 = false;
            this.processAnnotationArguments(it, annotation2, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation2, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"annotationType.declaredMethods");
        for (Method method : methodArray) {
            Object object;
            try {
                object = method.invoke((Object)annotation2, new Object[0]);
                Intrinsics.checkNotNull((Object)object);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            Object value2 = object;
            object = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(method.name)");
            this.processAnnotationArgumentValue(visitor2, (Name)object, value2);
        }
        visitor2.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class<?> $this$classLiteralValue) {
        Object object;
        Class<?> currentClass = $this$classLiteralValue;
        int dimensions = 0;
        while (currentClass.isArray()) {
            int n = dimensions;
            dimensions = n + 1;
            object = currentClass.getComponentType();
            Intrinsics.checkNotNullExpressionValue(object, (String)"currentClass.componentType");
            currentClass = object;
        }
        if (currentClass.isPrimitive()) {
            if (Intrinsics.areEqual(currentClass, Void.TYPE)) {
                object = ClassId.topLevel(StandardNames.FqNames.unit.toSafe());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(StandardNames.FqNames.unit.toSafe())");
                return new ClassLiteralValue((ClassId)object, dimensions);
            }
            Object object2 = JvmPrimitiveType.get(currentClass.getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(currentClass.name).primitiveType");
            PrimitiveType primitiveType = object2;
            if (dimensions > 0) {
                object2 = ClassId.topLevel(primitiveType.getArrayTypeFqName());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(primitiveType.arrayTypeFqName)");
                return new ClassLiteralValue((ClassId)object2, dimensions - 1);
            }
            object2 = ClassId.topLevel(primitiveType.getTypeFqName());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(primitiveType.typeFqName)");
            return new ClassLiteralValue((ClassId)object2, dimensions);
        }
        ClassId javaClassId = ReflectClassUtilKt.getClassId(currentClass);
        FqName fqName2 = javaClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"javaClassId.asSingleFqName()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        ClassId kotlinClassId = classId == null ? javaClassId : classId;
        return new ClassLiteralValue(kotlinClassId, dimensions);
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name, Object value2) {
        Class<?> clazz = value2.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            visitor2.visitClassLiteral(name, this.classLiteralValue((Class)value2));
        } else if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p$s-1934497501().contains(clazz)) {
            visitor2.visit(name, value2);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Object object = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNullExpressionValue(object, (String)"if (clazz.isEnum) clazz else clazz.enclosingClass");
            ClassId classId = ReflectClassUtilKt.getClassId(object);
            object = Name.identifier(((Enum)value2).name());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier((value as Enum<*>).name)");
            visitor2.visitEnum(name, classId, (Name)object);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"clazz.interfaces");
            Class annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNullExpressionValue((Object)annotationClass, (String)"annotationClass");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name, ReflectClassUtilKt.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            this.processAnnotationArguments(v, (Annotation)value2, annotationClass);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = visitor2.visitArray(name);
            if (v == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v2 = v;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isEnum()) {
                Intrinsics.checkNotNullExpressionValue(componentType, (String)"componentType");
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                for (Object element : (Object[])value2) {
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Enum<*>");
                    }
                    Name name2 = Name.identifier(((Enum)element).name());
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier((element as Enum<*>).name)");
                    v2.visitEnum(enumClassId, name2);
                }
            } else if (Intrinsics.areEqual(componentType, Class.class)) {
                for (Object element : (Object[])value2) {
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                    }
                    v2.visitClassLiteral(this.classLiteralValue((Class)element));
                }
            } else {
                for (Object element : (Object[])value2) {
                    v2.visit(element);
                }
            }
            v2.visitEnd();
        } else {
            throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value2);
        }
    }
}

