/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureDescriptor;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.FirDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.SimpleDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.jvm.Fir2IrJvmSpecialAnnotationSymbolProvider;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmKotlinMangler;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmVisibilityConverter;
import org.jetbrains.kotlin.fir.builder.RawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessor;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmManglerDesc;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorExtensions;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00070\u000bJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u0007R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0007\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/FirAnalyzerFacade;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Ljava/util/List;)V", "collectedDiagnostics", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "firFiles", "getKtFiles", "()Ljava/util/List;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildRawFir", "", "convertToIr", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "extensions", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions;", "runCheckers", "runResolution", "entrypoint"})
public final class FirAnalyzerFacade {
    @NotNull
    private final FirSession session;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final List<KtFile> ktFiles;
    @Nullable
    private List<? extends FirFile> firFiles;
    @Nullable
    private ScopeSession scopeSession;
    @Nullable
    private Map<FirFile, ? extends List<? extends FirDiagnostic<?>>> collectedDiagnostics;

    public FirAnalyzerFacade(@NotNull FirSession session2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull List<? extends KtFile> ktFiles) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        this.session = session2;
        this.languageVersionSettings = languageVersionSettings;
        this.ktFiles = ktFiles;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final List<KtFile> getKtFiles() {
        return this.ktFiles;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRawFir() {
        Collection<FirFile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.firFiles != null) {
            return;
        }
        FirProviderImpl firProvider = (FirProviderImpl)MainSessionComponentsKt.getFirProvider(this.session);
        RawFirBuilder builder2 = new RawFirBuilder(this.session, firProvider.getKotlinScopeProvider(), null, 4, null);
        Iterable iterable = this.ktFiles;
        FirAnalyzerFacade firAnalyzerFacade = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtFile ktFile = (KtFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirFile firFile = builder2.buildFirFile((KtFile)it);
            firProvider.recordFile(firFile);
            FirFile firFile2 = firFile;
            collection.add(firFile2);
        }
        collection = (List)destination$iv$iv;
        firAnalyzerFacade.firFiles = collection;
    }

    @NotNull
    public final List<FirFile> runResolution() {
        if (this.firFiles == null) {
            this.buildRawFir();
        }
        if (this.scopeSession != null) {
            List<FirFile> list2 = this.firFiles;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        FirTotalResolveProcessor resolveProcessor = new FirTotalResolveProcessor(this.session);
        List<FirFile> list3 = this.firFiles;
        Intrinsics.checkNotNull(list3);
        resolveProcessor.process(list3);
        this.scopeSession = resolveProcessor.getScopeSession();
        list3 = this.firFiles;
        Intrinsics.checkNotNull(list3);
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<FirFile, List<FirDiagnostic<?>>> runCheckers() {
        if (this.scopeSession == null) {
            this.runResolution();
        }
        if (this.collectedDiagnostics != null) {
            Map<FirFile, List<FirDiagnostic<?>>> map = this.collectedDiagnostics;
            Intrinsics.checkNotNull(map);
            return map;
        }
        SimpleDiagnosticsCollector collector2 = FirDiagnosticsCollector.INSTANCE.create(this.session);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        Map map = MapsKt.createMapBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        Map map2 = map;
        FirAnalyzerFacade firAnalyzerFacade = this;
        boolean bl5 = false;
        List<? extends FirFile> list2 = this.firFiles;
        Intrinsics.checkNotNull(list2);
        for (FirFile firFile : list2) {
            void $this$runCheckers_u24lambda_u2d1;
            $this$runCheckers_u24lambda_u2d1.put(firFile, collector2.collectDiagnostics(firFile));
        }
        Unit unit = Unit.INSTANCE;
        firAnalyzerFacade.collectedDiagnostics = MapsKt.build((Map)map);
        Map<FirFile, List<FirDiagnostic<?>>> map3 = this.collectedDiagnostics;
        Intrinsics.checkNotNull(map3);
        return map3;
    }

    @NotNull
    public final Fir2IrResult convertToIr(@NotNull GeneratorExtensions extensions) {
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        if (this.scopeSession == null) {
            this.runResolution();
        }
        IdSignatureDescriptor signaturer = new IdSignatureDescriptor(new JvmManglerDesc(null, 1, null));
        Object object = this.scopeSession;
        Intrinsics.checkNotNull((Object)object);
        ScopeSession scopeSession = object;
        object = this.firFiles;
        Intrinsics.checkNotNull((Object)object);
        return Fir2IrConverter.Companion.createModuleFragment(this.session, scopeSession, (List<? extends FirFile>)object, this.languageVersionSettings, signaturer, extensions, new FirJvmKotlinMangler(this.session), IrFactoryImpl.INSTANCE, FirJvmVisibilityConverter.INSTANCE, new Fir2IrJvmSpecialAnnotationSymbolProvider());
    }
}

