/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.RangeLiteral;
import org.jetbrains.kotlin.js.translate.expression.RangeType;
import org.jetbrains.kotlin.js.translate.expression.WithIndexInfo;
import org.jetbrains.kotlin.js.translate.expression.WithIndexReceiverType;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"downToFunctionName", "Lorg/jetbrains/kotlin/name/FqName;", "indicesFqName", "intProgressionName", "intRangeName", "rangeToFunctionName", "sequenceFqName", "sequenceWithIndexFqName", "stepFunctionName", "untilFunctionName", "withIndexFqName", "createWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "doWhile", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhileExpressionBase;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translateForExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "js.translator"})
@JvmName(name="LoopTranslator")
public final class LoopTranslator {
    @NotNull
    private static final FqName rangeToFunctionName = new FqName("kotlin.Int.rangeTo");
    @NotNull
    private static final FqName untilFunctionName = new FqName("kotlin.ranges.until");
    @NotNull
    private static final FqName downToFunctionName = new FqName("kotlin.ranges.downTo");
    @NotNull
    private static final FqName stepFunctionName = new FqName("kotlin.ranges.step");
    @NotNull
    private static final FqName intRangeName = new FqName("kotlin.ranges.IntRange");
    @NotNull
    private static final FqName intProgressionName = new FqName("kotlin.ranges.IntProgression");
    @NotNull
    private static final FqName withIndexFqName = new FqName("kotlin.collections.withIndex");
    @NotNull
    private static final FqName sequenceWithIndexFqName = new FqName("kotlin.sequences.withIndex");
    @NotNull
    private static final FqName indicesFqName = new FqName("kotlin.collections.indices");
    @NotNull
    private static final FqName sequenceFqName = new FqName("kotlin.sequences.Sequence");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsNode createWhile(boolean doWhile, @NotNull KtWhileExpressionBase expression2, @NotNull TranslationContext context2) {
        JsNode jsNode;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtExpression ktExpression2 = expression2.getCondition();
        if (ktExpression2 == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"condition expression should not be null: ", (Object)expression2.getText()));
        }
        KtExpression conditionExpression = ktExpression = ktExpression2;
        JsBlock conditionBlock = new JsBlock();
        JsExpression jsExpression = Translation.translateAsExpression(conditionExpression, context2, conditionBlock);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"translateAsExpression(conditionExpression, context, conditionBlock)");
        JsExpression jsCondition = jsExpression;
        KtExpression body2 = expression2.getBody();
        JsStatement jsStatement = body2 != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(body2, context2) : (JsStatement)JsEmpty.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"if (body != null)\n            Translation.translateAsStatementAndMergeInBlockIfNeeded(body, context)\n        else\n            JsEmpty");
        JsStatement bodyStatement = jsStatement;
        if (!conditionBlock.isEmpty()) {
            void $this$createWhile_u24lambda_u2d0;
            jsNode = new JsBreak();
            boolean bl = false;
            boolean bl2 = false;
            SourceInfoAwareJsNode sourceInfoAwareJsNode = jsNode;
            JsExpression jsExpression2 = JsAstUtils.not(jsCondition);
            boolean bl3 = false;
            $this$createWhile_u24lambda_u2d0.setSource(expression2);
            Unit unit = Unit.INSTANCE;
            JsStatement jsStatement2 = (JsStatement)jsNode;
            JsExpression jsExpression3 = jsExpression2;
            jsNode = new JsIf(jsExpression3, jsStatement2);
            bl = false;
            bl2 = false;
            JsNode $this$createWhile_u24lambda_u2d1 = jsNode;
            boolean bl4 = false;
            ((SourceInfoAwareJsNode)$this$createWhile_u24lambda_u2d1).setSource(expression2);
            JsNode breakIfConditionIsFalseStatement = jsNode;
            Object object = JsAstUtils.convertToBlock(bodyStatement);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"convertToBlock(bodyStatement)");
            JsBlock bodyBlock = object;
            jsCondition = new JsBooleanLiteral(true);
            if (doWhile) {
                void $this$createWhile_u24lambda_u2d2;
                JsExpression jsExpression4 = context2.defineTemporary(new JsBooleanLiteral(false).source(expression2));
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression4, (String)"context.defineTemporary(JsBooleanLiteral(false).source(expression))");
                JsExpression secondRun = jsExpression4;
                conditionBlock.getStatements().add((JsStatement)breakIfConditionIsFalseStatement);
                JsIf ifStatement = new JsIf(secondRun, conditionBlock, JsAstUtils.assignment(secondRun, new JsBooleanLiteral(true)).source(expression2).makeStmt());
                sourceInfoAwareJsNode = ifStatement;
                boolean bl5 = false;
                boolean bl6 = false;
                SourceInfoAwareJsNode sourceInfoAwareJsNode2 = sourceInfoAwareJsNode;
                int n = 0;
                List<JsStatement> list2 = bodyBlock.getStatements();
                boolean bl7 = false;
                $this$createWhile_u24lambda_u2d2.setSource(expression2);
                jsExpression2 = Unit.INSTANCE;
                list2.add(n, (JsStatement)((Object)sourceInfoAwareJsNode));
            } else {
                conditionBlock.getStatements().add((JsStatement)breakIfConditionIsFalseStatement);
                List<JsStatement> list3 = bodyBlock.getStatements();
                object = conditionBlock.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"conditionBlock.statements");
                list3.addAll(0, (Collection)object);
            }
            bodyStatement = bodyBlock;
        }
        JsWhile result2 = doWhile ? (JsWhile)new JsDoWhile() : new JsWhile();
        result2.setCondition(jsCondition);
        result2.setBody(bodyStatement);
        jsNode = result2.source(expression2);
        Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"result.source(expression)");
        return jsNode;
    }

    @NotNull
    public static final JsStatement translateForExpression(@NotNull KtForExpression expression2, @NotNull TranslationContext context2) {
        JsStatement jsStatement;
        Object object;
        block5: {
            Object parameterName;
            KtDestructuringDeclaration destructuringParameter;
            KtParameter loopParameter;
            Object rangeType;
            KtExpression loopRange;
            block6: {
                WithIndexInfo withIndexCall;
                block4: {
                    KtParameter ktParameter;
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Object object2 = PsiUtils.getLoopRange(expression2);
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)it);
                    Intrinsics.checkNotNull((Object)ktExpression);
                    object = ktExpression;
                    KtExpression deparenthesized = object;
                    KtExpression ktExpression2 = deparenthesized instanceof KtStringTemplateExpression ? it : deparenthesized;
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"getLoopRange(expression).let {\n        val deparenthesized = KtPsiUtil.deparenthesize(it)!!\n        if (deparenthesized is KtStringTemplateExpression) it else deparenthesized\n    }");
                    loopRange = ktExpression2;
                    object2 = BindingUtils.getTypeForExpression(context2.bindingContext(), loopRange);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getTypeForExpression(context.bindingContext(), loopRange)");
                    rangeType = object2;
                    KtParameter ktParameter2 = expression2.getLoopParameter();
                    Intrinsics.checkNotNull((Object)ktParameter2);
                    loopParameter = ktParameter = ktParameter2;
                    destructuringParameter = loopParameter.getDestructuringDeclaration();
                    it = destructuringParameter == null ? context2.getNameForElement(loopParameter) : JsScope.declareTemporary();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"if (destructuringParameter == null) {\n        context.getNameForElement(loopParameter)\n    }\n    else {\n        JsScope.declareTemporary()\n    }");
                    parameterName = it;
                    RangeLiteral rangeLiteral = LoopTranslator.translateForExpression$extractForOverRangeLiteral((KotlinType)rangeType, loopRange, context2);
                    withIndexCall = LoopTranslator.translateForExpression$extractWithIndexCall(loopRange, context2, destructuringParameter, loopParameter);
                    if (rangeLiteral == null) break block4;
                    jsStatement = LoopTranslator.translateForExpression$translateForOverLiteralRange(context2, (JsName)parameterName, expression2, destructuringParameter, loopParameter, rangeLiteral);
                    break block5;
                }
                if (withIndexCall == null) break block6;
                object = withIndexCall.getReceiverType();
                int n = WhenMappings.$EnumSwitchMapping$1[((Enum)object).ordinal()];
                switch (n) {
                    case 1: {
                        jsStatement = LoopTranslator.translateForExpression$translateForOverArrayWithIndex(context2, expression2, withIndexCall);
                        break block5;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        jsStatement = withIndexCall.getValue() == null && withIndexCall.getReceiverType() == WithIndexReceiverType.COLLECTION ? LoopTranslator.translateForExpression$translateForOverCollectionIndices(context2, expression2, withIndexCall) : LoopTranslator.translateForExpression$translateForOverCollectionWithIndex(context2, expression2, withIndexCall);
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            jsStatement = LoopTranslator.translateForExpression$isForOverRange((KotlinType)rangeType) ? LoopTranslator.translateForExpression$translateForOverRange(context2, loopRange, (JsName)parameterName, expression2, destructuringParameter, loopParameter) : (LoopTranslator.translateForExpression$isForOverArray((KotlinType)rangeType) ? LoopTranslator.translateForExpression$translateForOverArray(context2, loopRange, expression2, destructuringParameter, loopParameter, (JsName)parameterName) : LoopTranslator.translateForExpression$translateForOverIterator(context2, loopRange, expression2, destructuringParameter, loopParameter, (JsName)parameterName));
        }
        JsStatement result2 = jsStatement;
        object = result2;
        boolean bl = false;
        boolean bl4 = false;
        Object $this$translateForExpression_u24lambda_u2d33 = object;
        boolean bl5 = false;
        $this$translateForExpression_u24lambda_u2d33.setSource(expression2);
        return object;
    }

    private static final boolean translateForExpression$isForOverRange(KotlinType $rangeType) {
        FqName fqName2;
        ClassifierDescriptor classifierDescriptor = $rangeType.getConstructor().getDeclarationDescriptor();
        FqName fqName3 = fqName2 = classifierDescriptor == null ? null : DescriptorUtilsKt.getFqNameSafe(classifierDescriptor);
        if (fqName2 == null) {
            return false;
        }
        FqName fqn = fqName2;
        return Intrinsics.areEqual((Object)fqn, (Object)intRangeName);
    }

    private static final RangeLiteral translateForExpression$extractForOverRangeLiteral(KotlinType $rangeType, KtExpression $loopRange, TranslationContext $context) {
        RangeType rangeType;
        ResolvedValueArgument resolvedValueArgument;
        List<ResolvedValueArgument> list2;
        Object object;
        Object object2;
        Object object3;
        FqName fqn;
        ClassifierDescriptor classifierDescriptor = $rangeType.getConstructor().getDeclarationDescriptor();
        FqName fqName2 = fqn = classifierDescriptor == null ? null : DescriptorUtilsKt.getFqNameSafe(classifierDescriptor);
        if (!Intrinsics.areEqual((Object)fqn, (Object)intRangeName) && !Intrinsics.areEqual((Object)fqn, (Object)intProgressionName)) {
            return null;
        }
        KtElement ktElement = $loopRange;
        Object object4 = $context.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.bindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, (BindingContext)object4);
        if (resolvedCall2 == null) {
            return null;
        }
        Object resolvedCall3 = resolvedCall2;
        Object step = null;
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor()), (Object)stepFunctionName)) {
            Object object5;
            object4 = resolvedCall3.getCall().getValueArguments().get(0).getArgumentExpression();
            if (object4 == null) {
                return null;
            }
            step = object4;
            object3 = resolvedCall3.getExtensionReceiver();
            Object object6 = object2 = object3 instanceof ExpressionReceiver ? (ExpressionReceiver)object3 : null;
            if (object2 == null) {
                object5 = null;
            } else {
                object3 = object2.getExpression();
                if (object3 == null) {
                    object5 = null;
                } else {
                    KtElement ktElement2 = (KtElement)object3;
                    object = $context.bindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.bindingContext()");
                    object5 = object4 = CallUtilKt.getResolvedCall(ktElement2, (BindingContext)object);
                }
            }
            if (object4 == null) {
                return null;
            }
            resolvedCall3 = object4;
        }
        object = (list2 = resolvedCall3.getExtensionReceiver()) == null ? resolvedCall3.getDispatchReceiver() : list2;
        object3 = object instanceof ExpressionReceiver ? (ExpressionReceiver)object : null;
        Object object7 = object2 = object3 == null ? null : object3.getExpression();
        if (object2 == null) {
            return null;
        }
        Object first = object2;
        list2 = resolvedCall3.getValueArgumentsByIndex();
        Object object8 = list2 == null ? null : (object = (resolvedValueArgument = (ResolvedValueArgument)CollectionsKt.firstOrNull((List)list2)) == null ? null : resolvedValueArgument.getArguments());
        Object object9 = object == null ? null : (object3 = (list2 = (ValueArgument)CollectionsKt.firstOrNull((List)object)) == null ? null : list2.getArgumentExpression());
        if (object3 == null) {
            return null;
        }
        Object second = object3;
        object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)resolvedCall3.getResultingDescriptor());
        if (Intrinsics.areEqual((Object)object, (Object)rangeToFunctionName)) {
            rangeType = RangeType.RANGE_TO;
        } else if (Intrinsics.areEqual((Object)object, (Object)untilFunctionName)) {
            rangeType = RangeType.UNTIL;
        } else if (Intrinsics.areEqual((Object)object, (Object)downToFunctionName)) {
            rangeType = RangeType.DOWN_TO;
        } else {
            return null;
        }
        RangeType type2 = rangeType;
        return new RangeLiteral(type2, (KtExpression)first, (KtExpression)second, (KtExpression)step);
    }

    private static final boolean translateForExpression$isForOverArray(KotlinType $rangeType) {
        return KotlinBuiltIns.isArray($rangeType) || KotlinBuiltIns.isPrimitiveArray($rangeType);
    }

    private static final VariableDescriptor translateForExpression$extractDescriptor(KtDeclaration $this$translateForExpression_u24extractDescriptor, TranslationContext $context) {
        VariableDescriptor variableDescriptor;
        VariableDescriptor variableDescriptor2 = (VariableDescriptor)$context.bindingContext().get(BindingContext.VARIABLE, $this$translateForExpression_u24extractDescriptor);
        if (variableDescriptor2 == null) {
            variableDescriptor = null;
        } else {
            VariableDescriptor variableDescriptor3 = variableDescriptor2;
            boolean bl = false;
            boolean bl2 = false;
            VariableDescriptor it = variableDescriptor3;
            boolean bl3 = false;
            variableDescriptor = !it.getName().isSpecial() ? variableDescriptor3 : null;
        }
        return variableDescriptor;
    }

    private static final WithIndexInfo translateForExpression$extractWithIndexCall(KtExpression $loopRange, TranslationContext $context, KtDestructuringDeclaration $destructuringParameter, KtParameter $loopParameter) {
        JsExpression jsExpression;
        WithIndexReceiverType withIndexReceiverType;
        ClassDescriptor classDescriptor2;
        Object object3;
        Pair pair;
        Object object2;
        List<KtDestructuringDeclarationEntry> it;
        KtElement ktElement = $loopRange;
        BindingContext bindingContext = $context.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.bindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor());
        FqName fqName3 = fqName2;
        if (Intrinsics.areEqual((Object)fqName3, (Object)withIndexFqName) ? true : Intrinsics.areEqual((Object)fqName3, (Object)sequenceWithIndexFqName)) {
            if ($destructuringParameter == null) {
                return null;
            }
            List<KtDestructuringDeclarationEntry> list2 = $destructuringParameter.getEntries();
            boolean bl = false;
            boolean bl2 = false;
            it = list2;
            boolean object3 = false;
            object2 = it.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it[0]");
            VariableDescriptor variableDescriptor = LoopTranslator.translateForExpression$extractDescriptor((KtDeclaration)object2, $context);
            object2 = it.get(1);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it[1]");
            Pair pair2 = new Pair((Object)variableDescriptor, (Object)LoopTranslator.translateForExpression$extractDescriptor((KtDeclaration)object2, $context));
            pair = pair2;
        } else if (Intrinsics.areEqual((Object)fqName3, (Object)indicesFqName)) {
            VariableDescriptor variableDescriptor;
            if ($destructuringParameter != null) {
                return null;
            }
            DeclarationDescriptor declarationDescriptor = $context.bindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, $loopParameter);
            VariableDescriptor variableDescriptor2 = variableDescriptor = declarationDescriptor instanceof VariableDescriptor ? (VariableDescriptor)declarationDescriptor : null;
            if (variableDescriptor == null) {
                return null;
            }
            VariableDescriptor varDescriptor = variableDescriptor;
            pair = new Pair((Object)varDescriptor, null);
        } else {
            return null;
        }
        bindingContext = pair;
        VariableDescriptor indexDescriptor = (VariableDescriptor)bindingContext.component1();
        VariableDescriptor elementDescriptor = (VariableDescriptor)bindingContext.component2();
        object2 = resolvedCall3.getResultingDescriptor().getExtensionReceiverParameter();
        Object object4 = object3 = object2 == null ? null : object2.getType();
        it = object3 == null ? null : ((object2 = ((KotlinType)object3).getConstructor()) == null ? null : object2.getDeclarationDescriptor());
        ClassDescriptor classDescriptor3 = classDescriptor2 = it instanceof ClassDescriptor ? (ClassDescriptor)((Object)it) : null;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor receiverClass = classDescriptor2;
        if (KotlinBuiltIns.isArrayOrPrimitiveArray(receiverClass)) {
            withIndexReceiverType = WithIndexReceiverType.ARRAY;
        } else if (KotlinBuiltIns.isCollectionOrNullableCollection(receiverClass.getDefaultType())) {
            withIndexReceiverType = WithIndexReceiverType.COLLECTION;
        } else if (KotlinBuiltIns.isIterableOrNullableIterable(receiverClass.getDefaultType())) {
            withIndexReceiverType = WithIndexReceiverType.ITERABLE;
        } else if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(receiverClass), (Object)sequenceFqName)) {
            withIndexReceiverType = WithIndexReceiverType.SEQUENCE;
        } else {
            return null;
        }
        WithIndexReceiverType receiverType = withIndexReceiverType;
        object2 = resolvedCall3.getExtensionReceiver();
        if (object2 == null) {
            return null;
        }
        object3 = object2;
        Object receiver = object3;
        Object object5 = receiver;
        if (object5 instanceof ExpressionReceiver) {
            jsExpression = Translation.translateAsExpression(((ExpressionReceiver)receiver).getExpression(), $context);
        } else if (object5 instanceof ImplicitReceiver) {
            jsExpression = $context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver((ReceiverValue)receiver));
        } else {
            return null;
        }
        object2 = jsExpression;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"when (receiver) {\n            is ExpressionReceiver -> Translation.translateAsExpression(receiver.expression, context)\n            is ImplicitReceiver -> context.getDispatchReceiver(getReceiverParameterForReceiver(receiver))\n            else -> return null\n        }");
        Object arrayExpr = object2;
        return new WithIndexInfo(receiverType, indexDescriptor, elementDescriptor, (JsExpression)arrayExpr);
    }

    private static final JsStatement translateForExpression$translateBody(KtForExpression $expression, KtDestructuringDeclaration $destructuringParameter, TranslationContext $context, KtParameter $loopParameter, JsName $parameterName, JsExpression itemValue) {
        List<JsStatement> list2;
        Object object;
        boolean bl;
        boolean bl2;
        Object loopParameterType;
        Object object2;
        JsStatement jsStatement;
        KtExpression ktExpression = $expression.getBody();
        if (ktExpression == null) {
            jsStatement = null;
        } else {
            KtExpression ktExpression2 = ktExpression;
            boolean bl3 = false;
            boolean bl4 = false;
            KtExpression it = ktExpression2;
            boolean bl5 = false;
            jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(it, $context);
        }
        JsStatement realBody = jsStatement;
        if (itemValue == null && $destructuringParameter == null) {
            return realBody;
        }
        JsBlock block = new JsBlock();
        if ($destructuringParameter == null) {
            JsExpression jsExpression;
            CallableDescriptor loopParameterDescriptor = (CallableDescriptor)BindingUtils.getDescriptorForElement($context.bindingContext(), $loopParameter);
            object2 = loopParameterDescriptor.getReturnType();
            KotlinType bl5 = object2 == null ? (KotlinType)$context.getCurrentModule().getBuiltIns().getAnyType() : object2;
            Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"loopParameterDescriptor.returnType ?: context.currentModule.builtIns.anyType");
            loopParameterType = bl5;
            object2 = itemValue;
            if (object2 == null) {
                jsExpression = null;
            } else {
                Object object3 = object2;
                bl2 = false;
                boolean bl6 = false;
                Object it = object3;
                boolean bl7 = false;
                jsExpression = TranslationUtils.coerce($context, (JsExpression)it, (KotlinType)loopParameterType);
            }
            JsExpression coercedItemValue = jsExpression;
            object2 = JsAstUtils.newVar($parameterName, coercedItemValue);
            bl = false;
            bl2 = false;
            Object $this$translateForExpression_u24translateBody_u24lambda_u2d8 = object2;
            boolean bl8 = false;
            ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateBody_u24lambda_u2d8).setSource($expression.getLoopRange());
            object = object2;
        } else {
            loopParameterType = $context.innerBlock(block);
            Intrinsics.checkNotNullExpressionValue((Object)loopParameterType, (String)"context.innerBlock(block)");
            TranslationContext innerBlockContext = loopParameterType;
            if (itemValue != null) {
                object2 = JsAstUtils.newVar($parameterName, itemValue);
                bl = false;
                bl2 = false;
                Object $this$translateForExpression_u24translateBody_u24lambda_u2d9 = object2;
                boolean bl9 = false;
                ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateBody_u24lambda_u2d9).setSource($expression.getLoopRange());
                Object object4 = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"newVar(parameterName, itemValue).apply { source = expression.loopRange }");
                Object parameterStatement = object4;
                innerBlockContext.addStatementToCurrentBlock((JsStatement)parameterStatement);
            }
            object = DestructuringDeclarationTranslator.translate($destructuringParameter, JsAstUtils.pureFqn($parameterName, null), innerBlockContext);
        }
        SourceInfoAwareJsNode sourceInfoAwareJsNode = object;
        Intrinsics.checkNotNullExpressionValue((Object)sourceInfoAwareJsNode, (String)"if (destructuringParameter == null) {\n                    val loopParameterDescriptor = (getDescriptorForElement(context.bindingContext(), loopParameter) as CallableDescriptor)\n                    val loopParameterType = loopParameterDescriptor.returnType ?: context.currentModule.builtIns.anyType\n                    val coercedItemValue = itemValue?.let { TranslationUtils.coerce(context, it, loopParameterType) }\n                    newVar(parameterName, coercedItemValue).apply { source = expression.loopRange }\n                }\n                else {\n                    val innerBlockContext = context.innerBlock(block)\n                    if (itemValue != null) {\n                        val parameterStatement = JsAstUtils.newVar(parameterName, itemValue).apply { source = expression.loopRange }\n                        innerBlockContext.addStatementToCurrentBlock(parameterStatement)\n                    }\n                    DestructuringDeclarationTranslator.translate(\n                            destructuringParameter, JsAstUtils.pureFqn(parameterName, null), innerBlockContext)\n                }");
        JsVars currentVarInit = sourceInfoAwareJsNode;
        sourceInfoAwareJsNode = block;
        Collection<JsStatement> collection = ((JsBlock)sourceInfoAwareJsNode).getStatements();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"block.statements");
        collection = collection;
        boolean bl10 = false;
        collection.add(currentVarInit);
        sourceInfoAwareJsNode = block;
        collection = ((JsBlock)sourceInfoAwareJsNode).getStatements();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"block.statements");
        if (realBody instanceof JsBlock) {
            List<JsStatement> list3 = ((JsBlock)realBody).getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"realBody.statements");
            list2 = list3;
        } else {
            list2 = CollectionsKt.listOfNotNull((Object)realBody);
        }
        Iterable iterable = list2;
        boolean bl11 = false;
        CollectionsKt.addAll(collection, (Iterable)iterable);
        return block;
    }

    private static final JsStatement translateForExpression$translateForOverLiteralRange(TranslationContext $context, JsName $parameterName, KtForExpression $expression, KtDestructuringDeclaration $destructuringParameter, KtParameter $loopParameter, RangeLiteral literal) {
        JsExpression jsExpression;
        Enum incrementOperator;
        int n;
        Object object;
        JsBinaryOperation jsBinaryOperation;
        int n2;
        JsExpression jsExpression2;
        boolean bl5;
        Object it;
        Object object2;
        JsExpression jsExpression3;
        JsBlock startBlock = new JsBlock();
        JsExpression jsExpression4 = Translation.translateAsExpression(literal.getFirst(), $context, startBlock);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression4, (String)"translateAsExpression(literal.first, context, startBlock)");
        JsExpression leftExpression = jsExpression4;
        JsBlock endBlock = new JsBlock();
        JsExpression jsExpression5 = Translation.translateAsExpression(literal.getSecond(), $context, endBlock);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression5, (String)"translateAsExpression(literal.second, context, endBlock)");
        JsExpression rightExpression = jsExpression5;
        JsBlock stepBlock = new JsBlock();
        KtExpression ktExpression = literal.getStep();
        if (ktExpression == null) {
            jsExpression3 = null;
        } else {
            object2 = ktExpression;
            boolean bl2 = false;
            boolean bl3 = false;
            it = object2;
            bl5 = false;
            jsExpression3 = Translation.translateAsExpression((KtExpression)it, $context, stepBlock);
        }
        JsExpression stepExpression = jsExpression3;
        $context.addStatementsToCurrentBlockFrom(startBlock);
        object2 = $context.cacheExpressionIfNeeded(leftExpression);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.cacheExpressionIfNeeded(leftExpression)");
        Object rangeStart = object2;
        $context.addStatementsToCurrentBlockFrom(endBlock);
        JsExpression jsExpression6 = $context.defineTemporary(rightExpression);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression6, (String)"context.defineTemporary(rightExpression)");
        JsExpression rangeEnd = jsExpression6;
        $context.addStatementsToCurrentBlockFrom(stepBlock);
        JsExpression jsExpression7 = stepExpression;
        if (jsExpression7 == null) {
            jsExpression2 = null;
        } else {
            it = jsExpression7;
            bl5 = false;
            n2 = 0;
            Object it2 = it;
            boolean bl4 = false;
            jsExpression2 = $context.defineTemporary((JsExpression)it2);
        }
        JsExpression step = jsExpression2;
        JsStatement body2 = LoopTranslator.translateForExpression$translateBody($expression, $destructuringParameter, $context, $loopParameter, $parameterName, null);
        RangeType bl5 = literal.getType();
        n2 = WhenMappings.$EnumSwitchMapping$0[bl5.ordinal()];
        switch (n2) {
            case 1: {
                jsBinaryOperation = JsAstUtils.lessThanEq($parameterName.makeRef(), rangeEnd);
                break;
            }
            case 2: {
                jsBinaryOperation = JsAstUtils.lessThan($parameterName.makeRef(), rangeEnd);
                break;
            }
            case 3: {
                jsBinaryOperation = JsAstUtils.greaterThanEq($parameterName.makeRef(), rangeEnd);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JsExpression conditionExpression = jsBinaryOperation.source($expression);
        if (step == null) {
            JsUnaryOperator jsUnaryOperator;
            object = literal.getType();
            n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    jsUnaryOperator = JsUnaryOperator.INC;
                    break;
                }
                case 3: {
                    jsUnaryOperator = JsUnaryOperator.DEC;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            incrementOperator = jsUnaryOperator;
            jsExpression = new JsPostfixOperation((JsUnaryOperator)incrementOperator, $parameterName.makeRef()).source($expression);
        } else {
            JsBinaryOperator jsBinaryOperator;
            object = literal.getType();
            n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    jsBinaryOperator = JsBinaryOperator.ASG_ADD;
                    break;
                }
                case 3: {
                    jsBinaryOperator = JsBinaryOperator.ASG_SUB;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            incrementOperator = jsBinaryOperator;
            jsExpression = new JsBinaryOperation((JsBinaryOperator)incrementOperator, $parameterName.makeRef(), step).source($expression);
        }
        JsExpression incrementExpression = jsExpression;
        JsVars jsVars = JsAstUtils.newVar($parameterName, (JsExpression)rangeStart);
        boolean bl6 = false;
        boolean bl7 = false;
        JsVars $this$translateForExpression_u24translateForOverLiteralRange_u24lambda_u2d12 = jsVars;
        boolean bl8 = false;
        $this$translateForExpression_u24translateForOverLiteralRange_u24lambda_u2d12.setSource($expression);
        object = jsVars;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newVar(parameterName, rangeStart).apply { source = expression }");
        Object initVars = object;
        return new JsFor((JsVars)initVars, conditionExpression, incrementExpression, body2);
    }

    private static final JsExpression translateForExpression$translateForOverRange$getProperty(JsExpression $rangeExpression, KtExpression $loopRange, String funName) {
        JsExpression jsExpression = new JsNameRef(funName, $rangeExpression).source($loopRange);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"JsNameRef(funName, rangeExpression).source(loopRange)");
        return jsExpression;
    }

    private static final JsStatement translateForExpression$translateForOverRange(TranslationContext $context, KtExpression $loopRange, JsName $parameterName, KtForExpression $expression, KtDestructuringDeclaration $destructuringParameter, KtParameter $loopParameter) {
        JsExpression jsExpression = $context.defineTemporary(Translation.translateAsExpression($loopRange, $context));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"context.defineTemporary(Translation.translateAsExpression(loopRange, context))");
        JsExpression rangeExpression = jsExpression;
        JsExpression jsExpression2 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverRange$getProperty(rangeExpression, $loopRange, "first"));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"context.defineTemporary(getProperty(\"first\"))");
        JsExpression start = jsExpression2;
        JsExpression jsExpression3 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverRange$getProperty(rangeExpression, $loopRange, "last"));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"context.defineTemporary(getProperty(\"last\"))");
        JsExpression end = jsExpression3;
        JsExpression jsExpression4 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverRange$getProperty(rangeExpression, $loopRange, "step"));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression4, (String)"context.defineTemporary(getProperty(\"step\"))");
        JsExpression increment = jsExpression4;
        JsStatement body2 = LoopTranslator.translateForExpression$translateBody($expression, $destructuringParameter, $context, $loopParameter, $parameterName, null);
        JsExpression conditionExpression = JsAstUtils.lessThanEq($parameterName.makeRef(), end).source($expression);
        JsExpression incrementExpression = JsAstUtils.addAssign($parameterName.makeRef(), increment).source($expression);
        JsVars jsVars = JsAstUtils.newVar($parameterName, start);
        boolean bl = false;
        boolean bl2 = false;
        JsVars $this$translateForExpression_u24translateForOverRange_u24lambda_u2d13 = jsVars;
        boolean bl3 = false;
        $this$translateForExpression_u24translateForOverRange_u24lambda_u2d13.setSource($expression);
        JsVars jsVars2 = jsVars;
        Intrinsics.checkNotNullExpressionValue((Object)jsVars2, (String)"newVar(parameterName, start).apply { source = expression }");
        JsVars initVars = jsVars2;
        return new JsFor(initVars, conditionExpression, incrementExpression, body2);
    }

    private static final JsStatement translateForExpression$translateForOverArray(TranslationContext $context, KtExpression $loopRange, KtForExpression $expression, KtDestructuringDeclaration $destructuringParameter, KtParameter $loopParameter, JsName $parameterName) {
        JsExpression jsExpression = $context.defineTemporary(Translation.translateAsExpression($loopRange, $context));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"context.defineTemporary(Translation.translateAsExpression(loopRange, context))");
        JsExpression rangeExpression = jsExpression;
        boolean bl = false;
        JsExpression jsExpression2 = ArrayFIF.LENGTH_PROPERTY_INTRINSIC.apply(rangeExpression, (List<? extends JsExpression>)CollectionsKt.emptyList(), $context);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"LENGTH_PROPERTY_INTRINSIC.apply(rangeExpression, listOf(), context)");
        JsExpression length = jsExpression2;
        JsExpression jsExpression3 = $context.defineTemporary(length);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"context.defineTemporary(length)");
        JsExpression end = jsExpression3;
        TemporaryVariable temporaryVariable = $context.declareTemporary(new JsIntLiteral(0), $expression);
        Intrinsics.checkNotNullExpressionValue((Object)temporaryVariable, (String)"context.declareTemporary(JsIntLiteral(0), expression)");
        TemporaryVariable index2 = temporaryVariable;
        JsExpression arrayAccess = new JsArrayAccess(rangeExpression, index2.reference()).source($expression);
        JsStatement body2 = LoopTranslator.translateForExpression$translateBody($expression, $destructuringParameter, $context, $loopParameter, $parameterName, arrayAccess);
        JsExpression initExpression = JsAstUtils.assignment(index2.reference(), new JsIntLiteral(0)).source($expression);
        JsExpression conditionExpression = JsAstUtils.inequality(index2.reference(), end).source($expression);
        JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, index2.reference()).source($expression);
        return new JsFor(initExpression, conditionExpression, incrementExpression, body2);
    }

    private static final JsStatement translateForExpression$translateForOverArrayWithIndex(TranslationContext $context, KtForExpression $expression, WithIndexInfo info) {
        KtExpression ktExpression;
        boolean bl;
        Object object;
        JsName jsName;
        boolean bl2;
        boolean bl3;
        Object object2;
        JsName jsName2;
        JsExpression jsExpression = $context.cacheExpressionIfNeeded(info.getRange());
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"context.cacheExpressionIfNeeded(info.range)");
        JsExpression range = jsExpression;
        Object object3 = info.getIndex();
        if (object3 == null) {
            jsName2 = null;
        } else {
            object2 = object3;
            bl3 = false;
            bl2 = false;
            VariableDescriptor it = object2;
            boolean bl4 = false;
            jsName2 = $context.getNameForDescriptor(it);
        }
        Object object4 = jsName2;
        JsName jsName3 = object4 == null ? JsScope.declareTemporary() : object4;
        Intrinsics.checkNotNullExpressionValue((Object)jsName3, (String)"info.index?.let { context.getNameForDescriptor(it) } ?: JsScope.declareTemporary()");
        JsName indexVar = jsName3;
        object4 = info.getValue();
        if (object4 == null) {
            jsName = null;
        } else {
            object3 = object4;
            boolean bl5 = false;
            bl3 = false;
            Object it = object3;
            boolean bl6 = false;
            jsName = $context.getNameForDescriptor((DeclarationDescriptor)it);
        }
        JsName valueVar = jsName;
        object2 = JsAstUtils.newVar(indexVar, new JsIntLiteral(0));
        bl3 = false;
        bl2 = false;
        Object $this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2d16 = object2;
        boolean bl7 = false;
        ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2d16).setSource($expression);
        object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"newVar(indexVar, JsIntLiteral(0)).apply { source = expression }");
        Object initExpression = object3;
        JsExpression conditionExpression = JsAstUtils.inequality(indexVar.makeRef(), new JsNameRef("length", range)).source($expression);
        JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, indexVar.makeRef()).source($expression);
        JsBlock body2 = new JsBlock();
        if (valueVar != null) {
            JsBlock jsBlock = body2;
            object = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(object, (String)"body.statements");
            object = (Collection)object;
            JsVars jsVars = JsAstUtils.newVar(valueVar, new JsArrayAccess(range, indexVar.makeRef()));
            bl = false;
            boolean bl8 = false;
            JsVars $this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2d17 = jsVars;
            boolean bl9 = false;
            $this$translateForExpression_u24translateForOverArrayWithIndex_u24lambda_u2d17.setSource($expression);
            bl = false;
            object.add(jsVars);
        }
        if ((ktExpression = $expression.getBody()) != null) {
            object = ktExpression;
            boolean bl10 = false;
            bl = false;
            Object it = object;
            boolean bl11 = false;
            JsBlock jsBlock = body2;
            Collection<JsStatement> collection = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"body.statements");
            collection = collection;
            JsStatement jsStatement = Translation.translateAsStatement((KtExpression)it, $context.innerBlock(body2));
            boolean bl12 = false;
            collection.add(jsStatement);
        }
        return new JsFor((JsVars)initExpression, conditionExpression, incrementExpression, (JsStatement)body2);
    }

    private static final ClassDescriptor translateForExpression$findCollection(TranslationContext $context) {
        Object object = $context.getCurrentModule();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.currentModule");
        ModuleDescriptor moduleDescriptor = object;
        object = ClassId.topLevel(StandardNames.FqNames.collection);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(StandardNames.FqNames.collection)");
        ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, (ClassId)object);
        Intrinsics.checkNotNull((Object)classDescriptor2);
        return classDescriptor2;
    }

    private static final JsStatement translateForExpression$translateForOverCollectionIndices(TranslationContext $context, KtForExpression $expression, WithIndexInfo info) {
        boolean bl;
        JsName jsName;
        JsExpression jsExpression = $context.cacheExpressionIfNeeded(info.getRange());
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"context.cacheExpressionIfNeeded(info.range)");
        JsExpression range = jsExpression;
        Object object = info.getIndex();
        if (object == null) {
            jsName = null;
        } else {
            VariableDescriptor variableDescriptor = object;
            bl = false;
            boolean bl2 = false;
            VariableDescriptor it = variableDescriptor;
            boolean bl3 = false;
            jsName = $context.getNameForDescriptor(it);
        }
        Object object2 = jsName;
        JsName jsName2 = object2 == null ? JsScope.declareTemporary() : object2;
        Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"info.index?.let { context.getNameForDescriptor(it) } ?: JsScope.declareTemporary()");
        JsName indexVar = jsName2;
        object = JsAstUtils.newVar(indexVar, new JsIntLiteral(0));
        boolean bl4 = false;
        bl = false;
        Object $this$translateForExpression_u24translateForOverCollectionIndices_u24lambda_u2d20 = object;
        boolean bl5 = false;
        ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverCollectionIndices_u24lambda_u2d20).setSource($expression);
        object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"newVar(indexVar, JsIntLiteral(0)).apply { source = expression }");
        Object initExpression = object2;
        object = DescriptorUtils.getPropertyByName(LoopTranslator.translateForExpression$findCollection($context).getUnsubstitutedMemberScope(), Name.identifier("size"));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getPropertyByName(findCollection().unsubstitutedMemberScope, Name.identifier(\"size\"))");
        Object sizeDescriptor = object;
        JsName jsName3 = $context.getNameForDescriptor((DeclarationDescriptor)sizeDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsName3, (String)"context.getNameForDescriptor(sizeDescriptor)");
        JsName sizeName = jsName3;
        JsExpression conditionExpression = JsAstUtils.inequality(indexVar.makeRef(), new JsNameRef(sizeName, range)).source($expression);
        JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, indexVar.makeRef()).source($expression);
        JsBlock body2 = new JsBlock();
        KtExpression ktExpression = $expression.getBody();
        if (ktExpression != null) {
            KtExpression ktExpression2 = ktExpression;
            boolean bl6 = false;
            boolean bl7 = false;
            KtExpression it = ktExpression2;
            boolean bl8 = false;
            JsBlock jsBlock = body2;
            Collection<JsStatement> collection = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"body.statements");
            collection = collection;
            JsStatement jsStatement = Translation.translateAsStatement(it, $context.innerBlock(body2));
            boolean bl9 = false;
            collection.add(jsStatement);
        }
        return new JsFor((JsVars)initExpression, conditionExpression, incrementExpression, (JsStatement)body2);
    }

    private static final ClassDescriptor translateForExpression$findIterable(TranslationContext $context) {
        Object object = $context.getCurrentModule();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.currentModule");
        ModuleDescriptor moduleDescriptor = object;
        object = ClassId.topLevel(StandardNames.FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(StandardNames.FqNames.iterable)");
        ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, (ClassId)object);
        Intrinsics.checkNotNull((Object)classDescriptor2);
        return classDescriptor2;
    }

    private static final ClassDescriptor translateForExpression$findSequence(TranslationContext $context) {
        Object object = $context.getCurrentModule();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.currentModule");
        ModuleDescriptor moduleDescriptor = object;
        object = ClassId.topLevel(sequenceFqName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(sequenceFqName)");
        ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, (ClassId)object);
        Intrinsics.checkNotNull((Object)classDescriptor2);
        return classDescriptor2;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsStatement translateForExpression$translateForOverCollectionWithIndex(TranslationContext $context, KtForExpression $expression, WithIndexInfo info) {
        JsStatement jsStatement;
        JsStatement jsStatement2;
        boolean bl;
        Object object;
        JsExpression jsExpression;
        boolean bl2;
        boolean bl3;
        Object object2;
        JsName jsName;
        CallableDescriptor it2;
        boolean bl4;
        VariableDescriptor variableDescriptor;
        JsName jsName2;
        JsExpression jsExpression2 = $context.cacheExpressionIfNeeded(info.getRange());
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"context.cacheExpressionIfNeeded(info.range)");
        JsExpression range = jsExpression2;
        VariableDescriptor variableDescriptor2 = info.getIndex();
        if (variableDescriptor2 == null) {
            jsName2 = null;
        } else {
            variableDescriptor = variableDescriptor2;
            boolean bl5 = false;
            bl4 = false;
            it2 = variableDescriptor;
            boolean bl6 = false;
            jsName2 = $context.getNameForDescriptor(it2);
        }
        JsName indexVar = jsName2;
        variableDescriptor = info.getValue();
        if (variableDescriptor == null) {
            jsName = null;
        } else {
            VariableDescriptor variableDescriptor3 = variableDescriptor;
            bl4 = false;
            boolean it2 = false;
            VariableDescriptor it3 = variableDescriptor3;
            boolean bl7 = false;
            jsName = $context.getNameForDescriptor(it3);
        }
        JsName valueVar = jsName;
        variableDescriptor = indexVar;
        if (variableDescriptor != null) {
            void $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d25_u24lambda_u2d24;
            VariableDescriptor variableDescriptor4 = variableDescriptor;
            bl4 = false;
            boolean it2 = false;
            VariableDescriptor it4 = variableDescriptor4;
            boolean bl8 = false;
            object2 = JsAstUtils.newVar((JsName)((Object)it4), new JsIntLiteral(0));
            bl3 = false;
            bl2 = false;
            JsVars jsVars = object2;
            TranslationContext translationContext = $context;
            boolean bl9 = false;
            $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d25_u24lambda_u2d24.setSource($expression);
            Unit unit = Unit.INSTANCE;
            translationContext.addStatementToCurrentBlock((JsStatement)object2);
        }
        JsName jsName3 = JsScope.declareTemporary();
        Intrinsics.checkNotNullExpressionValue((Object)jsName3, (String)"declareTemporary()");
        JsName iteratorVar = jsName3;
        ClassDescriptor rangeOwner = info.getReceiverType() == WithIndexReceiverType.SEQUENCE ? LoopTranslator.translateForExpression$findSequence($context) : LoopTranslator.translateForExpression$findIterable($context);
        it2 = DescriptorUtils.getFunctionByName(rangeOwner.getUnsubstitutedMemberScope(), Name.identifier("iterator"));
        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"getFunctionByName(rangeOwner.unsubstitutedMemberScope, Name.identifier(\"iterator\"))");
        CallableDescriptor iteratorDescriptor = it2;
        JsName it4 = $context.getNameForDescriptor(iteratorDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)it4, (String)"context.getNameForDescriptor(iteratorDescriptor)");
        JsName iteratorName = it4;
        object2 = JsAstUtils.newVar(iteratorVar, new JsInvocation((JsExpression)JsAstUtils.pureFqn(iteratorName, range), new JsExpression[0]));
        bl3 = false;
        bl2 = false;
        JsVars $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d26 = object2;
        boolean $i$a$-apply-LoopTranslator$translateForExpression$translateForOverCollectionWithIndex$initExpression$22 = false;
        $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d26.setSource($expression);
        JsVars bl8 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)bl8, (String)"newVar(iteratorVar, JsInvocation(pureFqn(iteratorName, range))).apply { source = expression }");
        JsVars initExpression = bl8;
        Annotated annotated = iteratorDescriptor.getReturnType();
        Intrinsics.checkNotNull((Object)annotated);
        object2 = annotated.getConstructor().getDeclarationDescriptor();
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor iteratorClassDescriptor = (ClassDescriptor)object2;
        annotated = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("hasNext"));
        Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"getFunctionByName(iteratorClassDescriptor.unsubstitutedMemberScope, Name.identifier(\"hasNext\"))");
        Annotated hasNextDescriptor = annotated;
        JsName jsName4 = $context.getNameForDescriptor((DeclarationDescriptor)hasNextDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsName4, (String)"context.getNameForDescriptor(hasNextDescriptor)");
        JsName hasNextName = jsName4;
        JsNode hasNextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(hasNextName, (JsExpression)iteratorVar.makeRef()), new JsExpression[0]).source($expression);
        FunctionDescriptor $i$a$-apply-LoopTranslator$translateForExpression$translateForOverCollectionWithIndex$initExpression$22 = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("next"));
        Intrinsics.checkNotNullExpressionValue((Object)$i$a$-apply-LoopTranslator$translateForExpression$translateForOverCollectionWithIndex$initExpression$22, (String)"getFunctionByName(iteratorClassDescriptor.unsubstitutedMemberScope, Name.identifier(\"next\"))");
        FunctionDescriptor nextDescriptor = $i$a$-apply-LoopTranslator$translateForExpression$translateForOverCollectionWithIndex$initExpression$22;
        JsName bl9 = $context.getNameForDescriptor(nextDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"context.getNameForDescriptor(nextDescriptor)");
        JsName nextName = bl9;
        JsNode nextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(nextName, (JsExpression)iteratorVar.makeRef()), new JsExpression[0]).source($expression);
        JsName jsName5 = indexVar;
        if (jsName5 == null) {
            jsExpression = null;
        } else {
            object = jsName5;
            boolean bl10 = false;
            boolean bl11 = false;
            JsName it5 = object;
            bl = false;
            jsExpression = new JsPrefixOperation(JsUnaryOperator.INC, it5.makeRef()).source($expression);
        }
        JsExpression incrementExpression = jsExpression;
        JsBlock body2 = new JsBlock();
        object = body2;
        Object object3 = ((JsBlock)object).getStatements();
        Intrinsics.checkNotNullExpressionValue(object3, (String)"body.statements");
        object3 = (Collection)object3;
        if (valueVar != null) {
            jsStatement2 = JsAstUtils.newVar(valueVar, (JsExpression)nextInvocation);
            boolean it5 = false;
            bl = false;
            JsStatement $this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d28 = jsStatement2;
            boolean bl12 = false;
            ((SourceInfoAwareJsNode)((Object)$this$translateForExpression_u24translateForOverCollectionWithIndex_u24lambda_u2d28)).setSource($expression);
            jsStatement = jsStatement2;
        } else {
            jsStatement = JsAstUtils.asSyntheticStatement((JsExpression)nextInvocation);
        }
        jsStatement2 = jsStatement;
        boolean it5 = false;
        object3.add((JsStatement)jsStatement2);
        object = $expression.getBody();
        if (object != null) {
            object3 = object;
            boolean bl13 = false;
            it5 = false;
            Object it6 = object3;
            boolean bl14 = false;
            JsBlock jsBlock = body2;
            Collection<JsStatement> collection = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"body.statements");
            collection = collection;
            JsStatement jsStatement3 = Translation.translateAsStatement((KtExpression)it6, $context.innerBlock(body2));
            boolean bl15 = false;
            collection.add(jsStatement3);
        }
        object = new JsFor(initExpression, (JsExpression)hasNextInvocation, incrementExpression);
        boolean bl16 = false;
        boolean bl17 = false;
        Object it2 = object;
        boolean bl18 = false;
        ((JsFor)it2).setBody(body2);
        return (JsStatement)object;
    }

    private static final JsExpression translateForExpression$translateForOverIterator$translateMethodInvocation(TranslationContext $context, JsExpression receiver, ResolvedCall<FunctionDescriptor> resolvedCall2, JsBlock block) {
        TranslationContext translationContext = $context.innerBlock(block);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context.innerBlock(block)");
        return CallTranslator.translate(translationContext, resolvedCall2, receiver);
    }

    private static final JsExpression translateForExpression$translateForOverIterator$iteratorMethodInvocation(KtExpression $loopRange, TranslationContext $context) {
        JsExpression jsExpression = Translation.translateAsExpression($loopRange, $context);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"translateAsExpression(loopRange, context)");
        JsExpression range = jsExpression;
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getIteratorFunction($context.bindingContext(), $loopRange);
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, (String)"getIteratorFunction(context.bindingContext(), loopRange)");
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
        return CallTranslator.translate($context, resolvedCall3, range);
    }

    private static final JsExpression translateForExpression$translateForOverIterator$hasNextMethodInvocation(TranslationContext $context, KtExpression $loopRange, JsExpression $iteratorVar, JsBlock block) {
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getHasNextCallable($context.bindingContext(), $loopRange);
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, (String)"getHasNextCallable(context.bindingContext(), loopRange)");
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
        return LoopTranslator.translateForExpression$translateForOverIterator$translateMethodInvocation($context, $iteratorVar, resolvedCall3, block);
    }

    /*
     * WARNING - void declaration
     */
    private static final JsStatement translateForExpression$translateForOverIterator(TranslationContext $context, KtExpression $loopRange, KtForExpression $expression, KtDestructuringDeclaration $destructuringParameter, KtParameter $loopParameter, JsName $parameterName) {
        List<JsStatement> list2;
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        JsExpression jsExpression;
        JsExpression jsExpression2 = $context.defineTemporary(LoopTranslator.translateForExpression$translateForOverIterator$iteratorMethodInvocation($loopRange, $context));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"context.defineTemporary(iteratorMethodInvocation())");
        JsExpression iteratorVar = jsExpression2;
        JsBlock hasNextBlock = new JsBlock();
        JsExpression hasNextInvocation = LoopTranslator.translateForExpression$translateForOverIterator$hasNextMethodInvocation($context, $loopRange, iteratorVar, hasNextBlock);
        JsBlock nextBlock = new JsBlock();
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getNextFunction($context.bindingContext(), $loopRange);
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, (String)"getNextFunction(context.bindingContext(), loopRange)");
        JsExpression nextInvoke = LoopTranslator.translateForExpression$translateForOverIterator$translateMethodInvocation($context, iteratorVar, resolvedCall2, nextBlock);
        boolean bl3 = false;
        List bodyStatements = new ArrayList();
        if (hasNextBlock.isEmpty()) {
            jsExpression = hasNextInvocation;
        } else {
            void $this$translateForExpression_u24translateForOverIterator_u24lambda_u2d31;
            object2 = bodyStatements;
            object = hasNextBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(object, (String)"hasNextBlock.statements");
            object = (Iterable)object;
            bl2 = false;
            CollectionsKt.addAll((Collection)object2, object);
            object2 = bodyStatements;
            object = new JsBreak();
            bl2 = false;
            bl = false;
            Object object3 = object;
            JsExpression jsExpression3 = JsAstUtils.notOptimized(hasNextInvocation);
            boolean bl4 = false;
            $this$translateForExpression_u24translateForOverIterator_u24lambda_u2d31.setSource($expression);
            Unit unit = Unit.INSTANCE;
            JsStatement jsStatement = (JsStatement)object;
            JsExpression jsExpression4 = jsExpression3;
            object = new JsIf(jsExpression4, jsStatement);
            bl2 = false;
            bl = false;
            Object $this$translateForExpression_u24translateForOverIterator_u24lambda_u2d32 = object;
            boolean bl5 = false;
            ((SourceInfoAwareJsNode)$this$translateForExpression_u24translateForOverIterator_u24lambda_u2d32).setSource($expression);
            bl2 = false;
            object2.add(object);
            jsExpression = new JsBooleanLiteral(true);
        }
        JsExpression exitCondition = jsExpression;
        object2 = bodyStatements;
        object = nextBlock.getStatements();
        Intrinsics.checkNotNullExpressionValue(object, (String)"nextBlock.statements");
        object = (Iterable)object;
        bl2 = false;
        CollectionsKt.addAll((Collection)object2, object);
        object2 = bodyStatements;
        object = LoopTranslator.translateForExpression$translateBody($expression, $destructuringParameter, $context, $loopParameter, $parameterName, nextInvoke);
        if (object == null) {
            list2 = null;
        } else {
            Object object4 = object;
            bl = false;
            boolean bl6 = false;
            Object p0 = object4;
            boolean bl7 = false;
            list2 = JsAstUtils.flattenStatement((JsStatement)p0);
        }
        object = list2;
        boolean bl8 = false;
        Object object5 = object;
        if (object5 == null) {
            object5 = CollectionsKt.emptyList();
        }
        object = (Iterable)object5;
        bl8 = false;
        CollectionsKt.addAll((Collection)object2, (Iterable)object);
        object2 = (JsStatement)CollectionsKt.singleOrNull((List)bodyStatements);
        return new JsWhile(exitCondition, (JsStatement)(object2 == null ? (JsStatement)new JsBlock(bodyStatements) : object2));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RangeType.values().length];
            nArray[RangeType.RANGE_TO.ordinal()] = 1;
            nArray[RangeType.UNTIL.ordinal()] = 2;
            nArray[RangeType.DOWN_TO.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WithIndexReceiverType.values().length];
            nArray[WithIndexReceiverType.ARRAY.ordinal()] = 1;
            nArray[WithIndexReceiverType.ITERABLE.ordinal()] = 2;
            nArray[WithIndexReceiverType.SEQUENCE.ordinal()] = 3;
            nArray[WithIndexReceiverType.COLLECTION.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

