/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;

public class Providers {
    private static final NoValueProvider<Object> NULL_PROVIDER = new NoValueProvider<Object>(ValueSupplier.Value.MISSING);
    public static final Provider<Boolean> TRUE = Providers.of(true);
    public static final Provider<Boolean> FALSE = Providers.of(false);

    public static <T> ProviderInternal<T> fixedValue(DisplayName owner, T value, Class<T> targetType, ValueSanitizer<T> sanitizer) {
        if (!targetType.isInstance(value = sanitizer.sanitize(value))) {
            throw new IllegalArgumentException(String.format("Cannot set the value of %s of type %s using an instance of type %s.", owner.getDisplayName(), targetType.getName(), value.getClass().getName()));
        }
        return new FixedValueProvider<T>(value);
    }

    public static <T> ProviderInternal<T> nullableValue(ValueSupplier.Value<? extends T> value) {
        if (value.isMissing()) {
            if (value.getPathToOrigin().isEmpty()) {
                return Providers.notDefined();
            }
            return new NoValueProvider<T>(value);
        }
        return Providers.of(value.get());
    }

    public static <T> ProviderInternal<T> notDefined() {
        return (ProviderInternal)Cast.uncheckedCast(NULL_PROVIDER);
    }

    public static <T> ProviderInternal<T> of(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        return new FixedValueProvider<T>(value);
    }

    public static <T> ProviderInternal<T> internal(Provider<T> value) {
        return (ProviderInternal)Cast.uncheckedCast(value);
    }

    public static <T> ProviderInternal<T> ofNullable(@Nullable T value) {
        if (value == null) {
            return Providers.notDefined();
        }
        return Providers.of(value);
    }

    private static class NoValueProvider<T>
    extends AbstractMinimalProvider<T> {
        private final ValueSupplier.Value<? extends T> value;

        public NoValueProvider(ValueSupplier.Value<? extends T> value) {
            assert (value.isMissing());
            this.value = value;
        }

        @Override
        public ValueSupplier.Value<? extends T> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return this.value;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return null;
        }

        @Override
        protected ValueSupplier.Value<T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.missing();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.missing();
        }

        @Override
        public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
            return (ProviderInternal)Cast.uncheckedCast((Object)this);
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public ProviderInternal<T> asSupplier(DisplayName owner, Class<? super T> targetType, ValueSanitizer<? super T> sanitizer) {
            return this;
        }

        @Override
        public ProviderInternal<T> withFinalValue(ValueSupplier.ValueConsumer consumer) {
            return this;
        }

        @Override
        public Provider<T> orElse(T value) {
            return Providers.of(value);
        }

        @Override
        public Provider<T> orElse(Provider<? extends T> provider) {
            return (Provider)Cast.uncheckedCast(provider);
        }

        @Override
        public String toString() {
            return "undefined";
        }
    }

    public static class FixedValueWithChangingContentProvider<T>
    extends FixedValueProvider<T> {
        public FixedValueWithChangingContentProvider(T value) {
            super(value);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
            return super.calculateExecutionTimeValue().withChangingContent();
        }
    }

    public static class FixedValueProvider<T>
    extends AbstractProviderWithValue<T> {
        private final T value;

        FixedValueProvider(T value) {
            this.value = value;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return (Class)Cast.uncheckedCast(this.value.getClass());
        }

        @Override
        protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.value);
        }

        @Override
        public ProviderInternal<T> withFinalValue(ValueSupplier.ValueConsumer consumer) {
            return this;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.value);
        }

        @Override
        public String toString() {
            return String.format("fixed(%s, %s)", this.getType(), this.value);
        }
    }
}

