/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.ImmutableSortedSet;
import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.FilePropertyContainer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.DefaultTaskOutputFilePropertyRegistration;
import org.gradle.api.internal.tasks.StaticValue;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskOutputFilePropertyRegistration;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.gradle.api.internal.tasks.properties.GetOutputFilesVisitor;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;

@NonNullApi
public class DefaultTaskOutputs
implements TaskOutputsInternal {
    private final FileCollection allOutputFiles;
    private final PropertyWalker propertyWalker;
    private final FileCollectionFactory fileCollectionFactory;
    private AndSpec<TaskInternal> upToDateSpec = AndSpec.empty();
    private final List<SelfDescribingSpec<TaskInternal>> cacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private final List<SelfDescribingSpec<TaskInternal>> doNotCacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private FileCollection previousOutputFiles;
    private final FilePropertyContainer<TaskOutputFilePropertyRegistration> registeredFileProperties = FilePropertyContainer.create();
    private final TaskInternal task;
    private final TaskMutator taskMutator;

    public DefaultTaskOutputs(TaskInternal task, TaskMutator taskMutator, PropertyWalker propertyWalker, FileCollectionFactory fileCollectionFactory) {
        this.task = task;
        this.taskMutator = taskMutator;
        this.allOutputFiles = new TaskOutputUnionFileCollection(task);
        this.propertyWalker = propertyWalker;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public void visitRegisteredProperties(PropertyVisitor visitor) {
        for (TaskOutputFilePropertyRegistration registration : this.registeredFileProperties) {
            visitor.visitOutputFileProperty(registration.getPropertyName(), registration.isOptional(), registration.getValue(), registration.getPropertyType());
        }
    }

    @Override
    public AndSpec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    public void upToDateWhen(Closure upToDateClosure) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Closure)", () -> {
            this.upToDateSpec = this.upToDateSpec.and(upToDateClosure);
        });
    }

    public void upToDateWhen(Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Spec)", () -> {
            this.upToDateSpec = this.upToDateSpec.and(spec);
        });
    }

    public void cacheIf(Spec<? super Task> spec) {
        this.cacheIf("Task outputs cacheable", spec);
    }

    public void cacheIf(String cachingEnabledReason, Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.cacheIf(Spec)", () -> this.cacheIfSpecs.add(new SelfDescribingSpec(spec, cachingEnabledReason)));
    }

    public void doNotCacheIf(String cachingDisabledReason, Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.doNotCacheIf(Spec)", () -> this.doNotCacheIfSpecs.add(new SelfDescribingSpec(spec, cachingDisabledReason)));
    }

    @Override
    public List<SelfDescribingSpec<TaskInternal>> getCacheIfSpecs() {
        return this.cacheIfSpecs;
    }

    @Override
    public List<SelfDescribingSpec<TaskInternal>> getDoNotCacheIfSpecs() {
        return this.doNotCacheIfSpecs;
    }

    public boolean getHasOutput() {
        if (!this.upToDateSpec.isEmpty()) {
            return true;
        }
        HasDeclaredOutputsVisitor visitor = new HasDeclaredOutputsVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.hasDeclaredOutputs();
    }

    public FileCollection getFiles() {
        return this.allOutputFiles;
    }

    public ImmutableSortedSet<OutputFilePropertySpec> getFileProperties() {
        GetOutputFilesVisitor visitor = new GetOutputFilesVisitor(this.task.toString(), this.fileCollectionFactory, false);
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.getFileProperties();
    }

    public TaskOutputFilePropertyBuilder file(Object path) {
        return this.taskMutator.mutate("TaskOutputs.file(Object)", () -> {
            StaticValue value = new StaticValue(path);
            value.attachProducer(this.task);
            DefaultTaskOutputFilePropertyRegistration registration = new DefaultTaskOutputFilePropertyRegistration(value, OutputFilePropertyType.FILE);
            this.registeredFileProperties.add(registration);
            return registration;
        });
    }

    public TaskOutputFilePropertyBuilder dir(Object path) {
        return this.taskMutator.mutate("TaskOutputs.dir(Object)", () -> {
            StaticValue value = new StaticValue(path);
            value.attachProducer(this.task);
            DefaultTaskOutputFilePropertyRegistration registration = new DefaultTaskOutputFilePropertyRegistration(value, OutputFilePropertyType.DIRECTORY);
            this.registeredFileProperties.add(registration);
            return registration;
        });
    }

    public TaskOutputFilePropertyBuilder files(Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.files(Object...)", () -> {
            StaticValue value = new StaticValue(DefaultTaskOutputs.resolveSingleArray(paths));
            DefaultTaskOutputFilePropertyRegistration registration = new DefaultTaskOutputFilePropertyRegistration(value, OutputFilePropertyType.FILES);
            this.registeredFileProperties.add(registration);
            return registration;
        });
    }

    public TaskOutputFilePropertyBuilder dirs(Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.dirs(Object...)", () -> {
            StaticValue value = new StaticValue(DefaultTaskOutputs.resolveSingleArray(paths));
            DefaultTaskOutputFilePropertyRegistration registration = new DefaultTaskOutputFilePropertyRegistration(value, OutputFilePropertyType.DIRECTORIES);
            this.registeredFileProperties.add(registration);
            return registration;
        });
    }

    @Nullable
    private static Object resolveSingleArray(@Nullable Object[] paths) {
        return paths != null && paths.length == 1 ? paths[0] : paths;
    }

    @Override
    public void setPreviousOutputFiles(FileCollection previousOutputFiles) {
        this.previousOutputFiles = previousOutputFiles;
    }

    @Override
    public Set<File> getPreviousOutputFiles() {
        if (this.previousOutputFiles == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.previousOutputFiles.getFiles();
    }

    private class TaskOutputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final TaskInternal buildDependencies;

        public TaskOutputUnionFileCollection(TaskInternal buildDependencies) {
            this.buildDependencies = buildDependencies;
        }

        public String getDisplayName() {
            return "task '" + DefaultTaskOutputs.this.task.getName() + "' output files";
        }

        protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
            for (OutputFilePropertySpec propertySpec : DefaultTaskOutputs.this.getFileProperties()) {
                visitor.accept(propertySpec.getPropertyFiles());
            }
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add((Object)this.buildDependencies);
            super.visitDependencies(context);
        }
    }

    private static class HasDeclaredOutputsVisitor
    extends PropertyVisitor.Adapter {
        boolean hasDeclaredOutputs;

        private HasDeclaredOutputsVisitor() {
        }

        @Override
        public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
            this.hasDeclaredOutputs = true;
        }

        public boolean hasDeclaredOutputs() {
            return this.hasDeclaredOutputs;
        }
    }
}

