/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;

public abstract class AbstractArchiveFileTree
implements FileSystemMirroringFileTree,
TaskDependencyContainer {
    protected abstract Provider<File> getBackingFileProvider();

    @Nullable
    private File getBackingFile() {
        return (File)this.getBackingFileProvider().getOrNull();
    }

    public void visitStructure(FileCollectionStructureVisitor visitor, FileTreeInternal owner) {
        File backingFile = this.getBackingFile();
        if (backingFile != null) {
            visitor.visitFileTreeBackedByFile(backingFile, owner, (FileSystemMirroringFileTree)this);
        } else {
            visitor.visitGenericFileTree(owner, (FileSystemMirroringFileTree)this);
        }
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add(this.getBackingFileProvider());
    }
}

