/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.util.ArrayDeque;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.internal.reflect.validation.TypeValidationContext;

@NonNullApi
public class DefaultPropertyWalker
implements PropertyWalker {
    private final RuntimeBeanNodeFactory nodeFactory;

    public DefaultPropertyWalker(TypeMetadataStore typeMetadataStore) {
        this.nodeFactory = new RuntimeBeanNodeFactory(typeMetadataStore);
    }

    @Override
    public void visitProperties(Object bean, TypeValidationContext validationContext, PropertyVisitor visitor) {
        ArrayDeque queue = new ArrayDeque();
        queue.add(this.nodeFactory.createRoot(bean));
        while (!queue.isEmpty()) {
            RuntimeBeanNode node = (RuntimeBeanNode)queue.remove();
            node.visitNode(visitor, queue, this.nodeFactory, validationContext);
        }
    }
}

