/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.collect.PersistentList;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.ChildMapFactory;
import org.gradle.internal.snapshot.EmptyChildMap;
import org.gradle.internal.snapshot.VfsRelativePath;

public final class ValuedVfsHierarchy<T> {
    private final PersistentList<T> values;
    private final ChildMap<ValuedVfsHierarchy<T>> children;
    private final CaseSensitivity caseSensitivity;

    public ValuedVfsHierarchy(PersistentList<T> values, ChildMap<ValuedVfsHierarchy<T>> children, CaseSensitivity caseSensitivity) {
        this.values = values;
        this.children = children;
        this.caseSensitivity = caseSensitivity;
    }

    @CheckReturnValue
    public ValuedVfsHierarchy<T> empty() {
        return new ValuedVfsHierarchy<T>(PersistentList.of(), EmptyChildMap.getInstance(), this.caseSensitivity);
    }

    public void visitValuesRelatedTo(final VfsRelativePath location, final ValueVisitor<T> visitor) {
        this.values.forEach(value -> visitor.visitAncestor(value, location));
        this.children.withNode(location, this.caseSensitivity, new ChildMap.NodeHandler<ValuedVfsHierarchy<T>, String>(){

            public String handleAsDescendantOfChild(VfsRelativePath pathInChild, ValuedVfsHierarchy<T> child) {
                child.visitValuesRelatedTo(pathInChild, visitor);
                return "";
            }

            public String handleAsAncestorOfChild(String childPathFromAncestor, ValuedVfsHierarchy<T> child) {
                visitor.visitChildren(child.getValues(), () -> childPathFromAncestor.substring(location.length() + 1));
                child.visitAllChildren((nodes, relativePath) -> visitor.visitChildren(nodes, () -> 1.lambda$handleAsAncestorOfChild$1(childPathFromAncestor, location, (Supplier)relativePath)));
                return "";
            }

            public String handleExactMatchWithChild(ValuedVfsHierarchy<T> child) {
                child.visitAllValues(visitor);
                return "";
            }

            public String handleUnrelatedToAnyChild() {
                return "";
            }

            private static /* synthetic */ String lambda$handleAsAncestorOfChild$1(String childPathFromAncestor, VfsRelativePath location2, Supplier relativePath) {
                return ValuedVfsHierarchy.joinRelativePaths(childPathFromAncestor.substring(location2.length() + 1), (String)relativePath.get());
            }
        });
    }

    public void visitAllValues(ValueVisitor<T> valueVisitor) {
        this.getValues().forEach(valueVisitor::visitExact);
        this.visitAllChildren(valueVisitor::visitChildren);
    }

    @CheckReturnValue
    public ValuedVfsHierarchy<T> recordValue(final VfsRelativePath location, final T value) {
        if (location.length() == 0) {
            return new ValuedVfsHierarchy<T>(this.values.plus(value), this.children, this.caseSensitivity);
        }
        ChildMap newChildren = this.children.store(location, this.caseSensitivity, new ChildMap.StoreHandler<ValuedVfsHierarchy<T>>(){

            public ValuedVfsHierarchy<T> handleAsDescendantOfChild(VfsRelativePath pathInChild, ValuedVfsHierarchy<T> child) {
                return child.recordValue(pathInChild, value);
            }

            public ValuedVfsHierarchy<T> handleAsAncestorOfChild(String childPath, ValuedVfsHierarchy<T> child) {
                ChildMap singletonChild = ChildMapFactory.childMapFromSorted((List)ImmutableList.of((Object)new ChildMap.Entry(VfsRelativePath.of((String)childPath).suffixStartingFrom(location.length() + 1).getAsString(), child)));
                return new ValuedVfsHierarchy(PersistentList.of((Object)value), singletonChild, ValuedVfsHierarchy.this.caseSensitivity);
            }

            public ValuedVfsHierarchy<T> mergeWithExisting(ValuedVfsHierarchy<T> child) {
                return new ValuedVfsHierarchy(child.getValues().plus(value), child.getChildren(), ValuedVfsHierarchy.this.caseSensitivity);
            }

            public ValuedVfsHierarchy<T> createChild() {
                return new ValuedVfsHierarchy(PersistentList.of((Object)value), EmptyChildMap.getInstance(), ValuedVfsHierarchy.this.caseSensitivity);
            }

            public ValuedVfsHierarchy<T> createNodeFromChildren(ChildMap<ValuedVfsHierarchy<T>> children) {
                return new ValuedVfsHierarchy(PersistentList.of(), children, ValuedVfsHierarchy.this.caseSensitivity);
            }
        });
        return new ValuedVfsHierarchy<T>(this.values, newChildren, this.caseSensitivity);
    }

    private PersistentList<T> getValues() {
        return this.values;
    }

    private void visitAllChildren(BiConsumer<PersistentList<T>, Supplier<String>> childConsumer) {
        this.children.stream().forEach(entry -> {
            ValuedVfsHierarchy child = (ValuedVfsHierarchy)entry.getValue();
            childConsumer.accept(child.getValues(), () -> ((ChildMap.Entry)entry).getPath());
            child.visitAllChildren((grandChildren, relativePath) -> childConsumer.accept((PersistentList)grandChildren, () -> ValuedVfsHierarchy.lambda$visitAllChildren$1(entry, (Supplier)relativePath)));
        });
    }

    private ChildMap<ValuedVfsHierarchy<T>> getChildren() {
        return this.children;
    }

    private static String joinRelativePaths(String first, String second) {
        return first + "/" + second;
    }

    private static /* synthetic */ String lambda$visitAllChildren$1(ChildMap.Entry entry, Supplier relativePath) {
        return ValuedVfsHierarchy.joinRelativePaths(entry.getPath(), (String)relativePath.get());
    }

    public static interface ValueVisitor<T> {
        public void visitExact(T var1);

        public void visitAncestor(T var1, VfsRelativePath var2);

        public void visitChildren(PersistentList<T> var1, Supplier<String> var2);
    }
}

