/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.Combiners;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;
import org.gradle.internal.watch.vfs.WatchMode;

public abstract class AbstractFileWatcherUpdater
implements FileWatcherUpdater {
    protected final FileWatcherProbeRegistry probeRegistry;
    protected final WatchableHierarchies watchableHierarchies;
    protected FileHierarchySet watchedFiles = FileHierarchySet.empty();
    private ImmutableSet<File> probedHierarchies = ImmutableSet.of();

    public AbstractFileWatcherUpdater(FileWatcherProbeRegistry probeRegistry, WatchableHierarchies watchableHierarchies) {
        this.probeRegistry = probeRegistry;
        this.watchableHierarchies = watchableHierarchies;
    }

    @Override
    public void registerWatchableHierarchy(File watchableHierarchy, SnapshotHierarchy root) {
        this.watchableHierarchies.registerWatchableHierarchy(watchableHierarchy, root);
        this.probeRegistry.registerProbe(watchableHierarchy);
        this.update(root);
    }

    @Override
    public final SnapshotHierarchy updateVfsOnBuildStarted(SnapshotHierarchy root, WatchMode watchMode) {
        this.watchableHierarchies.updateUnsupportedFileSystems(watchMode);
        SnapshotHierarchy newRoot = this.watchableHierarchies.removeUnwatchableContentOnBuildStart(root, this.createInvalidator(), watchMode);
        newRoot = this.doUpdateVfsOnBuildStarted(newRoot);
        if (root != newRoot) {
            this.update(newRoot);
        }
        return newRoot;
    }

    @CheckReturnValue
    protected abstract SnapshotHierarchy doUpdateVfsOnBuildStarted(SnapshotHierarchy var1);

    @Override
    public void virtualFileSystemContentsChanged(Collection<FileSystemLocationSnapshot> removedSnapshots, Collection<FileSystemLocationSnapshot> addedSnapshots, SnapshotHierarchy root) {
        boolean contentsChanged = this.handleVirtualFileSystemContentsChanged(removedSnapshots, addedSnapshots, root);
        if (contentsChanged) {
            this.update(root);
        }
    }

    protected abstract boolean handleVirtualFileSystemContentsChanged(Collection<FileSystemLocationSnapshot> var1, Collection<FileSystemLocationSnapshot> var2, SnapshotHierarchy var3);

    @Override
    public SnapshotHierarchy updateVfsOnBuildFinished(SnapshotHierarchy root, WatchMode watchMode, int maximumNumberOfWatchedHierarchies) {
        SnapshotHierarchy newRoot = this.watchableHierarchies.removeUnwatchableContentOnBuildFinished(root, watchMode, arg_0 -> ((FileHierarchySet)this.watchedFiles).contains(arg_0), maximumNumberOfWatchedHierarchies, this.createInvalidator());
        if (root != newRoot) {
            this.update(newRoot);
        }
        return newRoot;
    }

    @Override
    public FileHierarchySet getWatchedFiles() {
        return this.watchedFiles;
    }

    @Override
    public void triggerWatchProbe(String path) {
        this.probeRegistry.triggerWatchProbe(path);
    }

    protected abstract WatchableHierarchies.Invalidator createInvalidator();

    private void update(SnapshotHierarchy root) {
        this.watchedFiles = AbstractFileWatcherUpdater.resolveWatchedFiles(this.watchableHierarchies, root);
        this.updateWatchesOnChangedWatchedFiles(this.watchedFiles);
        ImmutableSet<File> oldProbedHierarchies = this.probedHierarchies;
        this.probedHierarchies = (ImmutableSet)this.watchableHierarchies.stream().filter(arg_0 -> ((FileHierarchySet)this.watchedFiles).contains(arg_0)).collect(ImmutableSet.toImmutableSet());
        if (oldProbedHierarchies.equals(this.probedHierarchies)) {
            return;
        }
        oldProbedHierarchies.stream().filter(oldProbedHierarchy -> !this.probedHierarchies.contains(oldProbedHierarchy)).forEach(probedHierarchy -> {
            File probeDirectory = this.probeRegistry.getProbeDirectory((File)probedHierarchy);
            this.probeRegistry.disarmWatchProbe((File)probedHierarchy);
            this.stopWatchingProbeDirectory(probeDirectory);
        });
        this.probedHierarchies.stream().filter(newProbedHierarchy -> !oldProbedHierarchies.contains(newProbedHierarchy)).forEach(probedHierarchy -> {
            File probeDirectory = this.probeRegistry.getProbeDirectory((File)probedHierarchy);
            probeDirectory.mkdirs();
            this.startWatchingProbeDirectory(probeDirectory);
            this.probeRegistry.armWatchProbe((File)probedHierarchy);
        });
    }

    protected abstract void updateWatchesOnChangedWatchedFiles(FileHierarchySet var1);

    protected abstract void startWatchingProbeDirectory(File var1);

    protected abstract void stopWatchingProbeDirectory(File var1);

    @VisibleForTesting
    static FileHierarchySet resolveWatchedFiles(WatchableHierarchies watchableHierarchies, SnapshotHierarchy vfsRoot) {
        return watchableHierarchies.stream().map(File::getPath).filter(watchableHierarchy -> AbstractFileWatcherUpdater.hasWatchableContent(vfsRoot.rootSnapshotsUnder(watchableHierarchy), watchableHierarchies)).reduce(FileHierarchySet.empty(), FileHierarchySet::plus, Combiners.nonCombining());
    }

    private static boolean hasWatchableContent(Stream<FileSystemLocationSnapshot> snapshots, WatchableHierarchies watchableHierarchies) {
        return snapshots.anyMatch(snapshot -> !AbstractFileWatcherUpdater.isMissing(snapshot) && !watchableHierarchies.ignoredForWatching((FileSystemLocationSnapshot)snapshot));
    }

    private static boolean isMissing(FileSystemLocationSnapshot snapshot) {
        return snapshot.getType() == FileType.Missing && snapshot.getAccessType() == FileMetadata.AccessType.DIRECT;
    }
}

