/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.base.TestingExtension;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;
import org.gradle.testing.jacoco.tasks.JacocoCoverageVerification;
import org.gradle.testing.jacoco.tasks.JacocoMerge;
import org.gradle.testing.jacoco.tasks.JacocoReport;

public class JacocoPlugin
implements Plugin<Project> {
    public static final String DEFAULT_JACOCO_VERSION = "0.8.7";
    public static final String AGENT_CONFIGURATION_NAME = "jacocoAgent";
    public static final String ANT_CONFIGURATION_NAME = "jacocoAnt";
    public static final String PLUGIN_EXTENSION_NAME = "jacoco";
    private final Instantiator instantiator;
    private Project project;

    @Inject
    public JacocoPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        this.project = project;
        this.addJacocoConfigurations();
        ProjectInternal projectInternal = (ProjectInternal)project;
        JacocoAgentJar agent = (JacocoAgentJar)this.instantiator.newInstance(JacocoAgentJar.class, new Object[]{projectInternal.getServices().get(FileOperations.class)});
        JacocoPluginExtension extension = (JacocoPluginExtension)project.getExtensions().create(PLUGIN_EXTENSION_NAME, JacocoPluginExtension.class, new Object[]{project, agent});
        extension.setToolVersion(DEFAULT_JACOCO_VERSION);
        ReportingExtension reportingExtension = (ReportingExtension)project.getExtensions().getByName("reporting");
        extension.getReportsDirectory().set(project.getLayout().dir(project.provider(() -> reportingExtension.file(PLUGIN_EXTENSION_NAME))));
        this.configureAgentDependencies(agent, extension);
        this.configureTaskClasspathDefaults(extension);
        this.applyToDefaultTasks(extension);
        this.configureDefaultOutputPathForJacocoMerge();
        this.configureJacocoReportsDefaults(extension);
        this.addDefaultReportAndCoverageVerificationTasks(extension);
    }

    private void addJacocoConfigurations() {
        Configuration agentConf = (Configuration)this.project.getConfigurations().create(AGENT_CONFIGURATION_NAME);
        agentConf.setVisible(false);
        agentConf.setTransitive(true);
        agentConf.setDescription("The Jacoco agent to use to get coverage data.");
        JacocoPlugin.deprecateForConsumption(agentConf);
        Configuration antConf = (Configuration)this.project.getConfigurations().create(ANT_CONFIGURATION_NAME);
        antConf.setVisible(false);
        antConf.setTransitive(true);
        antConf.setDescription("The Jacoco ant tasks to use to get execute Gradle tasks.");
        JacocoPlugin.deprecateForConsumption(antConf);
    }

    private static void deprecateForConsumption(Configuration configuration) {
        ((DeprecatableConfiguration)configuration).deprecateForConsumption((T deprecation) -> deprecation.willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "plugin_configuration_consumption"));
    }

    private void configureAgentDependencies(JacocoAgentJar jacocoAgentJar, JacocoPluginExtension extension) {
        Configuration config = this.project.getConfigurations().getAt(AGENT_CONFIGURATION_NAME);
        jacocoAgentJar.setAgentConf((FileCollection)config);
        config.defaultDependencies(dependencies -> dependencies.add((Object)this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.agent:" + extension.getToolVersion()))));
    }

    private void configureTaskClasspathDefaults(JacocoPluginExtension extension) {
        Configuration config = this.project.getConfigurations().getAt(ANT_CONFIGURATION_NAME);
        this.project.getTasks().withType(JacocoBase.class).configureEach(task -> task.setJacocoClasspath((FileCollection)config));
        config.defaultDependencies(dependencies -> dependencies.add((Object)this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.ant:" + extension.getToolVersion()))));
    }

    private void applyToDefaultTasks(JacocoPluginExtension extension) {
        this.project.getTasks().withType(Test.class).configureEach(extension::applyTo);
    }

    private void configureDefaultOutputPathForJacocoMerge() {
        Provider buildDirectory = this.project.getLayout().getBuildDirectory().getAsFile();
        this.project.getTasks().withType(JacocoMerge.class).configureEach(task -> task.setDestinationFile((Provider<File>)buildDirectory.map(buildDir -> new File((File)buildDir, "jacoco/" + task.getName() + ".exec"))));
    }

    private void configureJacocoReportsDefaults(JacocoPluginExtension extension) {
        this.project.getTasks().withType(JacocoReport.class).configureEach(reportTask -> this.configureJacocoReportDefaults(extension, (JacocoReport)((Object)reportTask)));
    }

    private void configureJacocoReportDefaults(JacocoPluginExtension extension, JacocoReport reportTask) {
        reportTask.getReports().all(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)report -> report.getRequired().set((Object)report.getName().equals("html"))));
        DirectoryProperty reportsDir = extension.getReportsDirectory();
        reportTask.getReports().all(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)report -> {
            if (report.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                report.setDestination(reportsDir.dir(reportTask.getName() + "/" + report.getName()).map(Directory::getAsFile));
            } else {
                report.setDestination(reportsDir.dir(reportTask.getName() + "/" + reportTask.getName() + "." + report.getName()).map(Directory::getAsFile));
            }
        }));
    }

    private void addDefaultReportAndCoverageVerificationTasks(JacocoPluginExtension extension) {
        this.project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            TestingExtension testing = (TestingExtension)this.project.getExtensions().getByType(TestingExtension.class);
            JvmTestSuite defaultTestSuite = (JvmTestSuite)testing.getSuites().withType(JvmTestSuite.class).getByName("test");
            defaultTestSuite.getTargets().configureEach(target -> {
                TaskProvider testTask = target.getTestTask();
                this.addDefaultReportTask(extension, (TaskProvider<? extends Task>)testTask);
                this.addDefaultCoverageVerificationTask((TaskProvider<? extends Task>)testTask);
            });
        });
    }

    private void addDefaultReportTask(JacocoPluginExtension extension, TaskProvider<? extends Task> testTaskProvider) {
        String testTaskName = testTaskProvider.getName();
        this.project.getTasks().register(PLUGIN_EXTENSION_NAME + StringUtils.capitalize((String)testTaskName) + "Report", JacocoReport.class, reportTask -> {
            reportTask.setGroup("verification");
            reportTask.setDescription(String.format("Generates code coverage report for the %s task.", testTaskName));
            reportTask.executionData((Task)testTaskProvider.get());
            reportTask.sourceSets((SourceSet)((SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
            DirectoryProperty reportsDir = extension.getReportsDirectory();
            reportTask.getReports().all(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)report -> {
                if (report.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                    report.setDestination(reportsDir.dir(testTaskName + "/" + report.getName()).map(Directory::getAsFile));
                } else {
                    report.setDestination(reportsDir.dir(testTaskName + "/" + reportTask.getName() + "." + report.getName()).map(Directory::getAsFile));
                }
            }));
        });
    }

    private void addDefaultCoverageVerificationTask(TaskProvider<? extends Task> testTaskProvider) {
        this.project.getTasks().register(PLUGIN_EXTENSION_NAME + StringUtils.capitalize((String)testTaskProvider.getName()) + "CoverageVerification", JacocoCoverageVerification.class, coverageVerificationTask -> {
            coverageVerificationTask.setGroup("verification");
            coverageVerificationTask.setDescription(String.format("Verifies code coverage metrics based on specified rules for the %s task.", testTaskProvider.getName()));
            coverageVerificationTask.executionData((Task)testTaskProvider.get());
            coverageVerificationTask.sourceSets((SourceSet)((SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
        });
    }
}

