/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.util.Optional;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.internal.vfs.impl.VfsRootReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVirtualFileSystem
implements VirtualFileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVirtualFileSystem.class);
    protected final VfsRootReference rootReference;

    protected AbstractVirtualFileSystem(VfsRootReference rootReference) {
        this.rootReference = rootReference;
    }

    @Override
    public Optional<FileSystemLocationSnapshot> findSnapshot(String absolutePath) {
        return this.rootReference.getRoot().findSnapshot(absolutePath);
    }

    @Override
    public Optional<MetadataSnapshot> findMetadata(String absolutePath) {
        return this.rootReference.getRoot().findMetadata(absolutePath);
    }

    @Override
    public void store(String absolutePath, FileSystemLocationSnapshot snapshot) {
        this.rootReference.update(root -> this.updateNotifyingListeners(diffListener -> root.store(absolutePath, snapshot, diffListener)));
    }

    @Override
    public void invalidate(Iterable<String> locations) {
        LOGGER.debug("Invalidating VFS paths: {}", locations);
        this.rootReference.update(root -> {
            SnapshotHierarchy result = root;
            for (String location : locations) {
                SnapshotHierarchy currentRoot = result;
                result = this.updateNotifyingListeners(diffListener -> currentRoot.invalidate(location, diffListener));
            }
            return result;
        });
    }

    @Override
    public void invalidateAll() {
        LOGGER.debug("Invalidating the whole VFS");
        this.rootReference.update(root -> this.updateNotifyingListeners(diffListener -> {
            root.rootSnapshots().forEach(diffListener::nodeRemoved);
            return root.empty();
        }));
    }

    protected abstract SnapshotHierarchy updateNotifyingListeners(UpdateFunction var1);

    public static interface UpdateFunction {
        public SnapshotHierarchy update(SnapshotHierarchy.NodeDiffListener var1);
    }
}

