/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.plugin.devel.plugins.IvyPluginPublishingPlugin;
import org.gradle.plugin.devel.plugins.MavenPluginPublishPlugin;
import org.gradle.plugin.devel.tasks.GeneratePluginDescriptors;
import org.gradle.plugin.devel.tasks.PluginUnderTestMetadata;
import org.gradle.plugin.devel.tasks.ValidatePlugins;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;
import org.gradle.plugin.use.resolve.internal.local.PluginPublication;

@NonNullApi
public class JavaGradlePluginPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(JavaGradlePluginPlugin.class);
    static final String API_CONFIGURATION = "api";
    static final String JAR_TASK = "jar";
    static final String PROCESS_RESOURCES_TASK = "processResources";
    static final String GRADLE_PLUGINS = "gradle-plugins";
    static final String PLUGIN_DESCRIPTOR_PATTERN = "META-INF/gradle-plugins/*.properties";
    static final String CLASSES_PATTERN = "**/*.class";
    static final String BAD_IMPL_CLASS_WARNING_MESSAGE = "%s: A valid plugin descriptor was found for %s but the implementation class %s was not found in the jar.";
    static final String INVALID_DESCRIPTOR_WARNING_MESSAGE = "%s: A plugin descriptor was found for %s but it was invalid.";
    static final String NO_DESCRIPTOR_WARNING_MESSAGE = "%s: No valid plugin descriptors were found in META-INF/gradle-plugins";
    static final String DECLARED_PLUGIN_MISSING_MESSAGE = "%s: Could not find plugin descriptor of %s at META-INF/gradle-plugins/%s.properties";
    static final String DECLARATION_MISSING_ID_MESSAGE = "Missing id for %s";
    static final String DECLARATION_MISSING_IMPLEMENTATION_MESSAGE = "Missing implementationClass for %s";
    static final String EXTENSION_NAME = "gradlePlugin";
    static final String PLUGIN_UNDER_TEST_METADATA_TASK_NAME = "pluginUnderTestMetadata";
    static final String GENERATE_PLUGIN_DESCRIPTORS_TASK_NAME = "pluginDescriptors";
    static final String VALIDATE_PLUGINS_TASK_NAME = "validatePlugins";
    static final String PLUGIN_DEVELOPMENT_GROUP = "Plugin development";
    static final String PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION = "Generates the metadata for plugin functional tests.";
    static final String GENERATE_PLUGIN_DESCRIPTORS_TASK_DESCRIPTION = "Generates plugin descriptors from plugin declarations.";
    static final String VALIDATE_PLUGIN_TASK_DESCRIPTION = "Validates the plugin by checking parameter annotations on task and artifact transform types etc.";

    public void apply(Project project) {
        project.getPluginManager().apply(JavaLibraryPlugin.class);
        this.applyDependencies(project);
        GradlePluginDevelopmentExtension extension = this.createExtension(project);
        this.configureJarTask(project, extension);
        this.configureTestKit(project, extension);
        this.configurePublishing(project);
        this.registerPlugins(project, extension);
        this.configureDescriptorGeneration(project, extension);
        this.validatePluginDeclarations(project, extension);
        this.configurePluginValidations(project, extension);
    }

    private void registerPlugins(Project project, GradlePluginDevelopmentExtension extension) {
        ProjectInternal projectInternal = (ProjectInternal)project;
        ProjectPublicationRegistry registry = (ProjectPublicationRegistry)projectInternal.getServices().get(ProjectPublicationRegistry.class);
        extension.getPlugins().all(pluginDeclaration -> registry.registerPublication(projectInternal, (ProjectPublication)new LocalPluginPublication((PluginDeclaration)pluginDeclaration)));
    }

    private void applyDependencies(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add(API_CONFIGURATION, (Object)dependencies.gradleApi());
    }

    private void configureJarTask(Project project, GradlePluginDevelopmentExtension extension) {
        project.getTasks().named(JAR_TASK, Jar.class, jarTask -> {
            ArrayList<PluginDescriptor> descriptors = new ArrayList<PluginDescriptor>();
            HashSet<String> classList = new HashSet<String>();
            PluginDescriptorCollectorAction pluginDescriptorCollector = new PluginDescriptorCollectorAction(descriptors);
            ClassManifestCollectorAction classManifestCollector = new ClassManifestCollectorAction(classList);
            Provider pluginsProvider = project.provider(() -> extension.getPlugins().getAsMap().values());
            PluginValidationAction pluginValidationAction = new PluginValidationAction((Provider<Collection<PluginDeclaration>>)pluginsProvider, descriptors, classList);
            jarTask.filesMatching(PLUGIN_DESCRIPTOR_PATTERN, (Action)pluginDescriptorCollector);
            jarTask.filesMatching(CLASSES_PATTERN, (Action)classManifestCollector);
            jarTask.appendParallelSafeAction((Action)pluginValidationAction);
        });
    }

    private GradlePluginDevelopmentExtension createExtension(Project project) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet defaultPluginSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        SourceSet defaultTestSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("test");
        return (GradlePluginDevelopmentExtension)project.getExtensions().create(EXTENSION_NAME, GradlePluginDevelopmentExtension.class, new Object[]{project, defaultPluginSourceSet, defaultTestSourceSet});
    }

    private void configureTestKit(Project project, GradlePluginDevelopmentExtension extension) {
        TaskProvider<PluginUnderTestMetadata> pluginUnderTestMetadataTask = this.createAndConfigurePluginUnderTestMetadataTask(project, extension);
        this.establishTestKitAndPluginClasspathDependencies(project, extension, pluginUnderTestMetadataTask);
    }

    private TaskProvider<PluginUnderTestMetadata> createAndConfigurePluginUnderTestMetadataTask(Project project, GradlePluginDevelopmentExtension extension) {
        return project.getTasks().register(PLUGIN_UNDER_TEST_METADATA_TASK_NAME, PluginUnderTestMetadata.class, pluginUnderTestMetadataTask -> {
            pluginUnderTestMetadataTask.setGroup(PLUGIN_DEVELOPMENT_GROUP);
            pluginUnderTestMetadataTask.setDescription(PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION);
            pluginUnderTestMetadataTask.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir(pluginUnderTestMetadataTask.getName()));
            pluginUnderTestMetadataTask.getPluginClasspath().from(new Object[]{() -> {
                SourceSet sourceSet = extension.getPluginSourceSet();
                Configuration runtimeClasspath = project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName());
                ArtifactView view = runtimeClasspath.getIncoming().artifactView(config -> config.componentFilter(SerializableLambdas.spec(JavaGradlePluginPlugin::excludeGradleApi)));
                return pluginUnderTestMetadataTask.getProject().getObjects().fileCollection().from(new Object[]{sourceSet.getOutput(), view.getFiles().getElements()});
            }});
        });
    }

    private static boolean excludeGradleApi(ComponentIdentifier componentId) {
        if (componentId instanceof OpaqueComponentIdentifier) {
            DependencyFactory.ClassPathNotation classPathNotation = ((OpaqueComponentIdentifier)componentId).getClassPathNotation();
            return classPathNotation != DependencyFactory.ClassPathNotation.GRADLE_API && classPathNotation != DependencyFactory.ClassPathNotation.LOCAL_GROOVY;
        }
        return true;
    }

    private void establishTestKitAndPluginClasspathDependencies(Project project, GradlePluginDevelopmentExtension extension, TaskProvider<PluginUnderTestMetadata> pluginClasspathTask) {
        project.afterEvaluate((Action)new TestKitAndPluginClasspathDependenciesAction(extension, pluginClasspathTask));
    }

    private void configurePublishing(Project project) {
        project.getPluginManager().withPlugin("maven-publish", appliedPlugin -> project.getPluginManager().apply(MavenPluginPublishPlugin.class));
        project.getPluginManager().withPlugin("ivy-publish", appliedPlugin -> project.getPluginManager().apply(IvyPluginPublishingPlugin.class));
    }

    private void configureDescriptorGeneration(Project project, GradlePluginDevelopmentExtension extension) {
        TaskProvider generatePluginDescriptors = project.getTasks().register(GENERATE_PLUGIN_DESCRIPTORS_TASK_NAME, GeneratePluginDescriptors.class, task -> {
            task.setGroup(PLUGIN_DEVELOPMENT_GROUP);
            task.setDescription(GENERATE_PLUGIN_DESCRIPTORS_TASK_DESCRIPTION);
            task.getDeclarations().set(extension.getPlugins());
            task.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir(task.getName()));
        });
        project.getTasks().named(PROCESS_RESOURCES_TASK, Copy.class, task -> {
            CopySpecInternal copyPluginDescriptors = task.getRootSpec().addChild();
            copyPluginDescriptors.into((Object)"META-INF/gradle-plugins");
            copyPluginDescriptors.from(new Object[]{generatePluginDescriptors});
        });
    }

    private void validatePluginDeclarations(Project project, GradlePluginDevelopmentExtension extension) {
        project.afterEvaluate(evaluatedProject -> {
            for (PluginDeclaration declaration : extension.getPlugins()) {
                if (declaration.getId() == null) {
                    throw new IllegalArgumentException(String.format(DECLARATION_MISSING_ID_MESSAGE, declaration.getName()));
                }
                if (declaration.getImplementationClass() != null) continue;
                throw new IllegalArgumentException(String.format(DECLARATION_MISSING_IMPLEMENTATION_MESSAGE, declaration.getName()));
            }
        });
    }

    private void configurePluginValidations(Project project, GradlePluginDevelopmentExtension extension) {
        TaskProvider validatorTask = project.getTasks().register(VALIDATE_PLUGINS_TASK_NAME, ValidatePlugins.class, task -> {
            task.setGroup(PLUGIN_DEVELOPMENT_GROUP);
            task.setDescription(VALIDATE_PLUGIN_TASK_DESCRIPTION);
            task.getOutputFile().set(project.getLayout().getBuildDirectory().file("reports/plugin-development/validation-report.txt"));
            task.getClasses().setFrom(new Object[]{() -> extension.getPluginSourceSet().getOutput().getClassesDirs()});
            task.getClasspath().setFrom(new Object[]{() -> extension.getPluginSourceSet().getCompileClasspath()});
        });
        project.getTasks().named("check", check -> check.dependsOn(new Object[]{validatorTask}));
    }

    private static class LocalPluginPublication
    implements PluginPublication {
        private final PluginDeclaration pluginDeclaration;

        LocalPluginPublication(PluginDeclaration pluginDeclaration) {
            this.pluginDeclaration = pluginDeclaration;
        }

        public DisplayName getDisplayName() {
            return Describables.withTypeAndName((Object)"plugin", (String)this.pluginDeclaration.getName());
        }

        public PluginId getPluginId() {
            return DefaultPluginId.of((String)this.pluginDeclaration.getId());
        }
    }

    static class TestKitAndPluginClasspathDependenciesAction
    implements Action<Project> {
        private final GradlePluginDevelopmentExtension extension;
        private final TaskProvider<PluginUnderTestMetadata> pluginClasspathTask;

        private TestKitAndPluginClasspathDependenciesAction(GradlePluginDevelopmentExtension extension, TaskProvider<PluginUnderTestMetadata> pluginClasspathTask) {
            this.extension = extension;
            this.pluginClasspathTask = pluginClasspathTask;
        }

        public void execute(Project project) {
            DependencyHandler dependencies = project.getDependencies();
            Set<SourceSet> testSourceSets = this.extension.getTestSourceSets();
            project.getNormalization().getRuntimeClasspath().ignore("plugin-under-test-metadata.properties");
            project.getTasks().withType(Test.class).configureEach(test -> test.getInputs().files(new Object[]{((PluginUnderTestMetadata)((Object)((Object)this.pluginClasspathTask.get()))).getPluginClasspath()}).withPropertyName("pluginClasspath").withNormalizer(ClasspathNormalizer.class));
            for (SourceSet testSourceSet : testSourceSets) {
                String implementationConfigurationName = testSourceSet.getImplementationConfigurationName();
                dependencies.add(implementationConfigurationName, (Object)dependencies.gradleTestKit());
                String runtimeOnlyConfigurationName = testSourceSet.getRuntimeOnlyConfigurationName();
                dependencies.add(runtimeOnlyConfigurationName, (Object)project.getLayout().files(new Object[]{this.pluginClasspathTask}));
            }
        }
    }

    static class ClassManifestCollectorAction
    implements Action<FileCopyDetails> {
        Set<String> classList;

        ClassManifestCollectorAction(Set<String> classList) {
            this.classList = classList;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            this.classList.add(fileCopyDetails.getRelativePath().toString());
        }
    }

    static class PluginDescriptorCollectorAction
    implements Action<FileCopyDetails> {
        List<PluginDescriptor> descriptors;

        PluginDescriptorCollectorAction(List<PluginDescriptor> descriptors) {
            this.descriptors = descriptors;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            PluginDescriptor descriptor;
            try {
                descriptor = new PluginDescriptor(fileCopyDetails.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                return;
            }
            if (descriptor.getImplementationClassName() != null) {
                this.descriptors.add(descriptor);
            }
        }
    }

    static class PluginValidationAction
    implements Action<Task> {
        private final Provider<Collection<PluginDeclaration>> plugins;
        private final Collection<PluginDescriptor> descriptors;
        private final Set<String> classes;

        PluginValidationAction(Provider<Collection<PluginDeclaration>> plugins, @Nullable Collection<PluginDescriptor> descriptors, Set<String> classes) {
            this.plugins = plugins;
            this.descriptors = descriptors;
            this.classes = classes;
        }

        public void execute(Task task) {
            if (this.descriptors == null || this.descriptors.isEmpty()) {
                LOGGER.warn(String.format(JavaGradlePluginPlugin.NO_DESCRIPTOR_WARNING_MESSAGE, task.getPath()));
            } else {
                HashSet pluginFileNames = Sets.newHashSet();
                for (PluginDescriptor descriptor : this.descriptors) {
                    URI descriptorURI = null;
                    try {
                        descriptorURI = descriptor.getPropertiesFileUrl().toURI();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    String pluginFileName = descriptorURI != null ? new File(descriptorURI).getName() : "UNKNOWN";
                    pluginFileNames.add(pluginFileName);
                    String pluginImplementation = descriptor.getImplementationClassName();
                    if (pluginImplementation.length() == 0) {
                        LOGGER.warn(String.format(JavaGradlePluginPlugin.INVALID_DESCRIPTOR_WARNING_MESSAGE, task.getPath(), pluginFileName));
                        continue;
                    }
                    if (this.hasFullyQualifiedClass(pluginImplementation)) continue;
                    LOGGER.warn(String.format(JavaGradlePluginPlugin.BAD_IMPL_CLASS_WARNING_MESSAGE, task.getPath(), pluginFileName, pluginImplementation));
                }
                for (PluginDeclaration declaration : (Collection)this.plugins.get()) {
                    if (pluginFileNames.contains(declaration.getId() + ".properties")) continue;
                    LOGGER.warn(String.format(JavaGradlePluginPlugin.DECLARED_PLUGIN_MISSING_MESSAGE, task.getPath(), declaration.getName(), declaration.getId()));
                }
            }
        }

        boolean hasFullyQualifiedClass(String fqClass) {
            return this.classes.contains(fqClass.replaceAll("\\.", "/") + ".class");
        }
    }
}

