/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.capabilities.Capability;

public class Configurations {
    public static ImmutableSet<String> getNames(Collection<Configuration> configurations) {
        if (configurations.isEmpty()) {
            return ImmutableSet.of();
        }
        if (configurations.size() == 1) {
            return ImmutableSet.of((Object)configurations.iterator().next().getName());
        }
        ImmutableSet.Builder names = new ImmutableSet.Builder();
        for (Configuration configuration : configurations) {
            names.add((Object)configuration.getName());
        }
        return names.build();
    }

    public static Set<Capability> collectCapabilities(Configuration configuration, Set<Capability> out, Set<Configuration> visited) {
        if (visited.add(configuration)) {
            out.addAll(configuration.getOutgoing().getCapabilities());
            for (Configuration parent : configuration.getExtendsFrom()) {
                Configurations.collectCapabilities(parent, out, visited);
            }
        }
        return out;
    }

    public static String uploadTaskName(String configurationName) {
        return "upload" + StringUtils.capitalize((String)configurationName);
    }
}

