/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.execution.plan.OrdinalNode;

public class OrdinalNodeAccess {
    TreeMap<Integer, OrdinalNode> destroyerLocationNodes = Maps.newTreeMap();
    TreeMap<Integer, OrdinalNode> producerLocationNodes = Maps.newTreeMap();

    OrdinalNode getOrCreateDestroyableLocationNode(int ordinal) {
        return this.destroyerLocationNodes.computeIfAbsent(ordinal, this::createDestroyerLocationNode);
    }

    OrdinalNode getOrCreateOutputLocationNode(int ordinal) {
        return this.producerLocationNodes.computeIfAbsent(ordinal, this::createProducerLocationNode);
    }

    Collection<OrdinalNode> getPrecedingDestroyerLocationNodes(int from) {
        return this.destroyerLocationNodes.headMap(from).values();
    }

    Collection<OrdinalNode> getPrecedingProducerLocationNodes(int from) {
        return this.producerLocationNodes.headMap(from).values();
    }

    List<OrdinalNode> getAllNodes() {
        return Streams.concat((Stream[])new Stream[]{this.destroyerLocationNodes.values().stream(), this.producerLocationNodes.values().stream()}).collect(Collectors.toList());
    }

    void createInterNodeRelationships() {
        this.destroyerLocationNodes.forEach((ordinal, destroyer) -> this.getPrecedingProducerLocationNodes((int)ordinal).forEach(destroyer::addDependencySuccessor));
        this.producerLocationNodes.forEach((ordinal, producer) -> this.getPrecedingDestroyerLocationNodes((int)ordinal).forEach(producer::addDependencySuccessor));
    }

    private OrdinalNode createDestroyerLocationNode(int ordinal) {
        return this.createOrdinalNode(OrdinalNode.Type.DESTROYER, ordinal);
    }

    private OrdinalNode createProducerLocationNode(int ordinal) {
        return this.createOrdinalNode(OrdinalNode.Type.PRODUCER, ordinal);
    }

    private OrdinalNode createOrdinalNode(OrdinalNode.Type type, int ordinal) {
        OrdinalNode ordinalNode = new OrdinalNode(type, ordinal);
        ordinalNode.require();
        return ordinalNode;
    }
}

