/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class Usage {
    public static final String BAT_DELIMITER_CHARACTERS_NOTE = "Note: on Windows, arguments that contain delimiter characters (whitespace, =, ;, ,) need to be surrounded with double quotes (\").";

    @NotNull
    public static <A extends CommonToolArguments> String render(@NotNull CLITool<A> tool, @NotNull A arguments2) {
        if (tool == null) {
            Usage.$$$reportNull$$$1(0);
        }
        if (arguments2 == null) {
            Usage.$$$reportNull$$$1(1);
        }
        if (tool == null) {
            Usage.$$$reportNull$$$0(0);
        }
        if (arguments2 == null) {
            Usage.$$$reportNull$$$0(1);
        }
        boolean extraHelp = arguments2.getExtraHelp();
        StringBuilder sb = new StringBuilder();
        Usage.appendln(sb, "Usage: " + tool.executableScriptFileName() + " <options> <source files>");
        Usage.appendln(sb, "where " + (extraHelp ? "advanced" : "possible") + " options include:");
        KClass kClass2 = JvmClassMappingKt.getKotlinClass(arguments2.getClass());
        for (KCallable callable : kClass2.getMembers()) {
            if (!(callable instanceof KProperty1)) continue;
            Usage.propertyUsage(sb, (KProperty1)callable, extraHelp);
        }
        if (extraHelp) {
            Usage.appendln(sb, "");
            Usage.appendln(sb, "Advanced options are non-standard and may be changed or removed without any notice.");
        } else {
            Usage.renderOptionJUsage(sb);
            Usage.renderArgfileUsage(sb);
        }
        if (SystemInfo.isWindows) {
            Usage.appendln(sb, "");
            Usage.appendln(sb, BAT_DELIMITER_CHARACTERS_NOTE);
        }
        if (!extraHelp && tool instanceof CLICompiler) {
            Usage.appendln(sb, "");
            Usage.appendln(sb, "For details, see https://kotl.in/cli");
        }
        String string2 = sb.toString();
        if (string2 == null) {
            Usage.$$$reportNull$$$0(2);
        }
        if (string2 == null) {
            Usage.$$$reportNull$$$1(2);
        }
        return string2;
    }

    private static void propertyUsage(@NotNull StringBuilder sb, @NotNull KProperty1<?, ?> property2, boolean extraHelp) {
        Argument argument2;
        if (sb == null) {
            Usage.$$$reportNull$$$1(3);
        }
        if (property2 == null) {
            Usage.$$$reportNull$$$1(4);
        }
        if (sb == null) {
            Usage.$$$reportNull$$$0(3);
        }
        if (property2 == null) {
            Usage.$$$reportNull$$$0(4);
        }
        if ((argument2 = ContainerUtil.findInstance(property2.getAnnotations(), Argument.class)) == null) {
            return;
        }
        if (extraHelp != ParseCommandLineArgumentsKt.isAdvanced(argument2)) {
            return;
        }
        int startLength = sb.length();
        sb.append("  ");
        sb.append(argument2.value());
        if (!argument2.shortName().isEmpty()) {
            sb.append(" (");
            sb.append(argument2.shortName());
            sb.append(")");
        }
        if (!argument2.valueDescription().isEmpty()) {
            sb.append(ParseCommandLineArgumentsKt.isAdvanced(argument2) ? "=" : " ");
            sb.append(argument2.valueDescription());
        }
        int margin = startLength + 29 - 1;
        if (sb.length() >= margin + 5) {
            sb.append("\n");
            margin += sb.length() - startLength;
        }
        while (sb.length() < margin) {
            sb.append(" ");
        }
        sb.append(" ");
        Usage.appendln(sb, argument2.description().replace("\n", "\n" + StringsKt.repeat((CharSequence)" ", (int)29)));
    }

    private static void renderOptionJUsage(@NotNull StringBuilder sb) {
        if (sb == null) {
            Usage.$$$reportNull$$$1(5);
        }
        if (sb == null) {
            Usage.$$$reportNull$$$0(5);
        }
        int descriptionStart = sb.length() + 29;
        sb.append("  -J<option>");
        while (sb.length() < descriptionStart) {
            sb.append(" ");
        }
        Usage.appendln(sb, "Pass an option directly to JVM");
    }

    private static void renderArgfileUsage(@NotNull StringBuilder sb) {
        if (sb == null) {
            Usage.$$$reportNull$$$1(6);
        }
        if (sb == null) {
            Usage.$$$reportNull$$$0(6);
        }
        int descriptionStart = sb.length() + 29;
        sb.append("  ");
        sb.append("@");
        sb.append("<argfile>");
        while (sb.length() < descriptionStart) {
            sb.append(" ");
        }
        Usage.appendln(sb, "Read compiler arguments and file paths from the given file");
    }

    private static void appendln(@NotNull StringBuilder sb, @NotNull String string2) {
        if (sb == null) {
            Usage.$$$reportNull$$$1(7);
        }
        if (string2 == null) {
            Usage.$$$reportNull$$$1(8);
        }
        if (sb == null) {
            Usage.$$$reportNull$$$0(7);
        }
        if (string2 == null) {
            Usage.$$$reportNull$$$0(8);
        }
        sb.append(string2);
        sb.append('\n');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/Usage";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/Usage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "propertyUsage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderOptionJUsage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderArgfileUsage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendln";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/Usage";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/Usage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "propertyUsage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderOptionJUsage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderArgfileUsage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendln";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

