/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.HashSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class FunctionalInterfaceParameterizationUtil {
    private static final Logger LOG = Logger.getInstance(FunctionalInterfaceParameterizationUtil.class);

    public static boolean isWildcardParameterized(@Nullable PsiType classType) {
        if (classType == null) {
            return false;
        }
        if (classType instanceof PsiIntersectionType) {
            for (PsiType type2 : ((PsiIntersectionType)classType).getConjuncts()) {
                if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(type2)) continue;
                return false;
            }
        }
        if (classType instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)classType).resolveGenerics();
            PsiClass aClass = result2.getElement();
            if (aClass != null) {
                PsiSubstitutor substitutor2 = result2.getSubstitutor();
                for (PsiTypeParameter parameter : aClass.getTypeParameters()) {
                    if (!(substitutor2.substitute(parameter) instanceof PsiWildcardType)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(psiClassType, null);
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType, @Nullable PsiLambdaExpression expr) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(psiClassType, expr, true);
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType, @Nullable PsiLambdaExpression expr, boolean performFinalCheck) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(psiClassType)) {
            return psiClassType;
        }
        if (expr != null && expr.hasFormalParameterTypes()) {
            return FunctionalInterfaceParameterizationUtil.getFunctionalTypeExplicit(psiClassType, expr, performFinalCheck);
        }
        return psiClassType instanceof PsiClassType ? FunctionalInterfaceParameterizationUtil.getNonWildcardParameterization((PsiClassType)psiClassType) : null;
    }

    private static PsiType getFunctionalTypeExplicit(PsiType psiClassType, PsiLambdaExpression expr, boolean performFinalCheck) {
        PsiParameter[] lambdaParams = expr.getParameterList().getParameters();
        if (psiClassType instanceof PsiIntersectionType) {
            for (PsiType psiType2 : ((PsiIntersectionType)psiClassType).getConjuncts()) {
                PsiType functionalType = FunctionalInterfaceParameterizationUtil.getFunctionalTypeExplicit(psiType2, expr, performFinalCheck);
                if (functionalType == null) continue;
                return functionalType;
            }
            return null;
        }
        LOG.assertTrue(psiClassType instanceof PsiClassType, "Unexpected type: " + psiClassType);
        PsiType[] parameters2 = ((PsiClassType)psiClassType).getParameters();
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)psiClassType).resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                return null;
            }
            PsiClass samClass = interfaceMethod.getContainingClass();
            if (samClass == null) {
                return null;
            }
            PsiTypeParameter[] typeParameters2 = psiClass.getTypeParameters();
            if (typeParameters2.length != parameters2.length) {
                return null;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(psiClass.getProject());
            PsiParameter[] targetMethodParams = interfaceMethod.getParameterList().getParameters();
            if (targetMethodParams.length != lambdaParams.length) {
                return null;
            }
            PsiSubstitutor lambdaSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(samClass, psiClass, PsiSubstitutor.EMPTY);
            InferenceSession session2 = new InferenceSession(typeParameters2, PsiSubstitutor.EMPTY, expr.getManager(), expr);
            for (int i = 0; i < targetMethodParams.length; ++i) {
                PsiType qType = lambdaSubstitutor.substitute(targetMethodParams[i].getType());
                session2.addConstraint(new TypeEqualityConstraint(lambdaParams[i].getType(), session2.substituteWithInferenceVariables(qType)));
            }
            if (!session2.repeatInferencePhases()) {
                return null;
            }
            PsiSubstitutor substitutor2 = session2.getInstantiations(session2.getInferenceVariables());
            PsiType[] newTypeParameters = new PsiType[parameters2.length];
            for (int i = 0; i < typeParameters2.length; ++i) {
                PsiTypeParameter typeParameter = typeParameters2[i];
                newTypeParameters[i] = substitutor2.getSubstitutionMap().containsKey(typeParameter) ? substitutor2.substitute(typeParameter) : parameters2[i];
            }
            PsiClassType parameterization = elementFactory.createType(psiClass, newTypeParameters);
            if (!FunctionalInterfaceParameterizationUtil.isWellFormed(psiClass, typeParameters2, newTypeParameters) || performFinalCheck && !psiClassType.isAssignableFrom(parameterization)) {
                return null;
            }
            if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(parameterization)) {
                return parameterization;
            }
            return FunctionalInterfaceParameterizationUtil.getNonWildcardParameterization(parameterization);
        }
        return null;
    }

    private static boolean isWellFormed(PsiClass psiClass, PsiTypeParameter[] typeParameters2, PsiType[] newTypeParameters) {
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY.putAll(psiClass, newTypeParameters);
        for (int i = 0; i < typeParameters2.length; ++i) {
            for (PsiClassType bound : typeParameters2[i].getExtendsListTypes()) {
                if (!GenericsUtil.checkNotInBounds(newTypeParameters[i], substitutor2.substitute(bound), false)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static PsiType getNonWildcardParameterization(PsiClassType psiClassType) {
        PsiClassType.ClassResolveResult result2 = psiClassType.resolveGenerics();
        PsiClass psiClass = result2.getElement();
        if (psiClass != null) {
            PsiTypeParameter[] typeParameters2 = psiClass.getTypeParameters();
            PsiType[] newParameters = new PsiType[typeParameters2.length];
            PsiSubstitutor substitutor2 = result2.getSubstitutor();
            HashSet<PsiTypeParameter> typeParametersSet = ContainerUtil.newHashSet(typeParameters2);
            block0: for (int i = 0; i < typeParameters2.length; ++i) {
                PsiType paramType = substitutor2.substitute(typeParameters2[i]);
                if (paramType instanceof PsiWildcardType) {
                    PsiType bound = ((PsiWildcardType)paramType).getBound();
                    for (PsiClassType paramBound : typeParameters2[i].getExtendsListTypes()) {
                        if (!PsiTypesUtil.mentionsTypeParameters(paramBound, typeParametersSet)) continue;
                        newParameters[i] = bound;
                        continue block0;
                    }
                    if (((PsiWildcardType)paramType).isSuper()) {
                        newParameters[i] = bound;
                        continue;
                    }
                    newParameters[i] = bound != null ? bound : PsiType.getJavaLangObject(psiClass.getManager(), psiClassType.getResolveScope());
                    for (PsiClassType paramBound : typeParameters2[i].getExtendsListTypes()) {
                        newParameters[i] = GenericsUtil.getGreatestLowerBound(newParameters[i], paramBound);
                    }
                    continue;
                }
                newParameters[i] = paramType;
            }
            if (!FunctionalInterfaceParameterizationUtil.isWellFormed(psiClass, typeParameters2, newParameters)) {
                return null;
            }
            PsiClassType parameterization = JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass, newParameters);
            if (!psiClassType.isAssignableFrom(parameterization)) {
                return null;
            }
            return parameterization;
        }
        return null;
    }
}

