/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyClass;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyConstructor;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyEnumEntryImpl;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyField;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyFunction;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyProperty;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazySymbolTable;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyTypeAlias;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyTypeParameter;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensions;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010)2\u0006\u0010+\u001a\u00020.H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010)2\u0006\u0010+\u001a\u000200H\u0002J\u000e\u00101\u001a\u00020\u000e2\u0006\u0010(\u001a\u000202J\u000e\u00103\u001a\u0002042\u0006\u0010(\u001a\u000205J\u000e\u00106\u001a\u0002072\u0006\u0010(\u001a\u000202J\u000e\u00108\u001a\u0002092\u0006\u0010(\u001a\u00020:J\u0018\u0010;\u001a\u00020<2\u0006\u0010(\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020 J\u000e\u0010?\u001a\u00020@2\u0006\u0010(\u001a\u00020)J\u000e\u0010A\u001a\u00020B2\u0006\u0010(\u001a\u00020CJ\u0010\u0010D\u001a\u0004\u0018\u00010\u000e2\u0006\u0010(\u001a\u00020)J\u0015\u0010E\u001a\u00020F2\u0006\u0010(\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ\u0015\u0010I\u001a\u00020F2\u0006\u0010(\u001a\u00020GH\u0000\u00a2\u0006\u0002\bJJ\u000e\u0010K\u001a\u00020L2\u0006\u0010(\u001a\u00020:J\u0018\u0010M\u001a\u00020@2\u0006\u0010N\u001a\u00020O2\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010P\u001a\u00020Q2\u0006\u0010(\u001a\u00020RJ\u0015\u0010S\u001a\u00020T2\u0006\u0010(\u001a\u00020UH\u0000\u00a2\u0006\u0002\bVJ\u0012\u0010W\u001a\u0004\u0018\u00010@2\u0006\u0010N\u001a\u00020OH\u0016J\f\u0010X\u001a\u00020Y*\u00020ZH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR$\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006["}, d2={"Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "extensions", "Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions;)V", "getExtensions", "()Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions;", "facadeClassMap", "", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lazyTable", "Lorg/jetbrains/kotlin/ir/declarations/lazy/IrLazySymbolTable;", "getLazyTable", "()Lorg/jetbrains/kotlin/ir/declarations/lazy/IrLazySymbolTable;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "getTypeTranslator", "()Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "value", "", "unboundSymbolGeneration", "getUnboundSymbolGeneration", "()Z", "setUnboundSymbolGeneration", "(Z)V", "computeOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findDescriptorBySignature", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "findDescriptorForAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "findDescriptorForPublicSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "generateClassStub", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateConstructorStub", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "generateEnumEntryStub", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "generateFieldStub", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateFunctionStub", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "createPropertyIfNeeded", "generateMemberStub", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "generateOrGetEmptyExternalPackageFragmentStub", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "generateOrGetFacadeClass", "generateOrGetScopedTypeParameterStub", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "generateOrGetScopedTypeParameterStub$ir_tree", "generateOrGetTypeParameterStub", "generateOrGetTypeParameterStub$ir_tree", "generatePropertyStub", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "generateStubBySymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "generateTypeAliasStub", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "generateValueParameterStub", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "generateValueParameterStub$ir_tree", "getDeclaration", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "ir.tree"})
public abstract class DeclarationStubGenerator
implements IrProvider {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final StubGeneratorExtensions extensions;
    @NotNull
    private final IrLazySymbolTable lazyTable;
    @NotNull
    private final Map<DeserializedContainerSource, IrClass> facadeClassMap;

    public DeclarationStubGenerator(@NotNull ModuleDescriptor moduleDescriptor, @NotNull SymbolTable symbolTable, @NotNull StubGeneratorExtensions extensions) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        this.moduleDescriptor = moduleDescriptor;
        this.symbolTable = symbolTable;
        this.extensions = extensions;
        this.lazyTable = this.symbolTable.getLazyWrapper();
        boolean bl = false;
        this.facadeClassMap = new LinkedHashMap();
    }

    public /* synthetic */ DeclarationStubGenerator(ModuleDescriptor moduleDescriptor, SymbolTable symbolTable, StubGeneratorExtensions stubGeneratorExtensions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            stubGeneratorExtensions = StubGeneratorExtensions.EMPTY;
        }
        this(moduleDescriptor, symbolTable, stubGeneratorExtensions);
    }

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final StubGeneratorExtensions getExtensions() {
        return this.extensions;
    }

    @NotNull
    protected final IrLazySymbolTable getLazyTable() {
        return this.lazyTable;
    }

    @NotNull
    public final IrLock getLock() {
        return this.symbolTable.getLock();
    }

    public final boolean getUnboundSymbolGeneration() {
        return this.lazyTable.getStubGenerator() != null;
    }

    public final void setUnboundSymbolGeneration(boolean value2) {
        this.lazyTable.setStubGenerator(value2 ? this : null);
    }

    @NotNull
    public abstract TypeTranslator getTypeTranslator();

    @Override
    @Nullable
    public IrDeclaration getDeclaration(@NotNull IrSymbol symbol2) {
        DeclarationDescriptor descriptor2;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!symbol2.getHasDescriptor()) {
            IdSignature idSignature = symbol2.getSignature();
            if (idSignature == null) {
                String string2 = Intrinsics.stringPlus((String)"Symbol is not public API. Expected signature for symbol: ", (Object)symbol2.getDescriptor());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            declarationDescriptor = this.findDescriptorBySignature(idSignature);
        } else {
            declarationDescriptor = descriptor2 = symbol2.getDescriptor();
        }
        if (descriptor2 == null) {
            return null;
        }
        return this.generateStubBySymbol(symbol2, descriptor2);
    }

    @NotNull
    public final IrExternalPackageFragment generateOrGetEmptyExternalPackageFragmentStub(@NotNull PackageFragmentDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrExternalPackageFragmentSymbol referenced = this.symbolTable.referenceExternalPackageFragment(descriptor2);
        if (referenced.isBound()) {
            return (IrExternalPackageFragment)referenced.getOwner();
        }
        return this.symbolTable.declareExternalPackageFragment(descriptor2);
    }

    @Nullable
    public final IrClass generateOrGetFacadeClass(@NotNull DeclarationDescriptor descriptor2) {
        IrClass irClass2;
        DescriptorWithContainerSource descriptorWithContainerSource;
        PropertyAccessorDescriptor propertyAccessorDescriptor;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor $this$safeAs$iv = descriptor2;
        boolean $i$f$safeAs22 = false;
        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
        if (!(declarationDescriptor instanceof PropertyAccessorDescriptor)) {
            declarationDescriptor = null;
        }
        DeclarationDescriptor directMember = (propertyAccessorDescriptor = (PropertyAccessorDescriptor)declarationDescriptor) == null ? descriptor2 : (($this$safeAs$iv = propertyAccessorDescriptor.getCorrespondingProperty()) == null ? descriptor2 : $this$safeAs$iv);
        Object $i$f$safeAs22 = directMember.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor2 = $this$safeAs$iv = $i$f$safeAs22 instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)$i$f$safeAs22 : null;
        if ($this$safeAs$iv == null) {
            return null;
        }
        DeclarationDescriptor packageFragment = $this$safeAs$iv;
        DeclarationDescriptor $this$safeAs$iv2 = directMember;
        boolean $i$f$safeAs = false;
        DeclarationDescriptor declarationDescriptor3 = $this$safeAs$iv2;
        if (!(declarationDescriptor3 instanceof DescriptorWithContainerSource)) {
            declarationDescriptor3 = null;
        }
        Object object = $i$f$safeAs22 = (descriptorWithContainerSource = (DescriptorWithContainerSource)declarationDescriptor3) == null ? null : descriptorWithContainerSource.getContainerSource();
        if ($i$f$safeAs22 == null) {
            return null;
        }
        Object containerSource = $i$f$safeAs22;
        Map<DeserializedContainerSource, IrClass> $this$getOrPut$iv = this.facadeClassMap;
        boolean $i$f$getOrPut = false;
        IrClass value$iv = $this$getOrPut$iv.get(containerSource);
        if (value$iv == null) {
            IrClass irClass3;
            boolean bl = false;
            IrClass irClass4 = this.getExtensions().generateFacadeClass(this.getSymbolTable().getIrFactory(), (DeserializedContainerSource)containerSource);
            if (irClass4 == null) {
                irClass3 = null;
            } else {
                IrClass irClass5 = irClass4;
                boolean bl2 = false;
                boolean bl3 = false;
                IrClass facade = irClass5;
                boolean bl4 = false;
                IrExternalPackageFragment packageStub = this.generateOrGetEmptyExternalPackageFragmentStub((PackageFragmentDescriptor)packageFragment);
                facade.setParent(packageStub);
                packageStub.getDeclarations().add(facade);
                irClass3 = irClass5;
            }
            IrClass answer$iv = irClass3;
            $this$getOrPut$iv.put((DeserializedContainerSource)containerSource, answer$iv);
            irClass2 = answer$iv;
        } else {
            irClass2 = value$iv;
        }
        return irClass2;
    }

    @NotNull
    public final IrDeclaration generateMemberStub(@NotNull DeclarationDescriptor descriptor2) {
        IrDeclaration irDeclaration2;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ClassDescriptor) {
            irDeclaration2 = DescriptorUtils.isEnumEntry(descriptor2) ? (IrDeclaration)this.generateEnumEntryStub((ClassDescriptor)descriptor2) : (IrDeclaration)this.generateClassStub((ClassDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof ClassConstructorDescriptor) {
            irDeclaration2 = this.generateConstructorStub((ClassConstructorDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            irDeclaration2 = DeclarationStubGenerator.generateFunctionStub$default(this, (FunctionDescriptor)descriptor2, false, 2, null);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            irDeclaration2 = this.generatePropertyStub((PropertyDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof TypeAliasDescriptor) {
            irDeclaration2 = this.generateTypeAliasStub((TypeAliasDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof TypeParameterDescriptor) {
            irDeclaration2 = this.generateOrGetTypeParameterStub$ir_tree((TypeParameterDescriptor)descriptor2);
        } else {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected member descriptor: ", (Object)descriptor2));
        }
        return irDeclaration2;
    }

    private final IrDeclaration generateStubBySymbol(IrSymbol symbol2, DeclarationDescriptor descriptor2) {
        IrSymbol irSymbol2 = symbol2;
        return irSymbol2 instanceof IrFieldSymbol ? (IrDeclaration)this.generateFieldStub((PropertyDescriptor)descriptor2) : (irSymbol2 instanceof IrTypeParameterSymbol ? (IrDeclaration)this.generateOrGetTypeParameterStub$ir_tree((TypeParameterDescriptor)descriptor2) : this.generateMemberStub(descriptor2));
    }

    private final IrDeclarationOrigin computeOrigin(DeclarationDescriptor descriptor2) {
        IrDeclarationOrigin irDeclarationOrigin = this.extensions.computeExternalDeclarationOrigin(descriptor2);
        return irDeclarationOrigin == null ? (IrDeclarationOrigin)IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE : irDeclarationOrigin;
    }

    @NotNull
    public final IrProperty generatePropertyStub(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrPropertySymbol referenced = this.symbolTable.referenceProperty(descriptor2);
        if (referenced.isBound()) {
            return (IrProperty)referenced.getOwner();
        }
        IrDeclarationOrigin origin = this.computeOrigin(descriptor2);
        PropertyDescriptor propertyDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptor.original");
        return this.symbolTable.declareProperty(-1, -1, origin, propertyDescriptor, descriptor2.isDelegated(), (Function1<? super IrPropertySymbol, ? extends IrProperty>)((Function1)new Function1<IrPropertySymbol, IrProperty>(origin, descriptor2, this){
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ DeclarationStubGenerator this$0;
            {
                this.$origin = $origin;
                this.$descriptor = $descriptor;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrProperty invoke(@NotNull IrPropertySymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = this.$descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.name");
                Name name = object;
                object = this.$descriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.visibility");
                Object object2 = object;
                object = this.$descriptor.getModality();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.modality");
                return new IrLazyProperty(-1, -1, this.$origin, it, this.$descriptor, name, (DescriptorVisibility)object2, (Modality)((Object)object), this.$descriptor.isVar(), this.$descriptor.isConst(), this.$descriptor.isLateInit(), this.$descriptor.isDelegated(), DescriptorUtilsKt.isEffectivelyExternal(this.$descriptor), this.$descriptor.isExpect(), Intrinsics.areEqual((Object)this.$origin, (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) || this.$descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE, this.this$0, this.this$0.getTypeTranslator());
            }
        }));
    }

    @NotNull
    public final IrField generateFieldStub(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrFieldSymbol referenced = this.symbolTable.referenceField(descriptor2);
        if (referenced.isBound()) {
            return (IrField)referenced.getOwner();
        }
        IrDeclarationOrigin irDeclarationOrigin = this.computeOrigin(descriptor2);
        Annotated annotated = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"descriptor.original");
        PropertyDescriptor propertyDescriptor = annotated;
        annotated = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"descriptor.type");
        return SymbolTable.declareField$default(this.symbolTable, -1, -1, irDeclarationOrigin, propertyDescriptor, this.toIrType((KotlinType)annotated), null, (Function1)new Function1<IrFieldSymbol, IrField>(this, descriptor2){
            final /* synthetic */ DeclarationStubGenerator this$0;
            final /* synthetic */ PropertyDescriptor $descriptor;
            {
                this.this$0 = $receiver;
                this.$descriptor = $descriptor;
                super(1);
            }

            @NotNull
            public final IrField invoke(@NotNull IrFieldSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IrDeclarationOrigin irDeclarationOrigin = DeclarationStubGenerator.access$computeOrigin(this.this$0, this.$descriptor);
                Object object = this.$descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.name");
                Name name = object;
                object = this.$descriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.visibility");
                return new IrLazyField(-1, -1, irDeclarationOrigin, it, this.$descriptor, name, (DescriptorVisibility)object, !this.$descriptor.isVar(), DescriptorUtilsKt.isEffectivelyExternal(this.$descriptor), this.$descriptor.getDispatchReceiverParameter() == null, this.this$0, this.this$0.getTypeTranslator());
            }
        }, 32, null);
    }

    @NotNull
    public final IrSimpleFunction generateFunctionStub(@NotNull FunctionDescriptor descriptor2, boolean createPropertyIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrSimpleFunctionSymbol referenced = this.symbolTable.referenceSimpleFunction(descriptor2);
        if (referenced.isBound()) {
            return (IrSimpleFunction)referenced.getOwner();
        }
        if (createPropertyIfNeeded && descriptor2 instanceof PropertyGetterDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
            IrProperty property2 = this.generatePropertyStub(propertyDescriptor);
            IrSimpleFunction irSimpleFunction = property2.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            return irSimpleFunction;
        }
        if (createPropertyIfNeeded && descriptor2 instanceof PropertySetterDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
            IrProperty property3 = this.generatePropertyStub(propertyDescriptor);
            IrSimpleFunction irSimpleFunction = property3.getSetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            return irSimpleFunction;
        }
        IrDeclarationOrigin origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE ? (IrDeclarationOrigin)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE : this.computeOrigin(descriptor2);
        FunctionDescriptor functionDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"descriptor.original");
        return this.symbolTable.declareSimpleFunction(functionDescriptor, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(origin, descriptor2, this){
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ FunctionDescriptor $descriptor;
            final /* synthetic */ DeclarationStubGenerator this$0;
            {
                this.$origin = $origin;
                this.$descriptor = $descriptor;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = this.$descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.name");
                Name name = object;
                object = this.$descriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.visibility");
                Object object2 = object;
                object = this.$descriptor.getModality();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.modality");
                return new IrLazyFunction(-1, -1, this.$origin, it, this.$descriptor, name, (DescriptorVisibility)object2, (Modality)((Object)object), this.$descriptor.isInline(), this.$descriptor.isExternal(), this.$descriptor.isTailrec(), this.$descriptor.isSuspend(), this.$descriptor.isExpect(), Intrinsics.areEqual((Object)this.$origin, (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE), this.$descriptor.isOperator(), this.$descriptor.isInfix(), this.this$0, this.this$0.getTypeTranslator());
            }
        }));
    }

    public static /* synthetic */ IrSimpleFunction generateFunctionStub$default(DeclarationStubGenerator declarationStubGenerator, FunctionDescriptor functionDescriptor, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateFunctionStub");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return declarationStubGenerator.generateFunctionStub(functionDescriptor, bl);
    }

    @NotNull
    public final IrConstructor generateConstructorStub(@NotNull ClassConstructorDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrConstructorSymbol referenced = this.symbolTable.referenceConstructor(descriptor2);
        if (referenced.isBound()) {
            return (IrConstructor)referenced.getOwner();
        }
        IrDeclarationOrigin origin = this.computeOrigin(descriptor2);
        return this.symbolTable.declareConstructor(descriptor2.getOriginal(), (Function1<? super IrConstructorSymbol, ? extends IrConstructor>)((Function1)new Function1<IrConstructorSymbol, IrConstructor>(origin, descriptor2, this){
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ ClassConstructorDescriptor $descriptor;
            final /* synthetic */ DeclarationStubGenerator this$0;
            {
                this.$origin = $origin;
                this.$descriptor = $descriptor;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrConstructor invoke(@NotNull IrConstructorSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = this.$descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.name");
                Name name = object;
                object = this.$descriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.visibility");
                return new IrLazyConstructor(-1, -1, this.$origin, it, this.$descriptor, name, (DescriptorVisibility)object, this.$descriptor.isInline(), DescriptorUtilsKt.isEffectivelyExternal(this.$descriptor), this.$descriptor.isPrimary(), this.$descriptor.isExpect(), this.this$0, this.this$0.getTypeTranslator());
            }
        }));
    }

    private final IrType toIrType(KotlinType $this$toIrType) {
        return this.getTypeTranslator().translateType($this$toIrType);
    }

    @NotNull
    public final IrValueParameter generateValueParameterStub$ir_tree(@NotNull ValueParameterDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        boolean bl = false;
        boolean bl2 = false;
        ValueParameterDescriptor $this$generateValueParameterStub_u24lambda_u2d3 = descriptor2;
        boolean bl3 = false;
        IrFactory irFactory = this.getSymbolTable().getIrFactory();
        IrDeclarationOrigin irDeclarationOrigin = this.computeOrigin($this$generateValueParameterStub_u24lambda_u2d3);
        IrValueParameterSymbol irValueParameterSymbol = new IrValueParameterSymbolImpl($this$generateValueParameterStub_u24lambda_u2d3);
        Object object = $this$generateValueParameterStub_u24lambda_u2d3.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        Name name = object;
        int n = $this$generateValueParameterStub_u24lambda_u2d3.getIndex();
        object = $this$generateValueParameterStub_u24lambda_u2d3.getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"type");
        IrType irType = this.toIrType((KotlinType)object);
        object = $this$generateValueParameterStub_u24lambda_u2d3.getVarargElementType();
        object = irFactory.createValueParameter(-1, -1, irDeclarationOrigin, irValueParameterSymbol, name, n, irType, object == null ? null : this.toIrType((KotlinType)object), $this$generateValueParameterStub_u24lambda_u2d3.isCrossinline(), $this$generateValueParameterStub_u24lambda_u2d3.isNoinline(), false, false);
        boolean bl4 = false;
        boolean bl5 = false;
        Object irValueParameter = object;
        boolean bl6 = false;
        if (descriptor2.declaresDefaultValue()) {
            IrFactory irFactory2 = irValueParameter.getFactory();
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
            ((IrValueParameter)irValueParameter).setDefaultValue(irFactory2.createExpressionBody(new IrErrorExpressionImpl(-1, -1, this.toIrType(kotlinType), Intrinsics.stringPlus((String)"Stub expression for default value of ", (Object)descriptor2.getName()))));
        }
        return object;
    }

    @NotNull
    public final IrClass generateClassStub(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrClassSymbol referenceClass2 = this.symbolTable.referenceClass(descriptor2);
        if (referenceClass2.isBound()) {
            return (IrClass)referenceClass2.getOwner();
        }
        IrDeclarationOrigin origin = this.computeOrigin(descriptor2);
        return this.symbolTable.declareClass(descriptor2, (Function1<? super IrClassSymbol, ? extends IrClass>)((Function1)new Function1<IrClassSymbol, IrClass>(origin, descriptor2, this){
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ ClassDescriptor $descriptor;
            final /* synthetic */ DeclarationStubGenerator this$0;
            {
                this.$origin = $origin;
                this.$descriptor = $descriptor;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrClass invoke(@NotNull IrClassSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = this.$descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.name");
                Name name = object;
                object = this.$descriptor.getKind();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.kind");
                Object object2 = object;
                object = this.$descriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.visibility");
                Object object3 = object;
                object = this.$descriptor.getModality();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.modality");
                return new IrLazyClass(-1, -1, this.$origin, it, this.$descriptor, name, (ClassKind)((Object)object2), (DescriptorVisibility)object3, (Modality)((Object)object), this.$descriptor.isCompanionObject(), this.$descriptor.isInner(), this.$descriptor.isData(), DescriptorUtilsKt.isEffectivelyExternal(this.$descriptor), InlineClassesUtilsKt.isInlineClass(this.$descriptor), this.$descriptor.isExpect(), this.$descriptor.isFun(), this.this$0, this.this$0.getTypeTranslator());
            }
        }));
    }

    @NotNull
    public final IrEnumEntry generateEnumEntryStub(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrEnumEntrySymbol referenced = this.symbolTable.referenceEnumEntry(descriptor2);
        if (referenced.isBound()) {
            return (IrEnumEntry)referenced.getOwner();
        }
        IrDeclarationOrigin origin = this.computeOrigin(descriptor2);
        return this.symbolTable.declareEnumEntry(-1, -1, origin, descriptor2, (Function1<? super IrEnumEntrySymbol, ? extends IrEnumEntry>)((Function1)new Function1<IrEnumEntrySymbol, IrEnumEntry>(origin, descriptor2, this){
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ ClassDescriptor $descriptor;
            final /* synthetic */ DeclarationStubGenerator this$0;
            {
                this.$origin = $origin;
                this.$descriptor = $descriptor;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrEnumEntry invoke(@NotNull IrEnumEntrySymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new IrLazyEnumEntryImpl(-1, -1, this.$origin, it, this.$descriptor, this.this$0, this.this$0.getTypeTranslator());
            }
        }));
    }

    @NotNull
    public final IrTypeParameter generateOrGetTypeParameterStub$ir_tree(@NotNull TypeParameterDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrTypeParameterSymbol referenced = this.symbolTable.referenceTypeParameter(descriptor2);
        if (referenced.isBound()) {
            return (IrTypeParameter)referenced.getOwner();
        }
        IrDeclarationOrigin origin = this.computeOrigin(descriptor2);
        return this.symbolTable.declareGlobalTypeParameter(-1, -1, origin, descriptor2, (Function1<? super IrTypeParameterSymbol, ? extends IrTypeParameter>)((Function1)new Function1<IrTypeParameterSymbol, IrTypeParameter>(origin, descriptor2, this){
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ TypeParameterDescriptor $descriptor;
            final /* synthetic */ DeclarationStubGenerator this$0;
            {
                this.$origin = $origin;
                this.$descriptor = $descriptor;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrTypeParameter invoke(@NotNull IrTypeParameterSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = this.$descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.name");
                Name name = object;
                int n = this.$descriptor.getIndex();
                boolean bl = this.$descriptor.isReified();
                object = this.$descriptor.getVariance();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.variance");
                return new IrLazyTypeParameter(-1, -1, this.$origin, it, this.$descriptor, name, n, bl, (Variance)((Object)object), this.this$0, this.this$0.getTypeTranslator());
            }
        }));
    }

    @NotNull
    public final IrTypeParameter generateOrGetScopedTypeParameterStub$ir_tree(@NotNull TypeParameterDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrTypeParameterSymbol referenced = this.symbolTable.referenceTypeParameter(descriptor2);
        if (referenced.isBound()) {
            return (IrTypeParameter)referenced.getOwner();
        }
        IrDeclarationOrigin origin = this.computeOrigin(descriptor2);
        return this.symbolTable.declareScopedTypeParameter(-1, -1, origin, descriptor2, (Function1<? super IrTypeParameterSymbol, ? extends IrTypeParameter>)((Function1)new Function1<IrTypeParameterSymbol, IrTypeParameter>(origin, descriptor2, this){
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ TypeParameterDescriptor $descriptor;
            final /* synthetic */ DeclarationStubGenerator this$0;
            {
                this.$origin = $origin;
                this.$descriptor = $descriptor;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrTypeParameter invoke(@NotNull IrTypeParameterSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = this.$descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.name");
                Name name = object;
                int n = this.$descriptor.getIndex();
                boolean bl = this.$descriptor.isReified();
                object = this.$descriptor.getVariance();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.variance");
                return new IrLazyTypeParameter(-1, -1, this.$origin, it, this.$descriptor, name, n, bl, (Variance)((Object)object), this.this$0, this.this$0.getTypeTranslator());
            }
        }));
    }

    @NotNull
    public final IrTypeAlias generateTypeAliasStub(@NotNull TypeAliasDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        IrTypeAliasSymbol referenced = this.symbolTable.referenceTypeAlias(descriptor2);
        if (referenced.isBound()) {
            return (IrTypeAlias)referenced.getOwner();
        }
        IrDeclarationOrigin origin = this.computeOrigin(descriptor2);
        return this.symbolTable.declareTypeAlias(descriptor2, (Function1<? super IrTypeAliasSymbol, ? extends IrTypeAlias>)((Function1)new Function1<IrTypeAliasSymbol, IrTypeAlias>(origin, descriptor2, this){
            final /* synthetic */ IrDeclarationOrigin $origin;
            final /* synthetic */ TypeAliasDescriptor $descriptor;
            final /* synthetic */ DeclarationStubGenerator this$0;
            {
                this.$origin = $origin;
                this.$descriptor = $descriptor;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrTypeAlias invoke(@NotNull IrTypeAliasSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = this.$descriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.name");
                Name name = object;
                object = this.$descriptor.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.visibility");
                return new IrLazyTypeAlias(-1, -1, this.$origin, it, this.$descriptor, name, (DescriptorVisibility)object, this.$descriptor.isActual(), this.this$0, this.this$0.getTypeTranslator());
            }
        }));
    }

    private final DeclarationDescriptor findDescriptorBySignature(IdSignature signature2) {
        DeclarationDescriptor declarationDescriptor;
        IdSignature idSignature = signature2;
        if (idSignature instanceof IdSignature.AccessorSignature) {
            declarationDescriptor = this.findDescriptorForAccessorSignature((IdSignature.AccessorSignature)signature2);
        } else if (idSignature instanceof IdSignature.PublicSignature) {
            declarationDescriptor = this.findDescriptorForPublicSignature((IdSignature.PublicSignature)signature2);
        } else {
            String string2 = Intrinsics.stringPlus((String)"only PublicSignature or AccessorSignature should reach this point, got ", (Object)signature2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return declarationDescriptor;
    }

    private final DeclarationDescriptor findDescriptorForAccessorSignature(IdSignature.AccessorSignature signature2) {
        Object v1;
        block3: {
            PropertyDescriptor propertyDescriptor;
            Object object = this.findDescriptorBySignature(signature2.getPropertySignature());
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor = object instanceof PropertyDescriptor ? (PropertyDescriptor)object : null;
            if (propertyDescriptor == null) {
                return null;
            }
            PropertyDescriptor propertyDescriptor3 = propertyDescriptor;
            String shortName = signature2.getAccessorSignature().getShortName();
            object = propertyDescriptor3.getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"propertyDescriptor.accessors");
            Iterable $this$singleOrNull$iv = (Iterable)object;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                PropertyAccessorDescriptor it = (PropertyAccessorDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)shortName)) continue;
                if (found$iv) {
                    v1 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarationDescriptor findDescriptorForPublicSignature(IdSignature.PublicSignature signature2) {
        Object v3;
        block6: {
            PackageViewDescriptor packageDescriptor = this.moduleDescriptor.getPackage(signature2.packageFqName());
            List<String> nameSegments = signature2.getNameSegments();
            Collection toplevelDescriptors2 = MemberScopeKt.getDescriptorsFiltered$default(packageDescriptor.getMemberScope(), null, (Function1)new Function1<Name, Boolean>(nameSegments){
                final /* synthetic */ List<String> $nameSegments;
                {
                    this.$nameSegments = $nameSegments;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Name name) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    return Intrinsics.areEqual((Object)name.asString(), (Object)CollectionsKt.first(this.$nameSegments));
                }
            }, 1, null);
            Iterable $this$fold$iv = CollectionsKt.drop((Iterable)nameSegments, (int)1);
            boolean $i$f$fold = false;
            Collection accumulator$iv = toplevelDescriptors2;
            for (Object element$iv : $this$fold$iv) {
                void $this$flatMapTo$iv$iv;
                String string2 = (String)element$iv;
                Collection acc = accumulator$iv;
                boolean bl = false;
                Iterable $this$flatMap$iv = acc;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List list2;
                    Object object;
                    DeclarationDescriptor container2 = (DeclarationDescriptor)element$iv$iv;
                    boolean bl2 = false;
                    Object object2 = object = container2 instanceof ClassDescriptor ? (ClassDescriptor)container2 : null;
                    if (object == null) {
                        list2 = CollectionsKt.emptyList();
                    } else {
                        void current;
                        void $this$filterTo$iv$iv;
                        ClassDescriptor classDescriptor = object;
                        object = classDescriptor.getConstructors();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classDescriptor.constructors");
                        Iterable $this$filter$iv = (Iterable)object;
                        boolean $i$f$filter = false;
                        Iterable iterable2 = $this$filter$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                            ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv$iv2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)current)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        Collection collection = (List)destination$iv$iv2;
                        object = classDescriptor.getUnsubstitutedMemberScope();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classDescriptor.unsubstitutedMemberScope");
                        list2 = CollectionsKt.plus((Collection)collection, (Iterable)MemberScopeKt.getDescriptorsFiltered$default((MemberScope)object, null, (Function1)new Function1<Name, Boolean>((String)current){
                            final /* synthetic */ String $current;
                            {
                                this.$current = $current;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull Name name) {
                                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                                return Intrinsics.areEqual((Object)name.asString(), (Object)this.$current);
                            }
                        }, 1, null));
                    }
                    Iterable list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                accumulator$iv = (List)destination$iv$iv;
            }
            Collection candidates2 = accumulator$iv;
            Iterable $this$firstOrNull$iv = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.getSymbolTable().getSignaturer().composeSignature(it), (Object)signature2)) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        return v3;
    }

    public static final /* synthetic */ IrDeclarationOrigin access$computeOrigin(DeclarationStubGenerator $this, DeclarationDescriptor descriptor2) {
        return $this.computeOrigin(descriptor2);
    }
}

