/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.TargetManager;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/konan/target/TargetManagerImpl;", "Lorg/jetbrains/kotlin/konan/target/TargetManager;", "userRequest", "", "hostManager", "Lorg/jetbrains/kotlin/konan/target/HostManager;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/konan/target/HostManager;)V", "getHostManager", "()Lorg/jetbrains/kotlin/konan/target/HostManager;", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "targetName", "getTargetName", "()Ljava/lang/String;", "getUserRequest", "determineCurrent", "list", "", "kotlin-native-utils"})
public final class TargetManagerImpl
implements TargetManager {
    @Nullable
    private final String userRequest;
    @NotNull
    private final HostManager hostManager;
    @NotNull
    private final KonanTarget target;

    public TargetManagerImpl(@Nullable String userRequest, @NotNull HostManager hostManager) {
        Intrinsics.checkParameterIsNotNull((Object)hostManager, (String)"hostManager");
        this.userRequest = userRequest;
        this.hostManager = hostManager;
        this.target = this.determineCurrent();
    }

    @Nullable
    public final String getUserRequest() {
        return this.userRequest;
    }

    @NotNull
    public final HostManager getHostManager() {
        return this.hostManager;
    }

    @Override
    @NotNull
    public KonanTarget getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public String getTargetName() {
        return this.getTarget().getVisibleName();
    }

    @Override
    public void list() {
        Iterable $this$forEach$iv = this.hostManager.getEnabled();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KonanTarget it = (KonanTarget)element$iv;
            boolean bl = false;
            String isDefault = Intrinsics.areEqual((Object)it, (Object)this.getTarget()) ? "(default)" : "";
            String aliasList = CollectionsKt.joinToString$default((Iterable)HostManager.Companion.listAliases(it.getVisibleName()), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Object object = StringCompanionObject.INSTANCE;
            String string2 = "%1$-30s%2$-10s%3$s";
            Object[] objectArray = new Object[]{Intrinsics.stringPlus((String)it.getVisibleName(), (Object)":"), isDefault, aliasList};
            boolean bl2 = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            object = string3;
            boolean bl3 = false;
            System.out.println(object);
        }
    }

    private final KonanTarget determineCurrent() {
        KonanTarget konanTarget;
        if (this.userRequest == null || Intrinsics.areEqual((Object)this.userRequest, (Object)"host")) {
            konanTarget = HostManager.Companion.getHost();
        } else {
            String resolvedAlias = HostManager.Companion.resolveAlias(this.userRequest);
            konanTarget = (KonanTarget)MapsKt.getValue(this.hostManager.getTargets(), (Object)this.hostManager.known(resolvedAlias));
        }
        return konanTarget;
    }
}

