/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.buildinit.InsecureProtocolOption;
import org.gradle.buildinit.tasks.InitBuild;
import org.gradle.internal.file.RelativeFilePathResolver;

public class BuildInitPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (project.getParent() == null) {
            project.getTasks().register("init", InitBuild.class, initBuild -> {
                initBuild.setGroup("Build Setup");
                initBuild.setDescription("Initializes a new Gradle build.");
                FileResolver resolver = ((ProjectInternal)project).getFileResolver();
                File buildFile = project.getBuildFile();
                FileDetails buildFileDetails = FileDetails.of(buildFile, (RelativeFilePathResolver)resolver);
                File settingsFile = ((ProjectInternal)project).getGradle().getSettings().getSettingsScript().getResource().getLocation().getFile();
                FileDetails settingsFileDetails = FileDetails.of(settingsFile, (RelativeFilePathResolver)resolver);
                initBuild.onlyIf(new InitBuildOnlyIfSpec(buildFileDetails, settingsFileDetails, initBuild.getLogger()));
                initBuild.dependsOn(new Object[]{new InitBuildDependsOnCallable(buildFileDetails, settingsFileDetails)});
                ProjectInternal.DetachedResolver detachedResolver = ((ProjectInternal)project).newDetachedResolver();
                initBuild.getProjectLayoutRegistry().getBuildConverter().configureClasspath(detachedResolver, project.getObjects());
                initBuild.getInsecureProtocol().convention((Object)InsecureProtocolOption.WARN);
            });
        }
    }

    private static String reasonToSkip(FileDetails buildFile, FileDetails settingsFile) {
        if (buildFile != null && buildFile.file.exists()) {
            return "The build file '" + buildFile.pathForDisplay + "' already exists. Skipping build initialization.";
        }
        if (settingsFile != null && settingsFile.file.exists()) {
            return "The settings file '" + settingsFile.pathForDisplay + "' already exists. Skipping build initialization.";
        }
        return null;
    }

    private static class FileDetails {
        final File file;
        final String pathForDisplay;

        public FileDetails(File file, String pathForDisplay) {
            this.file = file;
            this.pathForDisplay = pathForDisplay;
        }

        @Nullable
        public static FileDetails of(@Nullable File file, RelativeFilePathResolver resolver) {
            if (file == null) {
                return null;
            }
            return new FileDetails(file, resolver.resolveForDisplay((Object)file));
        }
    }

    private static class InitBuildDependsOnCallable
    implements Callable<String> {
        private final FileDetails buildFile;
        private final FileDetails settingsFile;

        private InitBuildDependsOnCallable(FileDetails buildFile, FileDetails settingsFile) {
            this.buildFile = buildFile;
            this.settingsFile = settingsFile;
        }

        @Override
        public String call() {
            if (BuildInitPlugin.reasonToSkip(this.buildFile, this.settingsFile) == null) {
                return "wrapper";
            }
            return null;
        }
    }

    private static class InitBuildOnlyIfSpec
    implements Spec<Task> {
        private final FileDetails buildFile;
        private final FileDetails settingsFile;
        private final Logger logger;

        private InitBuildOnlyIfSpec(FileDetails buildFile, FileDetails settingsFile, Logger logger) {
            this.buildFile = buildFile;
            this.settingsFile = settingsFile;
            this.logger = logger;
        }

        public boolean isSatisfiedBy(Task element) {
            String skippedMsg = BuildInitPlugin.reasonToSkip(this.buildFile, this.settingsFile);
            if (skippedMsg != null) {
                this.logger.warn(skippedMsg);
                return false;
            }
            return true;
        }
    }
}

