/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.EndCollection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ComponentVariantIdentifier;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationDependency;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.TransformedArtifactSet;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Try;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class TransformedProjectArtifactSet
implements TransformedArtifactSet,
FileCollectionInternal.Source,
ResolvedArtifactSet.Artifacts {
    private final ComponentVariantIdentifier targetVariant;
    private final Collection<TransformationNode> transformedArtifacts;

    public TransformedProjectArtifactSet(ComponentVariantIdentifier targetVariant, Collection<TransformationNode> transformedArtifacts) {
        this.targetVariant = targetVariant;
        this.transformedArtifacts = transformedArtifacts;
    }

    public ComponentVariantIdentifier getTargetVariant() {
        return this.targetVariant;
    }

    public Collection<TransformationNode> getTransformedArtifacts() {
        return this.transformedArtifacts;
    }

    @Override
    public void visit(ResolvedArtifactSet.Visitor visitor) {
        FileCollectionStructureVisitor.VisitType visitType = visitor.prepareForVisit(this);
        if (visitType == FileCollectionStructureVisitor.VisitType.NoContents) {
            visitor.visitArtifacts(new EndCollection(this));
        } else {
            visitor.visitArtifacts(this);
        }
    }

    @Override
    public void startFinalization(BuildOperationQueue<RunnableBuildOperation> actions, boolean requireFiles) {
    }

    @Override
    public void visit(ArtifactVisitor visitor) {
        DisplayName displayName = Describables.of((Object)this.targetVariant.getComponentId());
        for (TransformationNode node : this.transformedArtifacts) {
            node.executeIfNotAlready();
            Try<TransformationSubject> transformedSubject = node.getTransformedSubject();
            if (transformedSubject.isSuccessful()) {
                for (File file : ((TransformationSubject)transformedSubject.get()).getFiles()) {
                    visitor.visitArtifact(displayName, this.targetVariant.getAttributes(), this.targetVariant.getCapabilities(), node.getInputArtifact().transformedTo(file));
                }
                continue;
            }
            Throwable failure = (Throwable)transformedSubject.getFailure().get();
            visitor.visitFailure((Throwable)((Object)new TransformException(String.format("Failed to transform %s to match attributes %s.", node.getInputArtifact().getId().getDisplayName(), this.targetVariant.getAttributes()), failure)));
        }
        visitor.endVisitCollection(this);
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        if (!this.transformedArtifacts.isEmpty()) {
            context.add((Object)new DefaultTransformationDependency(this.transformedArtifacts));
        }
    }

    @Override
    public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
        for (TransformationNode transformationNode : this.transformedArtifacts) {
            visitor.visitTransform(transformationNode);
        }
    }

    @Override
    public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
        throw new UnsupportedOperationException("Should not be called.");
    }
}

