/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LanguageVersionSettingsProvider;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.JvmDefaultCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u001d\u001a\u00020\u0012*\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0014H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lcom/intellij/openapi/project/Project;)V", "ideService", "Lorg/jetbrains/kotlin/resolve/LanguageVersionSettingsProvider;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkJvmCompatibilityAnnotations", "", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "checkPossibleClashMember", "inheritedFun", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "actualImplementation", "checkSpecializationInCompatibilityMode", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "performSpecializationCheck", "findPossibleClashMember", "isCompiledToJvmDefaultWithProperMode", "compilationDefaultMode", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmDefaultChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDefaultChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1747#2,3:247\n1360#2:250\n1446#2,5:251\n766#2:265\n857#2,2:266\n288#2,2:268\n515#3:256\n500#3,6:257\n215#4,2:263\n1#5:270\n*S KotlinDebug\n*F\n+ 1 JvmDefaultChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker\n*L\n60#1:247,3\n63#1:250\n63#1:251,5\n222#1:265\n222#1:266,2\n224#1:268,2\n90#1:256\n90#1:257,6\n91#1:263,2\n*E\n"})
public final class JvmDefaultChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;
    @Nullable
    private final LanguageVersionSettingsProvider ideService;

    public JvmDefaultChecker(@NotNull JvmTarget jvmTarget, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.jvmTarget = jvmTarget;
        this.ideService = LanguageVersionSettingsProvider.Companion.getInstance(project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        boolean performSpecializationCheck;
        Object list$iv$iv;
        Iterator<CallableMemberDescriptor> destination$iv$iv;
        Object $this$flatMap$iv;
        Object reportOn;
        AnnotationDescriptor jvmDefaultAnnotation;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JvmDefaultMode jvmDefaultMode2 = context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getJvmDefaultMode());
        AnnotationDescriptor annotationDescriptor = jvmDefaultAnnotation = descriptor2.getAnnotations().findAnnotation(JvmNames.INSTANCE.getJVM_DEFAULT_FQ_NAME());
        if (annotationDescriptor != null) {
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            boolean bl = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor2);
            Object object = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
            if (!DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_NOT_IN_INTERFACE.on((PsiElement)reportOn));
                return;
            }
            if (this.jvmTarget == JvmTarget.JVM_1_6) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on((PsiElement)reportOn, "JvmDefault"));
                return;
            }
            if (!jvmDefaultMode2.isEnabled()) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)declaration), "JvmDefault"));
                return;
            }
        }
        if (this.checkJvmCompatibilityAnnotations(descriptor2, declaration, context, jvmDefaultMode2)) {
            return;
        }
        if (jvmDefaultAnnotation == null && !jvmDefaultMode2.getForAllMethodsWithBody() && DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
            boolean bl;
            block22: {
                CallableMemberDescriptor callableMemberDescriptor = descriptor2 instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)descriptor2 : null;
                if (callableMemberDescriptor == null) {
                    return;
                }
                CallableMemberDescriptor memberDescriptor = callableMemberDescriptor;
                if (descriptor2 instanceof PropertyAccessorDescriptor) {
                    return;
                }
                Collection<? extends CallableMemberDescriptor> collection = memberDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"memberDescriptor.overriddenDescriptors");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!it.getAnnotations().hasAnnotation(JvmNames.INSTANCE.getJVM_DEFAULT_FQ_NAME())) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_REQUIRED_FOR_OVERRIDE.on((KtDeclaration)((PsiElement)declaration)));
            } else if (jvmDefaultMode2.isEnabled()) {
                void $this$flatMapTo$iv$iv;
                Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"descriptor.overriddenDescriptors");
                $this$flatMap$iv = collection;
                boolean $i$f$flatMap = false;
                reportOn = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Map.Entry element$iv$iv : $this$flatMapTo$iv$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)((Object)element$iv$iv);
                    boolean bl3 = false;
                    Set<CallableMemberDescriptor> set = OverridingUtil.getOverriddenDeclarations(it);
                    Intrinsics.checkNotNullExpressionValue(set, (String)"getOverriddenDeclarations(it)");
                    list$iv$iv = set;
                    CollectionsKt.addAll(destination$iv$iv, (Iterable)list$iv$iv);
                }
                Set it = CollectionsKt.toSet((Iterable)((List)((Object)destination$iv$iv)));
                boolean bl4 = false;
                for (CallableMemberDescriptor realDescriptor : OverridingUtil.filterOutOverridden(it)) {
                    if (!(realDescriptor instanceof JavaMethodDescriptor) || ((JavaMethodDescriptor)realDescriptor).getModality() == Modality.ABSTRACT) continue;
                    context.getTrace().report(ErrorsJvm.NON_JVM_DEFAULT_OVERRIDES_JAVA_DEFAULT.on((KtDeclaration)((PsiElement)declaration)));
                    return;
                }
            }
        }
        if (!jvmDefaultMode2.isEnabled() || !(descriptor2 instanceof ClassDescriptor) || DescriptorUtils.isInterface(descriptor2) || DescriptorUtils.isAnnotationClass(descriptor2)) {
            return;
        }
        boolean bl = performSpecializationCheck = jvmDefaultMode2.isCompatibility() && !JvmAnnotationUtilKt.hasJvmDefaultNoCompatibilityAnnotation(descriptor2) && (((ClassDescriptor)descriptor2).getModality() == Modality.OPEN || ((ClassDescriptor)descriptor2).getModality() == Modality.ABSTRACT) && !DescriptorUtilsKt.isEffectivelyPrivateApi((DeclarationDescriptorWithVisibility)descriptor2);
        if (DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2) == null && !performSpecializationCheck) {
            return;
        }
        $this$flatMap$iv = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation((ClassDescriptor)descriptor2, true);
        boolean $i$f$filter = false;
        void bl4 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            list$iv$iv = element$iv$iv;
            boolean bl5 = false;
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)list$iv$iv.getValue();
            if (!this.isCompiledToJvmDefaultWithProperMode(actualImplementation, jvmDefaultMode2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object object = element$iv = iterator2.next();
            boolean bl6 = false;
            CallableMemberDescriptor inheritedMember = (CallableMemberDescriptor)object.getKey();
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)object.getValue();
            if (actualImplementation instanceof FunctionDescriptor && inheritedMember instanceof FunctionDescriptor) {
                if (!this.checkSpecializationInCompatibilityMode((FunctionDescriptor)inheritedMember, (FunctionDescriptor)actualImplementation, context, declaration, performSpecializationCheck)) continue;
                this.checkPossibleClashMember(inheritedMember, actualImplementation, jvmDefaultMode2, context, declaration);
                continue;
            }
            if (!(actualImplementation instanceof PropertyDescriptor) || !(inheritedMember instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getterImpl = ((PropertyDescriptor)actualImplementation).getGetter();
            PropertyGetterDescriptor getterInherited = ((PropertyDescriptor)inheritedMember).getGetter();
            if (getterImpl != null && getterInherited != null && jvmDefaultMode2.isCompatibility() && !this.checkSpecializationInCompatibilityMode(getterInherited, getterImpl, context, declaration, performSpecializationCheck)) continue;
            if (((PropertyDescriptor)actualImplementation).isVar() && ((PropertyDescriptor)inheritedMember).isVar()) {
                PropertySetterDescriptor setterImpl = ((PropertyDescriptor)actualImplementation).getSetter();
                PropertySetterDescriptor setterInherited = ((PropertyDescriptor)inheritedMember).getSetter();
                if (setterImpl != null && setterInherited != null && !this.checkSpecializationInCompatibilityMode(setterInherited, setterImpl, context, declaration, performSpecializationCheck)) continue;
            }
            this.checkPossibleClashMember(inheritedMember, actualImplementation, jvmDefaultMode2, context, declaration);
        }
    }

    private final boolean checkJvmCompatibilityAnnotations(DeclarationDescriptor descriptor2, KtDeclaration declaration, DeclarationCheckerContext context, JvmDefaultMode jvmDefaultMode2) {
        KtElement reportOn;
        AnnotationDescriptor annotationDescriptor;
        AnnotationDescriptor annotationDescriptor2 = descriptor2.getAnnotations().findAnnotation(JvmNames.INSTANCE.getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME());
        if (annotationDescriptor2 != null) {
            annotationDescriptor = annotationDescriptor2;
            boolean bl = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor);
            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
            if (this.jvmTarget == JvmTarget.JVM_1_6) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn, "JvmDefaultWithoutCompatibility"));
                return true;
            }
            if (!jvmDefaultMode2.isEnabled()) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)reportOn), "JvmDefaultWithoutCompatibility"));
                return true;
            }
        }
        AnnotationDescriptor annotationDescriptor3 = descriptor2.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME());
        if (annotationDescriptor3 != null) {
            annotationDescriptor = annotationDescriptor3;
            boolean bl = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor);
            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
            if (this.jvmTarget == JvmTarget.JVM_1_6) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn, "JvmDefaultWithCompatibility"));
                return true;
            }
            if (jvmDefaultMode2 != JvmDefaultMode.ALL_INCOMPATIBLE) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_WITH_COMPATIBILITY_IN_DECLARATION.on((KtElement)((PsiElement)reportOn)));
                return true;
            }
            if (!DescriptorUtils.isInterface(descriptor2)) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_WITH_COMPATIBILITY_NOT_ON_INTERFACE.on((KtElement)((PsiElement)reportOn)));
                return true;
            }
        }
        return false;
    }

    private final boolean checkSpecializationInCompatibilityMode(FunctionDescriptor inheritedFun, FunctionDescriptor actualImplementation, DeclarationCheckerContext context, KtDeclaration declaration, boolean performSpecializationCheck) {
        if (!performSpecializationCheck || actualImplementation instanceof JavaMethodDescriptor) {
            return true;
        }
        String inheritedSignature = MethodSignatureMappingKt.computeJvmDescriptor(inheritedFun, true, false);
        FunctionDescriptor functionDescriptor = actualImplementation.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"actualImplementation.original");
        FunctionDescriptor originalImplementation = functionDescriptor;
        String actualSignature = MethodSignatureMappingKt.computeJvmDescriptor(originalImplementation, true, false);
        if (!Intrinsics.areEqual((Object)inheritedSignature, (Object)actualSignature)) {
            context.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_COMPATIBILITY_MODE.on((KtDeclaration)((PsiElement)declaration), DescriptorUtils.getDirectMember(inheritedFun), DescriptorUtils.getDirectMember(originalImplementation)));
            return false;
        }
        return true;
    }

    private final void checkPossibleClashMember(CallableMemberDescriptor inheritedFun, CallableMemberDescriptor actualImplementation, JvmDefaultMode jvmDefaultMode2, DeclarationCheckerContext context, KtDeclaration declaration) {
        CallableMemberDescriptor clashMember = this.findPossibleClashMember(inheritedFun, jvmDefaultMode2);
        if (clashMember != null) {
            context.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_MIXED_MODE.on((KtDeclaration)((PsiElement)declaration), DescriptorUtils.getDirectMember(actualImplementation), DescriptorUtils.getDirectMember(clashMember), jvmDefaultMode2.getDescription()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final CallableMemberDescriptor findPossibleClashMember(CallableMemberDescriptor inheritedFun, JvmDefaultMode jvmDefaultMode) {
        block8: {
            block7: {
                v0 = inheritedFun.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"inheritedFun.containingDeclaration");
                classDescriptor = v0;
                if (!(classDescriptor instanceof ClassDescriptor) || DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)classDescriptor) == null) {
                    return null;
                }
                v1 = inheritedFun.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(v1, (String)"inheritedFun.overriddenDescriptors");
                $this$filter$iv = v1;
                $i$f$filter = false;
                var7_7 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (CallableMemberDescriptor)element$iv$iv;
                    $i$a$-filter-JvmDefaultChecker$findPossibleClashMember$classMembers$1 = false;
                    if (!(DescriptorUtils.isInterface(it.getContainingDeclaration()) == false && DescriptorUtils.isAnnotationClass(it.getContainingDeclaration()) == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                classMembers = (List)destination$iv$iv;
                $this$firstOrNull$iv = classMembers;
                $i$f$firstOrNull = false;
                for (E element$iv : $this$firstOrNull$iv) {
                    it = (CallableMemberDescriptor)element$iv;
                    $i$a$-firstOrNull-JvmDefaultChecker$findPossibleClashMember$implicitDefaultImplsDelegate$1 = false;
                    if (it instanceof JavaCallableMemberDescriptor) ** GOTO lbl-1000
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    v2 = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation(it, true);
                    v3 = v2 != null ? !this.isCompiledToJvmDefaultWithProperMode(v2, jvmDefaultMode) : false;
                    if (v3) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    if (!v4) continue;
                    v5 = element$iv;
                    break block7;
                }
                v5 = null;
            }
            v6 = implicitDefaultImplsDelegate = (CallableMemberDescriptor)v5;
            if (v6 != null) {
                return v6;
            }
            for (CallableMemberDescriptor it : (Iterable)classMembers) {
                $i$a$-firstNotNullOfOrNull-JvmDefaultChecker$findPossibleClashMember$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                var8_10 = this.findPossibleClashMember(it, jvmDefaultMode);
                if (var8_10 == null) continue;
                v7 = var8_10;
                break block8;
            }
            v7 = null;
        }
        return v7;
    }

    private final boolean isCompiledToJvmDefaultWithProperMode(CallableMemberDescriptor $this$isCompiledToJvmDefaultWithProperMode, JvmDefaultMode compilationDefaultMode) {
        return JvmDefaultCheckerKt.isCompiledToJvmDefaultWithProperMode($this$isCompiledToJvmDefaultWithProperMode, this.ideService, compilationDefaultMode);
    }
}

