/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.NextGenBuildCacheService;
import org.gradle.caching.internal.controller.NextGenBuildCacheAccess;
import org.gradle.caching.internal.controller.NextGenBuildCacheHandler;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedThreadPoolExecutor;
import org.gradle.internal.file.BufferProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNextGenBuildCacheAccess
implements NextGenBuildCacheAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultNextGenBuildCacheAccess.class);
    private final NextGenBuildCacheHandler local;
    private final NextGenBuildCacheHandler remote;
    private final BufferProvider bufferProvider;
    private final ManagedThreadPoolExecutor remoteProcessor;
    private final ConcurrencyCounter counter;

    public DefaultNextGenBuildCacheAccess(NextGenBuildCacheHandler local, NextGenBuildCacheHandler remote, BufferProvider bufferProvider, ExecutorFactory executorFactory) {
        this.local = local;
        this.remote = remote;
        this.bufferProvider = bufferProvider;
        this.remoteProcessor = executorFactory.createThreadPool("Build cache access", 256, 256, 10L, TimeUnit.SECONDS);
        this.counter = new ConcurrencyCounter(this.remoteProcessor);
    }

    @Override
    public <T> void load(Map<BuildCacheKey, T> entries, NextGenBuildCacheAccess.LoadHandler<T> handler) {
        CompletableFuture[] asyncLoads = (CompletableFuture[])entries.entrySet().stream().flatMap(entry -> {
            boolean foundLocally;
            BuildCacheKey key = (BuildCacheKey)entry.getKey();
            Object payload = entry.getValue();
            boolean bl = foundLocally = this.local.canLoad() && this.local.load(key, input -> handler.handle(input, payload));
            if (!foundLocally && this.remote.canLoad()) {
                return Stream.of(CompletableFuture.runAsync(this.counter.wrap(new RemoteDownload(key, payload, handler)), (Executor)this.remoteProcessor));
            }
            return Stream.empty();
        }).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(asyncLoads).join();
    }

    @Override
    public <T> void store(Map<BuildCacheKey, T> entries, NextGenBuildCacheAccess.StoreHandler<T> handler) {
        CompletableFuture[] asyncStores = (CompletableFuture[])entries.entrySet().stream().flatMap(entry -> {
            BuildCacheKey key = (BuildCacheKey)entry.getKey();
            Object payload = entry.getValue();
            if (!this.local.canStore()) {
                return Stream.empty();
            }
            if (!this.local.contains(key)) {
                this.local.store(key, handler.handle(payload));
            }
            if (this.remote.canStore()) {
                return Stream.of(CompletableFuture.runAsync(this.counter.wrap(new RemoteUpload(key)), (Executor)this.remoteProcessor));
            }
            return Stream.empty();
        }).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(asyncStores).join();
    }

    @Override
    public void close() throws IOException {
        Closer closer = Closer.create();
        closer.register(() -> {
            if (!this.remoteProcessor.getQueue().isEmpty() || this.remoteProcessor.getActiveCount() > 0) {
                LOGGER.warn("Waiting for remote cache uploads to finish");
            }
            try {
                this.remoteProcessor.stop(5, TimeUnit.MINUTES);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Couldn't finish uploading all remote entries", e);
            }
        });
        closer.register((Closeable)this.local);
        closer.register((Closeable)this.remote);
        closer.register((Closeable)this.counter);
        closer.close();
    }

    private class RemoteUpload
    implements Runnable {
        private final BuildCacheKey key;

        public RemoteUpload(BuildCacheKey key) {
            this.key = key;
        }

        @Override
        public void run() {
            if (DefaultNextGenBuildCacheAccess.this.remote.contains(this.key)) {
                LOGGER.warn("Not storing {} in remote", (Object)this.key);
                return;
            }
            final UnsynchronizedByteArrayOutputStream data = new UnsynchronizedByteArrayOutputStream();
            boolean foundLocally = DefaultNextGenBuildCacheAccess.this.local.load(this.key, input -> IOUtils.copyLarge((InputStream)input, (OutputStream)data, (byte[])DefaultNextGenBuildCacheAccess.this.bufferProvider.getBuffer()));
            if (!foundLocally) {
                throw new IllegalStateException("Couldn't store " + this.key + " in remote cache because it was missing from local cache");
            }
            LOGGER.warn("Storing {} in remote (size: {})", (Object)this.key, (Object)data.size());
            DefaultNextGenBuildCacheAccess.this.remote.store(this.key, new NextGenBuildCacheService.NextGenWriter(){

                @Override
                public InputStream openStream() {
                    return data.toInputStream();
                }

                public void writeTo(OutputStream output) throws IOException {
                    data.writeTo(output);
                }

                public long getSize() {
                    return data.size();
                }
            });
        }
    }

    private class RemoteDownload<T>
    implements Runnable {
        private final BuildCacheKey key;
        private final T payload;
        private final NextGenBuildCacheAccess.LoadHandler<T> handler;

        public RemoteDownload(BuildCacheKey key, T payload, NextGenBuildCacheAccess.LoadHandler<T> handler) {
            this.key = key;
            this.payload = payload;
            this.handler = handler;
        }

        @Override
        public void run() {
            LOGGER.warn("Loading {} from remote", (Object)this.key);
            DefaultNextGenBuildCacheAccess.this.remote.load(this.key, input -> {
                final UnsynchronizedByteArrayOutputStream data = new UnsynchronizedByteArrayOutputStream();
                byte[] buffer = DefaultNextGenBuildCacheAccess.this.bufferProvider.getBuffer();
                IOUtils.copyLarge((InputStream)input, (OutputStream)data, (byte[])buffer);
                LOGGER.warn("Found {} in remote (size: {})", (Object)this.key, (Object)data.size());
                if (DefaultNextGenBuildCacheAccess.this.local.canStore()) {
                    DefaultNextGenBuildCacheAccess.this.local.store(this.key, new NextGenBuildCacheService.NextGenWriter(){

                        @Override
                        public InputStream openStream() {
                            return data.toInputStream();
                        }

                        public void writeTo(OutputStream output) throws IOException {
                            data.writeTo(output);
                        }

                        public long getSize() {
                            return data.size();
                        }
                    });
                    this.handler.handle(data.toInputStream(), this.payload);
                } else {
                    this.handler.handle(input, this.payload);
                }
            });
        }
    }

    private static class ConcurrencyCounter
    implements Closeable {
        private final AtomicInteger maxQueueLength = new AtomicInteger(0);
        private final AtomicInteger maxActiveCount = new AtomicInteger(0);
        private final ManagedThreadPoolExecutor processor;

        public ConcurrencyCounter(ManagedThreadPoolExecutor processor) {
            this.processor = processor;
        }

        public Runnable wrap(Runnable delegate) {
            return () -> {
                this.maxQueueLength.updateAndGet(max -> Integer.max(max, this.processor.getQueue().size()));
                this.maxActiveCount.updateAndGet(max -> Integer.max(max, this.processor.getActiveCount()));
                delegate.run();
            };
        }

        @Override
        public void close() {
            LOGGER.warn("Max concurrency encountered while processing remote cache entries: {}, max queue length: {}", (Object)this.maxActiveCount.get(), (Object)this.maxQueueLength.get());
        }
    }
}

