/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.resources.TextResource;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

public class FileOrUriNotationConverter
implements NotationConverter<Object, Object> {
    private static final Pattern URI_SCHEME = Pattern.compile("([a-zA-Z][a-zA-Z0-9+-\\.]*:).+");
    private static final Pattern ENCODED_URI = Pattern.compile("%([0-9a-fA-F]{2})");

    public static NotationParser<Object, Object> parser() {
        return NotationParserBuilder.toType(Object.class).typeDisplayName("a File or URI").noImplicitConverters().converter((NotationConverter)new FileOrUriNotationConverter()).toComposite();
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("A String or CharSequence path").example("'src/main/java' or '/usr/include'");
        visitor.candidate("A String or CharSequence URI").example("'file:/usr/include'");
        visitor.candidate("A File instance.");
        visitor.candidate("A Path instance.");
        visitor.candidate("A Directory instance.");
        visitor.candidate("A RegularFile instance.");
        visitor.candidate("A URI or URL instance.");
        visitor.candidate("A TextResource instance.");
    }

    public void convert(Object notation, NotationConvertResult<? super Object> result) throws TypeConversionException {
        if (notation instanceof File) {
            result.converted(notation);
            return;
        }
        if (notation instanceof Path) {
            result.converted((Object)((Path)notation).toFile());
            return;
        }
        if (notation instanceof FileSystemLocation) {
            result.converted((Object)((FileSystemLocation)notation).getAsFile());
            return;
        }
        if (notation instanceof URL) {
            try {
                notation = ((URL)notation).toURI();
            }
            catch (URISyntaxException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        if (notation instanceof URI) {
            URI uri = (URI)notation;
            if ("file".equals(uri.getScheme())) {
                try {
                    result.converted((Object)new File(uri));
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            result.converted((Object)uri);
            return;
        }
        if (notation instanceof CharSequence) {
            String notationString = notation.toString();
            if (notationString.startsWith("file:")) {
                try {
                    URI uri = new URI(notationString);
                    try {
                        result.converted((Object)new File(uri));
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
                catch (URISyntaxException uri) {
                    // empty catch block
                }
                result.converted((Object)new File(FileOrUriNotationConverter.fallbackUrlDecode(notationString.substring(5))));
                return;
            }
            if (notationString.startsWith("http:") || notationString.startsWith("https:")) {
                FileOrUriNotationConverter.convertToUrl(notationString, result);
                return;
            }
            Matcher schemeMatcher = URI_SCHEME.matcher(notationString);
            if (schemeMatcher.matches()) {
                String scheme = schemeMatcher.group(1);
                if (FileOrUriNotationConverter.isWindowsRootDirectory(scheme)) {
                    result.converted((Object)new File(notationString));
                    return;
                }
                FileOrUriNotationConverter.convertToUrl(notationString, result);
                return;
            }
            result.converted((Object)new File(notationString));
        }
        if (notation instanceof TextResource) {
            result.converted((Object)((TextResource)notation).asFile());
        }
    }

    private static boolean isWindowsRootDirectory(String scheme) {
        return scheme.length() == 2 && Character.isLetter(scheme.charAt(0)) && scheme.charAt(1) == ':' && OperatingSystem.current().isWindows();
    }

    private static void convertToUrl(String notationString, NotationConvertResult<? super Object> result) {
        try {
            result.converted((Object)new URI(notationString));
        }
        catch (URISyntaxException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static String fallbackUrlDecode(String path) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Passing invalid URIs to URI or File converting methods.").withAdvice("Use a valid URL or a file path instead.")).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "deprecated_invalid_url_decoding")).nagUser();
        StringBuffer builder = new StringBuffer();
        Matcher matcher = ENCODED_URI.matcher(path);
        while (matcher.find()) {
            String val = matcher.group(1);
            matcher.appendReplacement(builder, String.valueOf((char)Integer.parseInt(val, 16)));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }
}

