/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.ExternalGrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.exceptions.InvalidPropertyException;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateDomainClassProperty;
import org.codehaus.groovy.grails.validation.ConstraintsEvaluator;
import org.codehaus.groovy.grails.validation.DefaultConstraintEvaluator;
import org.codehaus.groovy.grails.validation.GrailsDomainClassValidator;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.AnyType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsHibernateDomainClass
extends AbstractGrailsClass
implements ExternalGrailsDomainClass {
    private static final String HIBERNATE = "hibernate";
    private GrailsHibernateDomainClassProperty identifier;
    private GrailsHibernateDomainClassProperty version;
    private GrailsDomainClassProperty[] properties;
    private Map<String, GrailsHibernateDomainClassProperty> propertyMap = new LinkedHashMap<String, GrailsHibernateDomainClassProperty>();
    private Validator validator;
    private GrailsApplication application;
    private SessionFactory sessionFactory;
    private String sessionFactoryName;
    private Set subClasses = new HashSet();
    private Map constraints = Collections.emptyMap();

    public GrailsHibernateDomainClass(Class<?> clazz, SessionFactory sessionFactory, String sessionFactoryName, GrailsApplication application, ClassMetadata metaData) {
        super(clazz, "");
        String[] propertyNames;
        this.application = application;
        this.sessionFactory = sessionFactory;
        this.sessionFactoryName = sessionFactoryName;
        new StandardAnnotationMetadata(clazz);
        String ident = metaData.getIdentifierPropertyName();
        if (ident != null) {
            Class identType = this.getPropertyType(ident);
            this.identifier = new GrailsHibernateDomainClassProperty(this, ident);
            this.identifier.setIdentity(true);
            this.identifier.setType(identType);
            this.propertyMap.put(ident, this.identifier);
        }
        int versionIndex = metaData.getVersionProperty();
        String versionPropertyName = null;
        if (versionIndex > -1) {
            versionPropertyName = metaData.getPropertyNames()[versionIndex];
            this.version = new GrailsHibernateDomainClassProperty(this, versionPropertyName);
            this.version.setType(this.getPropertyType(versionPropertyName));
        }
        for (String propertyName : propertyNames = metaData.getPropertyNames()) {
            PropertyDescriptor pd;
            if (propertyName.equals(ident) || versionPropertyName != null && propertyName.equals(versionPropertyName) || (pd = GrailsClassUtils.getProperty(clazz, (String)propertyName)) == null) continue;
            GrailsHibernateDomainClassProperty prop = new GrailsHibernateDomainClassProperty(this, propertyName);
            prop.setType(this.getPropertyType(propertyName));
            Type hibernateType = metaData.getPropertyType(propertyName);
            if (hibernateType.isAssociationType()) {
                block9: {
                    prop.setAssociation(true);
                    AssociationType assType = (AssociationType)hibernateType;
                    if (assType instanceof AnyType) continue;
                    try {
                        String associatedEntity = assType.getAssociatedEntityName((SessionFactoryImplementor)sessionFactory);
                        ClassMetadata associatedMetaData = sessionFactory.getClassMetadata(associatedEntity);
                        prop.setRelatedClassType(associatedMetaData.getMappedClass(EntityMode.POJO));
                    }
                    catch (MappingException me) {
                        if (!hibernateType.isCollectionType()) break block9;
                        prop.setRelatedClassType(Collection.class);
                    }
                }
                if (hibernateType.isCollectionType()) {
                    prop.setOneToMany(true);
                } else if (hibernateType.isEntityType()) {
                    prop.setManyToOne(true);
                    prop.setOneToOne(true);
                }
            }
            this.propertyMap.put(propertyName, prop);
        }
        this.properties = this.propertyMap.values().toArray(new GrailsDomainClassProperty[this.propertyMap.size()]);
        this.evaluateConstraints();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public String getSessionFactoryName() {
        return this.sessionFactoryName;
    }

    private void evaluateConstraints() {
        Map existing = (Map)this.getPropertyOrStaticPropertyOrFieldValue("constraints", Map.class);
        this.constraints = existing == null ? this.getConstraintsEvaluator().evaluate(this.getClazz(), this.getProperties()) : existing;
    }

    private ConstraintsEvaluator getConstraintsEvaluator() {
        ApplicationContext context;
        if (this.application != null && this.application.getMainContext() != null && (context = this.application.getMainContext()).containsBean("orgGrailsBeansConstraintsEvaluator")) {
            return (ConstraintsEvaluator)context.getBean("orgGrailsBeansConstraintsEvaluator", ConstraintsEvaluator.class);
        }
        return new DefaultConstraintEvaluator();
    }

    public boolean isOwningClass(Class domainClass) {
        return false;
    }

    public GrailsDomainClassProperty[] getProperties() {
        return this.properties;
    }

    @Deprecated
    public GrailsDomainClassProperty[] getPersistantProperties() {
        return this.properties;
    }

    public GrailsDomainClassProperty[] getPersistentProperties() {
        return this.properties;
    }

    public GrailsDomainClassProperty getIdentifier() {
        return this.identifier;
    }

    public GrailsDomainClassProperty getVersion() {
        return this.version;
    }

    public GrailsDomainClassProperty getPersistentProperty(String name) {
        if (this.propertyMap.containsKey(name)) {
            return this.propertyMap.get(name);
        }
        return null;
    }

    public GrailsDomainClassProperty getPropertyByName(String name) {
        if (this.propertyMap.containsKey(name)) {
            return this.propertyMap.get(name);
        }
        throw new InvalidPropertyException("No property found for name [" + name + "] for class [" + this.getClazz() + "]");
    }

    public String getFieldName(String propertyName) {
        return this.getPropertyByName(propertyName).getFieldName();
    }

    public boolean hasSubClasses() {
        return false;
    }

    public Map getMappedBy() {
        return Collections.emptyMap();
    }

    public boolean hasPersistentProperty(String propertyName) {
        for (GrailsDomainClassProperty persistantProperty : this.properties) {
            if (!persistantProperty.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public void setMappingStrategy(String strategy) {
    }

    public boolean isOneToMany(String propertyName) {
        GrailsDomainClassProperty prop = this.getPropertyByName(propertyName);
        return prop != null && prop.isOneToMany();
    }

    public boolean isManyToOne(String propertyName) {
        GrailsDomainClassProperty prop = this.getPropertyByName(propertyName);
        return prop != null && prop.isManyToOne();
    }

    public boolean isBidirectional(String propertyName) {
        return false;
    }

    public Class<?> getRelatedClassType(String propertyName) {
        GrailsDomainClassProperty prop = this.getPropertyByName(propertyName);
        if (prop == null) {
            return null;
        }
        return prop.getReferencedPropertyType();
    }

    public Map getConstrainedProperties() {
        return this.constraints;
    }

    public Validator getValidator() {
        if (this.validator == null) {
            GrailsDomainClassValidator gdcv = new GrailsDomainClassValidator();
            gdcv.setDomainClass((GrailsDomainClass)this);
            MessageSource messageSource = (MessageSource)this.application.getMainContext().getBean(MessageSource.class);
            gdcv.setMessageSource(messageSource);
            this.validator = gdcv;
        }
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public String getMappingStrategy() {
        return HIBERNATE;
    }

    public Set getSubClasses() {
        return this.subClasses;
    }

    public void refreshConstraints() {
        this.evaluateConstraints();
    }

    public boolean isRoot() {
        return this.getClazz().getSuperclass().equals(Object.class);
    }

    public Map getAssociationMap() {
        return Collections.emptyMap();
    }
}

