/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.Context;
import javax.sql.DataSource;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.naming.ContextBindings;

public class DataSourceRealm
extends RealmBase {
    private String preparedRoles = null;
    private String preparedCredentials = null;
    protected String dataSourceName = null;
    protected static final String info = "org.apache.catalina.realm.DataSourceRealm/1.0";
    protected boolean localDataSource = false;
    protected static final String name = "DataSourceRealm";
    protected String roleNameCol = null;
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public boolean getLocalDataSource() {
        return this.localDataSource;
    }

    public void setLocalDataSource(boolean localDataSource) {
        this.localDataSource = localDataSource;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        if (username == null || credentials == null) {
            return null;
        }
        Connection dbConnection = null;
        dbConnection = this.open();
        if (dbConnection == null) {
            return null;
        }
        Principal principal = this.authenticate(dbConnection, username, credentials);
        this.close(dbConnection);
        return principal;
    }

    protected Principal authenticate(Connection dbConnection, String username, String credentials) {
        String dbCredentials = this.getPassword(dbConnection, username);
        boolean validated = false;
        validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(dbCredentials) : this.digest(credentials).equals(dbCredentials);
        if (validated) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateSuccess", username));
            }
        } else {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", username));
            }
            return null;
        }
        ArrayList<String> list = this.getRoles(dbConnection, username);
        return new GenericPrincipal(username, credentials, list);
    }

    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            if (!dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
        }
        catch (SQLException e) {
            this.containerLog.error((Object)"Exception committing connection before closing:", (Throwable)e);
        }
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.close"), (Throwable)e);
        }
    }

    protected Connection open() {
        try {
            Context context = null;
            if (this.localDataSource) {
                context = ContextBindings.getClassLoader();
                context = (Context)context.lookup("comp/env");
            } else {
                context = this.getServer().getGlobalNamingContext();
            }
            DataSource dataSource = (DataSource)context.lookup(this.dataSourceName);
            return dataSource.getConnection();
        }
        catch (Exception e) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)e);
            return null;
        }
    }

    @Override
    protected String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getPassword(String username) {
        Connection dbConnection = null;
        dbConnection = this.open();
        if (dbConnection == null) {
            return null;
        }
        try {
            String string = this.getPassword(dbConnection, username);
            return string;
        }
        finally {
            this.close(dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String getPassword(Connection dbConnection, String username) {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        String dbCredentials = null;
        stmt = this.credentials(dbConnection, username);
        rs = stmt.executeQuery();
        if (rs.next()) {
            dbCredentials = rs.getString(1);
        }
        String string = dbCredentials != null ? dbCredentials.trim() : null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", username));
        }
        return string;
        catch (SQLException e) {
            try {
                this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", username));
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", username));
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e3) {
                this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", username));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Principal getPrincipal(String username) {
        Connection dbConnection = this.open();
        if (dbConnection == null) {
            return new GenericPrincipal(username, null, null);
        }
        try {
            GenericPrincipal genericPrincipal = new GenericPrincipal(username, this.getPassword(dbConnection, username), this.getRoles(dbConnection, username));
            return genericPrincipal;
        }
        finally {
            this.close(dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String> getRoles(String username) {
        Connection dbConnection = null;
        dbConnection = this.open();
        if (dbConnection == null) {
            return null;
        }
        try {
            ArrayList<String> arrayList = this.getRoles(dbConnection, username);
            return arrayList;
        }
        finally {
            this.close(dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ArrayList<String> getRoles(Connection dbConnection, String username) {
        Object role;
        if (this.allRolesMode != RealmBase.AllRolesMode.STRICT_MODE && !this.isRoleStoreDefined()) {
            return null;
        }
        ResultSet rs = null;
        PreparedStatement stmt = null;
        ArrayList<String> list = null;
        stmt = this.roles(dbConnection, username);
        rs = stmt.executeQuery();
        list = new ArrayList<String>();
        while (rs.next()) {
            role = rs.getString(1);
            if (role == null) continue;
            list.add(((String)role).trim());
        }
        role = list;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", username));
        }
        return role;
        catch (SQLException e) {
            try {
                this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", username));
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", username));
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e3) {
                this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", username));
            }
        }
        return null;
    }

    private PreparedStatement credentials(Connection dbConnection, String username) throws SQLException {
        PreparedStatement credentials = dbConnection.prepareStatement(this.preparedCredentials);
        credentials.setString(1, username);
        return credentials;
    }

    private PreparedStatement roles(Connection dbConnection, String username) throws SQLException {
        PreparedStatement roles = dbConnection.prepareStatement(this.preparedRoles);
        roles.setString(1, username);
        return roles;
    }

    private boolean isRoleStoreDefined() {
        return this.userRoleTable != null || this.roleNameCol != null;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        StringBuilder temp = new StringBuilder("SELECT ");
        temp.append(this.roleNameCol);
        temp.append(" FROM ");
        temp.append(this.userRoleTable);
        temp.append(" WHERE ");
        temp.append(this.userNameCol);
        temp.append(" = ?");
        this.preparedRoles = temp.toString();
        temp = new StringBuilder("SELECT ");
        temp.append(this.userCredCol);
        temp.append(" FROM ");
        temp.append(this.userTable);
        temp.append(" WHERE ");
        temp.append(this.userNameCol);
        temp.append(" = ?");
        this.preparedCredentials = temp.toString();
        super.startInternal();
    }
}

