/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import javax.net.ssl.SSLEngine;
import org.apache.coyote.ActionCode;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalNioInputBuffer;
import org.apache.coyote.http11.InternalNioOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11NioProcessor
extends AbstractHttp11Processor<NioChannel> {
    private static final Log log = LogFactory.getLog(Http11NioProcessor.class);
    protected SSLSupport sslSupport;
    protected InternalNioInputBuffer inputBuffer = null;
    protected InternalNioOutputBuffer outputBuffer = null;
    protected NioEndpoint.SendfileData sendfileData = null;
    protected SocketWrapper<NioChannel> socket = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11NioProcessor(int maxHttpHeaderSize, NioEndpoint endpoint, int maxTrailerSize) {
        super(endpoint);
        this.inputBuffer = new InternalNioInputBuffer(this.request, maxHttpHeaderSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalNioOutputBuffer(this.response, maxHttpHeaderSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(maxTrailerSize);
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        long soTimeout = this.endpoint.getSoTimeout();
        RequestInfo rp = this.request.getRequestProcessor();
        NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getSocket().getAttachment(false);
        try {
            rp.setStage(3);
            boolean bl = this.error = !this.adapter.event(this.request, this.response, status);
            if (!this.error && attach != null) {
                attach.setComet(this.comet);
                if (this.comet) {
                    Integer comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout");
                    if (comettimeout != null) {
                        attach.setTimeout(comettimeout.longValue());
                    }
                } else if (this.keepAlive) {
                    attach.setTimeout(this.keepAliveTimeout);
                } else {
                    attach.setTimeout(soTimeout);
                }
            }
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error || status == SocketStatus.STOP) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            if (this.keepAlive) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    @Override
    protected void resetTimeouts() {
        NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getSocket().getAttachment(false);
        if (!this.error && attach != null && this.asyncStateMachine.isAsyncDispatching()) {
            long soTimeout = this.endpoint.getSoTimeout();
            if (this.keepAlive) {
                attach.setTimeout(this.keepAliveTimeout);
            } else {
                attach.setTimeout(soTimeout);
            }
        }
    }

    @Override
    protected boolean disableKeepAlive() {
        return false;
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        if (this.inputBuffer.getParsingRequestLinePhase() < 2) {
            if (this.socket.getLastAccess() > -1L || this.keptAlive) {
                this.socket.setTimeout(this.endpoint.getKeepAliveTimeout());
            }
        } else {
            this.readComplete = false;
            this.socket.setTimeout(this.endpoint.getSoTimeout());
        }
        if (!this.endpoint.isPaused()) {
            return true;
        }
        this.response.setStatus(503);
        this.adapter.log(this.request, this.response, 0L);
        this.error = true;
        return false;
    }

    @Override
    protected void setSocketTimeout(int timeout) throws IOException {
        this.socket.getSocket().getIOChannel().socket().setSoTimeout(timeout);
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<NioChannel> socketWrapper) {
        NioEndpoint.KeyAttachment attach;
        SelectionKey key = socketWrapper.getSocket().getIOChannel().keyFor(socketWrapper.getSocket().getPoller().getSelector());
        if (key != null && (attach = (NioEndpoint.KeyAttachment)key.attachment()) != null) {
            Integer comettimeout;
            attach.setComet(this.comet);
            if (this.comet && (comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout")) != null) {
                attach.setTimeout(comettimeout.longValue());
            }
        }
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<NioChannel> socketWrapper) {
        if (this.sendfileData != null && !this.error) {
            ((NioEndpoint.KeyAttachment)socketWrapper).setSendfileData(this.sendfileData);
            this.sendfileData.keepAlive = this.keepAlive;
            SelectionKey key = socketWrapper.getSocket().getIOChannel().keyFor(socketWrapper.getSocket().getPoller().getSelector());
            this.openSocket = socketWrapper.getSocket().getPoller().processSendfile(key, (NioEndpoint.KeyAttachment)socketWrapper, true);
            return true;
        }
        return false;
    }

    @Override
    public void recycleInternal() {
        this.socket = null;
        this.sendfileData = null;
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.REQ_HOST_ADDR_ATTRIBUTE) {
            InetAddress inetAddr;
            if (this.remoteAddr == null && this.socket != null && (inetAddr = this.socket.getSocket().getIOChannel().socket().getInetAddress()) != null) {
                this.remoteAddr = inetAddr.getHostAddress();
            }
            this.request.remoteAddr().setString(this.remoteAddr);
        } else if (actionCode == ActionCode.REQ_LOCAL_NAME_ATTRIBUTE) {
            InetAddress inetAddr;
            if (this.localName == null && this.socket != null && (inetAddr = this.socket.getSocket().getIOChannel().socket().getLocalAddress()) != null) {
                this.localName = inetAddr.getHostName();
            }
            this.request.localName().setString(this.localName);
        } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
            if (this.remoteHost == null && this.socket != null) {
                InetAddress inetAddr = this.socket.getSocket().getIOChannel().socket().getInetAddress();
                if (inetAddr != null) {
                    this.remoteHost = inetAddr.getHostName();
                }
                if (this.remoteHost == null) {
                    if (this.remoteAddr != null) {
                        this.remoteHost = this.remoteAddr;
                    } else {
                        this.request.remoteHost().recycle();
                    }
                }
            }
            this.request.remoteHost().setString(this.remoteHost);
        } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
            if (this.localAddr == null) {
                this.localAddr = this.socket.getSocket().getIOChannel().socket().getLocalAddress().getHostAddress();
            }
            this.request.localAddr().setString(this.localAddr);
        } else if (actionCode == ActionCode.REQ_REMOTEPORT_ATTRIBUTE) {
            if (this.remotePort == -1 && this.socket != null) {
                this.remotePort = this.socket.getSocket().getIOChannel().socket().getPort();
            }
            this.request.setRemotePort(this.remotePort);
        } else if (actionCode == ActionCode.REQ_LOCALPORT_ATTRIBUTE) {
            if (this.localPort == -1 && this.socket != null) {
                this.localPort = this.socket.getSocket().getIOChannel().socket().getLocalPort();
            }
            this.request.setLocalPort(this.localPort);
        } else if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
            try {
                if (this.sslSupport != null) {
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
            }
        } else if (actionCode == ActionCode.REQ_SSL_CERTIFICATE) {
            if (this.sslSupport != null) {
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                SecureNioChannel sslChannel = (SecureNioChannel)this.socket.getSocket();
                SSLEngine engine = sslChannel.getSslEngine();
                if (!engine.getNeedClientAuth()) {
                    engine.setNeedClientAuth(true);
                    try {
                        sslChannel.rehandshake(this.endpoint.getSoTimeout());
                        this.sslSupport = ((NioEndpoint)this.endpoint).getHandler().getSslImplementation().getSSLSupport(engine.getSession());
                    }
                    catch (IOException ioe) {
                        log.warn((Object)sm.getString("http11processor.socket.sslreneg", ioe));
                    }
                }
                try {
                    Object[] sslO = this.sslSupport.getPeerCertificateChain(false);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        } else if (actionCode == ActionCode.AVAILABLE) {
            this.request.setAvailable(this.inputBuffer.available());
        } else if (actionCode == ActionCode.COMET_BEGIN) {
            this.comet = true;
        } else if (actionCode == ActionCode.COMET_END) {
            this.comet = false;
        } else if (actionCode == ActionCode.COMET_CLOSE) {
            if (this.socket == null || this.socket.getSocket().getAttachment(false) == null) {
                return;
            }
            NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getSocket().getAttachment(false);
            attach.setCometOps(512);
            RequestInfo rp = this.request.getRequestProcessor();
            if (rp.getStage() != 3) {
                this.socket.getSocket().getPoller().add(this.socket.getSocket());
            }
        } else if (actionCode == ActionCode.COMET_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            if (this.socket == null || this.socket.getSocket().getAttachment(false) == null) {
                return;
            }
            NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getSocket().getAttachment(false);
            long timeout = (Long)param;
            RequestInfo rp = this.request.getRequestProcessor();
            if (rp.getStage() != 3) {
                attach.setTimeout(timeout);
            }
        } else if (actionCode == ActionCode.ASYNC_COMPLETE) {
            if (this.asyncStateMachine.asyncComplete()) {
                ((NioEndpoint)this.endpoint).processSocket(this.socket.getSocket(), SocketStatus.OPEN, true);
            }
        } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            if (this.socket == null || this.socket.getSocket().getAttachment(false) == null) {
                return;
            }
            NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)this.socket.getSocket().getAttachment(false);
            long timeout = (Long)param;
            attach.setTimeout(timeout);
        } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
            ((NioEndpoint)this.endpoint).processSocket(this.socket.getSocket(), SocketStatus.OPEN, true);
        }
    }

    @Override
    protected void prepareRequestInternal() {
        this.sendfileData = null;
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (fileName != null) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = new NioEndpoint.SendfileData();
            this.sendfileData.fileName = fileName;
            this.sendfileData.pos = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.length = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end") - this.sendfileData.pos;
            return true;
        }
        return false;
    }

    @Override
    protected void setSocketWrapper(SocketWrapper<NioChannel> socketWrapper) {
        this.socket = socketWrapper;
    }

    @Override
    protected AbstractInputBuffer<NioChannel> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<NioChannel> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }
}

