/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter.regex;

import java.util.Locale;
import java.util.ResourceBundle;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.regex.RegexReplaceFilter;

public abstract class LocaleRegexReplaceFilter
extends RegexReplaceFilter {
    private String modifier = null;

    protected abstract String getLocaleKey();

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getModifier() {
        return this.modifier;
    }

    protected boolean isSingleLine() {
        return false;
    }

    protected ResourceBundle getInputBundle() {
        Locale inputLocale = (Locale)this.initialContext.get("RenderContext.input_locale");
        String inputName = (String)this.initialContext.get("RenderContext.input_bundle_name");
        return ResourceBundle.getBundle(inputName, inputLocale);
    }

    protected ResourceBundle getOutputBundle() {
        String outputName = (String)this.initialContext.get("RenderContext.output_bundle_name");
        Locale outputLocale = (Locale)this.initialContext.get("RenderContext.output_locale");
        return ResourceBundle.getBundle(outputName, outputLocale);
    }

    public void setInitialContext(InitialRenderContext context) {
        super.setInitialContext(context);
        this.clearRegex();
        ResourceBundle outputMessages = this.getOutputBundle();
        ResourceBundle inputMessages = this.getInputBundle();
        String match = inputMessages.getString(this.getLocaleKey() + (this.modifier != null ? "." + this.modifier : "") + ".match");
        String print = outputMessages.getString(this.getLocaleKey() + (this.modifier != null ? "." + this.modifier : "") + ".print");
        this.addRegex(match, print, !this.isSingleLine());
    }

    private String getKeyModifier() {
        return this.modifier;
    }
}

