/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded.agent;

import com.springsource.loaded.FileChangeListener;
import com.springsource.loaded.TypeRegistry;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

class Watcher
implements Runnable {
    long lastScanTime;
    private static long interval = 1100L;
    List<File> watchListFiles = new ArrayList<File>();
    List<Long> watchListLMTs = new ArrayList<Long>();
    FileChangeListener listener;
    private boolean timeToStop = false;
    public boolean paused = false;
    private Thread thread = null;
    private int typeRegistryId;
    private String classloadername;
    private int registryLivenessCount = 0;
    private static int registryLivenessCountInterval = 300;

    public Watcher(FileChangeListener listener, int typeRegistryId, String classloadername) {
        this.listener = listener;
        this.typeRegistryId = typeRegistryId;
        this.classloadername = classloadername;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFile(File fileToWatch) {
        if (!fileToWatch.exists()) {
            return false;
        }
        Watcher watcher = this;
        synchronized (watcher) {
            int insertionPos = this.findPosition(fileToWatch);
            if (insertionPos == -1) {
                this.watchListFiles.add(fileToWatch);
                this.watchListLMTs.add(fileToWatch.lastModified());
            } else {
                this.watchListFiles.add(insertionPos, fileToWatch);
                this.watchListLMTs.add(insertionPos, fileToWatch.lastModified());
            }
            return true;
        }
    }

    public void updateName() {
        if (this.thread != null) {
            this.thread.setName("FileSystemWatcher: files=#" + this.watchListFiles.size() + " cl=" + this.classloadername);
        }
    }

    private int findPosition(File file) {
        String filename = file.getName();
        int len = this.watchListFiles.size();
        if (len == 0) {
            return 0;
        }
        int f = 0;
        while (f < len) {
            File file2 = this.watchListFiles.get(f);
            int cmp = file2.getName().compareTo(filename);
            if (cmp > 0) {
                return f;
            }
            ++f;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.timeToStop) {
            ++this.registryLivenessCount;
            if (this.registryLivenessCount % registryLivenessCountInterval == 0) {
                if (!TypeRegistry.typeRegistryExistsForId(this.typeRegistryId)) {
                    return;
                }
                this.registryLivenessCount = 0;
            }
            try {
                Thread.sleep(interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.paused) continue;
            Watcher watcher = this;
            synchronized (watcher) {
                int len = this.watchListFiles.size();
                int f = 0;
                while (f < len) {
                    File file = this.watchListFiles.get(f);
                    long lastModTime = file.lastModified();
                    if (lastModTime > this.watchListLMTs.get(f)) {
                        this.watchListLMTs.set(f, lastModTime);
                        this.determineChangesSince(file, this.lastScanTime);
                    }
                    ++f;
                }
                this.lastScanTime = System.currentTimeMillis();
            }
        }
    }

    private void determineChangesSince(File file, long lastScanTime) {
        try {
            this.listener.fileChanged(file);
            if (file.isDirectory()) {
                File[] filesOfInterest;
                File[] fileArray = filesOfInterest = file.listFiles(new RecentChangeFilter(lastScanTime));
                int n = filesOfInterest.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        this.determineChangesSince(f, lastScanTime);
                    } else {
                        this.listener.fileChanged(f);
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable t) {
            new RuntimeException("FileWatcher caught serious error, see cause.", t).printStackTrace();
        }
    }

    public void timeToStop() {
        this.timeToStop = true;
    }

    static class RecentChangeFilter
    implements FileFilter {
        private long lastScanTime;

        public RecentChangeFilter(long lastScanTime) {
            this.lastScanTime = lastScanTime;
        }

        public boolean accept(File pathname) {
            return pathname.lastModified() > this.lastScanTime;
        }
    }
}

