/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.ParameterCreationListener;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class GrailsWebRequestFilter
extends OncePerRequestFilter {
    Collection<ParameterCreationListener> paramListenerBeans;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        LocaleContextHolder.setLocale((Locale)request.getLocale());
        GrailsWebRequest webRequest = new GrailsWebRequest(request, response, this.getServletContext());
        this.configureParameterCreationListeners(webRequest);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bound Grails request context to thread: " + request));
        }
        try {
            WebUtils.storeGrailsWebRequest(webRequest);
            FlashScope fs = webRequest.getAttributes().getFlashScope((ServletRequest)request);
            fs.next();
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            Object var7_6 = null;
            webRequest.requestCompleted();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            webRequest.requestCompleted();
            WebUtils.clearGrailsWebRequest();
            LocaleContextHolder.setLocale(null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleared Grails thread-bound request context: " + request));
            }
            throw throwable;
        }
        WebUtils.clearGrailsWebRequest();
        LocaleContextHolder.setLocale(null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cleared Grails thread-bound request context: " + request));
        }
    }

    private void configureParameterCreationListeners(GrailsWebRequest webRequest) {
        if (this.paramListenerBeans != null) {
            for (ParameterCreationListener creationListenerBean : this.paramListenerBeans) {
                webRequest.addParameterListener(creationListenerBean);
            }
        } else {
            this.logger.warn((Object)"paramListenerBeans isn't initialized.");
        }
    }

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        this.initialize();
    }

    public void initialize() {
        WebApplicationContext appCtx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        if (appCtx != null) {
            this.paramListenerBeans = appCtx.getBeansOfType(ParameterCreationListener.class).values();
        } else {
            this.logger.warn((Object)"appCtx not found in servletContext");
        }
    }
}

