/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsTagLibClass;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsTagLibClass;

public class TagLibArtefactHandler
extends ArtefactHandlerAdapter {
    private static Log LOG = LogFactory.getLog(TagLibArtefactHandler.class);
    public static final String PLUGIN_NAME = "groovyPages";
    public static final String TYPE = "TagLib";
    private Map<String, GrailsTagLibClass> tag2libMap = new HashMap<String, GrailsTagLibClass>();
    private Map<String, GrailsTagLibClass> namespace2tagLibMap = new HashMap<String, GrailsTagLibClass>();

    public TagLibArtefactHandler() {
        super(TYPE, GrailsTagLibClass.class, DefaultGrailsTagLibClass.class, TYPE);
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public void initialize(ArtefactInfo artefacts) {
        this.tag2libMap = new HashMap<String, GrailsTagLibClass>();
        for (GrailsClass aClass : artefacts.getGrailsClasses()) {
            GrailsTagLibClass taglibClass = (GrailsTagLibClass)aClass;
            String namespace = taglibClass.getNamespace();
            this.namespace2tagLibMap.put(namespace, taglibClass);
            for (String o : taglibClass.getTagNames()) {
                String tagName = namespace + ":" + o;
                if (!this.tag2libMap.containsKey(tagName)) {
                    this.tag2libMap.put(tagName, taglibClass);
                    continue;
                }
                GrailsTagLibClass current = this.tag2libMap.get(tagName);
                if (taglibClass.equals(current)) continue;
                LOG.info((Object)("There are conflicting tags: " + taglibClass.getFullName() + "." + tagName + " vs. " + current.getFullName() + "." + tagName + ". The former will take precedence."));
                this.tag2libMap.put(tagName, taglibClass);
            }
        }
    }

    public GrailsClass getArtefactForFeature(Object feature) {
        GrailsTagLibClass tagLib = this.tag2libMap.get(feature);
        if (tagLib != null) {
            return tagLib;
        }
        return this.namespace2tagLibMap.get(feature);
    }
}

