/* Copyright (C) 2010 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.grails.datastore.mapping.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.AssociationIndexer;

/**
 * A lazy loaded set.
 *
 * @author Graeme Rocher
 * @since 1.0
 */
@SuppressWarnings("rawtypes")
public class PersistentSet extends AbstractPersistentCollection implements Set {

    public PersistentSet(Class childType, Session session, Collection collection) {
        super(childType, session, collection);
    }

    public PersistentSet(Collection keys, Class childType, Session session) {
        super(keys, childType, session, new HashSet());
    }

    public PersistentSet(Serializable associationKey, Session session, AssociationIndexer indexer) {
        super(associationKey, session, indexer, new HashSet());
    }
}
